/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import com.sun.naming.internal.ResourceManager;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.NamingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContext
implements Context {
    protected Hashtable<Object, Object> myProps = null;
    protected Context defaultInitCtx = null;
    protected boolean gotDefault = false;

    protected InitialContext(boolean lazy) throws NamingException {
        if (!lazy) {
            this.init(null);
        }
    }

    public InitialContext() throws NamingException {
        this.init(null);
    }

    public InitialContext(Hashtable<?, ?> environment) throws NamingException {
        if (environment != null) {
            environment = (Hashtable)environment.clone();
        }
        this.init(environment);
    }

    protected void init(Hashtable<?, ?> environment) throws NamingException {
        this.myProps = ResourceManager.getInitialEnvironment(environment);
        if (this.myProps.get("java.naming.factory.initial") != null) {
            this.getDefaultInitCtx();
        }
    }

    public static <T> T doLookup(Name name) throws NamingException {
        return (T)new InitialContext().lookup(name);
    }

    public static <T> T doLookup(String name) throws NamingException {
        return (T)new InitialContext().lookup(name);
    }

    private static String getURLScheme(String str) {
        int colon_posn = str.indexOf(58);
        int slash_posn = str.indexOf(47);
        if (colon_posn > 0 && (slash_posn == -1 || colon_posn < slash_posn)) {
            return str.substring(0, colon_posn);
        }
        return null;
    }

    protected Context getDefaultInitCtx() throws NamingException {
        if (!this.gotDefault) {
            this.defaultInitCtx = NamingManager.getInitialContext(this.myProps);
            this.gotDefault = true;
        }
        if (this.defaultInitCtx == null) {
            throw new NoInitialContextException();
        }
        return this.defaultInitCtx;
    }

    protected Context getURLOrDefaultInitCtx(String name) throws NamingException {
        Context ctx;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        String scheme = InitialContext.getURLScheme(name);
        if (scheme != null && (ctx = NamingManager.getURLContext(scheme, this.myProps)) != null) {
            return ctx;
        }
        return this.getDefaultInitCtx();
    }

    protected Context getURLOrDefaultInitCtx(Name name) throws NamingException {
        Context ctx;
        String first;
        String scheme;
        if (NamingManager.hasInitialContextFactoryBuilder()) {
            return this.getDefaultInitCtx();
        }
        if (name.size() > 0 && (scheme = InitialContext.getURLScheme(first = name.get(0))) != null && (ctx = NamingManager.getURLContext(scheme, this.myProps)) != null) {
            return ctx;
        }
        return this.getDefaultInitCtx();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookup(name);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).bind(name, obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.getURLOrDefaultInitCtx(name).rebind(name, obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).unbind(name);
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.getURLOrDefaultInitCtx(oldName).rename(oldName, newName);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).list(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).listBindings(name);
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.getURLOrDefaultInitCtx(name).destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).createSubcontext(name);
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).lookupLink(name);
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getURLOrDefaultInitCtx(name).getNameParser(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return name;
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return (Name)name.clone();
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        this.myProps.put(propName, propVal);
        return this.getDefaultInitCtx().addToEnvironment(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        this.myProps.remove(propName);
        return this.getDefaultInitCtx().removeFromEnvironment(propName);
    }

    @Override
    public Hashtable<?, ?> getEnvironment() throws NamingException {
        return this.getDefaultInitCtx().getEnvironment();
    }

    @Override
    public void close() throws NamingException {
        this.myProps = null;
        if (this.defaultInitCtx != null) {
            this.defaultInitCtx.close();
            this.defaultInitCtx = null;
        }
        this.gotDefault = false;
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.getDefaultInitCtx().getNameInNamespace();
    }
}

