/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl;

import com.sun.net.ssl.X509KeyManager;
import java.net.Socket;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLEngine;

final class X509KeyManagerJavaxWrapper
implements javax.net.ssl.X509KeyManager {
    private X509KeyManager theX509KeyManager;

    X509KeyManagerJavaxWrapper(X509KeyManager obj) {
        this.theX509KeyManager = obj;
    }

    public String[] getClientAliases(String keyType, Principal[] issuers) {
        return this.theX509KeyManager.getClientAliases(keyType, issuers);
    }

    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        if (keyTypes == null) {
            return null;
        }
        for (int i = 0; i < keyTypes.length; ++i) {
            String retval = this.theX509KeyManager.chooseClientAlias(keyTypes[i], issuers);
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
        if (keyTypes == null) {
            return null;
        }
        for (int i = 0; i < keyTypes.length; ++i) {
            String retval = this.theX509KeyManager.chooseClientAlias(keyTypes[i], issuers);
            if (retval == null) continue;
            return retval;
        }
        return null;
    }

    public String[] getServerAliases(String keyType, Principal[] issuers) {
        return this.theX509KeyManager.getServerAliases(keyType, issuers);
    }

    public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
        if (keyType == null) {
            return null;
        }
        return this.theX509KeyManager.chooseServerAlias(keyType, issuers);
    }

    public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
        if (keyType == null) {
            return null;
        }
        return this.theX509KeyManager.chooseServerAlias(keyType, issuers);
    }

    public X509Certificate[] getCertificateChain(String alias) {
        return this.theX509KeyManager.getCertificateChain(alias);
    }

    public PrivateKey getPrivateKey(String alias) {
        return this.theX509KeyManager.getPrivateKey(alias);
    }
}

