/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MXBeanLookup;
import com.sun.jmx.mbeanserver.OpenConverter;
import java.io.InvalidObjectException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

final class ConvertingMethod {
    private static final String[] noStrings = new String[0];
    private final Method method;
    private final OpenConverter returnConverter;
    private final OpenConverter[] paramConverters;
    private final boolean paramConversionIsIdentity;

    static ConvertingMethod from(Method m) {
        try {
            return new ConvertingMethod(m);
        }
        catch (OpenDataException ode) {
            String msg = "Method " + m.getDeclaringClass().getName() + "." + m.getName() + " has parameter or return type that " + "cannot be translated into an open type";
            throw new IllegalArgumentException(msg, ode);
        }
    }

    Method getMethod() {
        return this.method;
    }

    Descriptor getDescriptor() {
        return Introspector.descriptorForElement(this.method);
    }

    Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    String getName() {
        return this.method.getName();
    }

    OpenType getOpenReturnType() {
        return this.returnConverter.getOpenType();
    }

    OpenType[] getOpenParameterTypes() {
        OpenType[] types = new OpenType[this.paramConverters.length];
        for (int i = 0; i < this.paramConverters.length; ++i) {
            types[i] = this.paramConverters[i].getOpenType();
        }
        return types;
    }

    void checkCallFromOpen() throws IllegalArgumentException {
        try {
            for (OpenConverter paramConverter : this.paramConverters) {
                paramConverter.checkReconstructible();
            }
        }
        catch (InvalidObjectException e) {
            throw new IllegalArgumentException(e);
        }
    }

    void checkCallToOpen() throws IllegalArgumentException {
        try {
            this.returnConverter.checkReconstructible();
        }
        catch (InvalidObjectException e) {
            throw new IllegalArgumentException(e);
        }
    }

    String[] getOpenSignature() {
        if (this.paramConverters.length == 0) {
            return noStrings;
        }
        String[] sig = new String[this.paramConverters.length];
        for (int i = 0; i < this.paramConverters.length; ++i) {
            sig[i] = this.paramConverters[i].getOpenClass().getName();
        }
        return sig;
    }

    final Object toOpenReturnValue(MXBeanLookup lookup, Object ret) throws OpenDataException {
        return this.returnConverter.toOpenValue(lookup, ret);
    }

    final Object fromOpenReturnValue(MXBeanLookup lookup, Object ret) throws InvalidObjectException {
        return this.returnConverter.fromOpenValue(lookup, ret);
    }

    final Object[] toOpenParameters(MXBeanLookup lookup, Object[] params) throws OpenDataException {
        if (this.paramConversionIsIdentity || params == null) {
            return params;
        }
        Object[] oparams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            oparams[i] = this.paramConverters[i].toOpenValue(lookup, params[i]);
        }
        return oparams;
    }

    final Object[] fromOpenParameters(MXBeanLookup lookup, Object[] params) throws InvalidObjectException {
        if (this.paramConversionIsIdentity || params == null) {
            return params;
        }
        Object[] jparams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            jparams[i] = this.paramConverters[i].fromOpenValue(lookup, params[i]);
        }
        return jparams;
    }

    final Object toOpenParameter(MXBeanLookup lookup, Object param, int paramNo) throws OpenDataException {
        return this.paramConverters[paramNo].toOpenValue(lookup, param);
    }

    final Object fromOpenParameter(MXBeanLookup lookup, Object param, int paramNo) throws InvalidObjectException {
        return this.paramConverters[paramNo].fromOpenValue(lookup, param);
    }

    Object invokeWithOpenReturn(MXBeanLookup lookup, Object obj, Object[] params) throws MBeanException, IllegalAccessException, InvocationTargetException {
        Object[] javaParams;
        try {
            javaParams = this.fromOpenParameters(lookup, params);
        }
        catch (InvalidObjectException e) {
            String msg = this.methodName() + ": cannot convert parameters " + "from open values: " + e;
            throw new MBeanException(e, msg);
        }
        Object javaReturn = this.method.invoke(obj, javaParams);
        try {
            return this.returnConverter.toOpenValue(lookup, javaReturn);
        }
        catch (OpenDataException e) {
            String msg = this.methodName() + ": cannot convert return " + "value to open value: " + e;
            throw new MBeanException(e, msg);
        }
    }

    private String methodName() {
        return this.method.getDeclaringClass() + "." + this.method.getName();
    }

    private ConvertingMethod(Method m) throws OpenDataException {
        this.method = m;
        this.returnConverter = OpenConverter.toConverter(m.getGenericReturnType());
        Type[] params = m.getGenericParameterTypes();
        this.paramConverters = new OpenConverter[params.length];
        boolean identity = true;
        for (int i = 0; i < params.length; ++i) {
            this.paramConverters[i] = OpenConverter.toConverter(params[i]);
            identity &= this.paramConverters[i].isIdentity();
        }
        this.paramConversionIsIdentity = identity;
    }
}

