/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuBarUI;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUI;
import com.sun.java.swing.plaf.windows.WindowsMenuItemUIAccessor;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicMenuUI;

public class WindowsMenuUI
extends BasicMenuUI {
    protected Integer menuBarHeight;
    protected boolean hotTrackingOn;
    final WindowsMenuItemUIAccessor accessor = new WindowsMenuItemUIAccessor(){

        public JMenuItem getMenuItem() {
            return WindowsMenuUI.this.menuItem;
        }

        public TMSchema.State getState(JMenuItem menu) {
            TMSchema.State state = menu.isEnabled() ? TMSchema.State.NORMAL : TMSchema.State.DISABLED;
            ButtonModel model = menu.getModel();
            if (model.isArmed() || model.isSelected()) {
                state = menu.isEnabled() ? TMSchema.State.PUSHED : TMSchema.State.DISABLEDPUSHED;
            } else if (model.isRollover() && ((JMenu)menu).isTopLevelMenu()) {
                TMSchema.State stateTmp = state;
                state = menu.isEnabled() ? TMSchema.State.HOT : TMSchema.State.DISABLEDHOT;
                for (MenuElement menuElement : ((JMenuBar)menu.getParent()).getSubElements()) {
                    if (!((JMenuItem)menuElement).isSelected()) continue;
                    state = stateTmp;
                    break;
                }
            }
            if (!((JMenu)menu).isTopLevelMenu()) {
                if (state == TMSchema.State.PUSHED) {
                    state = TMSchema.State.HOT;
                } else if (state == TMSchema.State.DISABLEDPUSHED) {
                    state = TMSchema.State.DISABLEDHOT;
                }
            }
            if (((JMenu)menu).isTopLevelMenu() && WindowsMenuItemUI.isVistaPainting() && !WindowsMenuBarUI.isActive(menu)) {
                state = TMSchema.State.DISABLED;
            }
            return state;
        }

        public TMSchema.Part getPart(JMenuItem menuItem) {
            return ((JMenu)menuItem).isTopLevelMenu() ? TMSchema.Part.MP_BARITEM : TMSchema.Part.MP_POPUPITEM;
        }
    };

    public static ComponentUI createUI(JComponent x) {
        return new WindowsMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        if (!WindowsLookAndFeel.isClassicWindows()) {
            this.menuItem.setRolloverEnabled(true);
        }
        this.menuBarHeight = UIManager.getInt("MenuBar.height");
        Object obj = UIManager.get("MenuBar.rolloverEnabled");
        this.hotTrackingOn = obj instanceof Boolean ? (Boolean)obj : true;
    }

    protected void paintBackground(Graphics g, JMenuItem menuItem, Color bgColor) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintBackground(this.accessor, g, menuItem, bgColor);
            return;
        }
        JMenu menu = (JMenu)menuItem;
        ButtonModel model = menu.getModel();
        if (WindowsLookAndFeel.isClassicWindows() || !menu.isTopLevelMenu() || XPStyle.getXP() != null && (model.isArmed() || model.isSelected())) {
            super.paintBackground(g, menu, bgColor);
            return;
        }
        Color oldColor = g.getColor();
        int menuWidth = menu.getWidth();
        int menuHeight = menu.getHeight();
        UIDefaults table = UIManager.getLookAndFeelDefaults();
        Color highlight = table.getColor("controlLtHighlight");
        Color shadow = table.getColor("controlShadow");
        g.setColor(menu.getBackground());
        g.fillRect(0, 0, menuWidth, menuHeight);
        if (menu.isOpaque()) {
            if (model.isArmed() || model.isSelected()) {
                g.setColor(shadow);
                g.drawLine(0, 0, menuWidth - 1, 0);
                g.drawLine(0, 0, 0, menuHeight - 2);
                g.setColor(highlight);
                g.drawLine(menuWidth - 1, 0, menuWidth - 1, menuHeight - 2);
                g.drawLine(0, menuHeight - 2, menuWidth - 1, menuHeight - 2);
            } else if (model.isRollover() && model.isEnabled()) {
                boolean otherMenuSelected = false;
                MenuElement[] menus = ((JMenuBar)menu.getParent()).getSubElements();
                for (int i = 0; i < menus.length; ++i) {
                    if (!((JMenuItem)menus[i]).isSelected()) continue;
                    otherMenuSelected = true;
                    break;
                }
                if (!otherMenuSelected) {
                    if (XPStyle.getXP() != null) {
                        g.setColor(this.selectionBackground);
                        g.fillRect(0, 0, menuWidth, menuHeight);
                    } else {
                        g.setColor(highlight);
                        g.drawLine(0, 0, menuWidth - 1, 0);
                        g.drawLine(0, 0, 0, menuHeight - 2);
                        g.setColor(shadow);
                        g.drawLine(menuWidth - 1, 0, menuWidth - 1, menuHeight - 2);
                        g.drawLine(0, menuHeight - 2, menuWidth - 1, menuHeight - 2);
                    }
                }
            }
        }
        g.setColor(oldColor);
    }

    protected void paintText(Graphics g, JMenuItem menuItem, Rectangle textRect, String text) {
        if (WindowsMenuItemUI.isVistaPainting()) {
            WindowsMenuItemUI.paintText(this.accessor, g, menuItem, textRect, text);
            return;
        }
        JMenu menu = (JMenu)menuItem;
        ButtonModel model = menuItem.getModel();
        Color oldColor = g.getColor();
        boolean paintRollover = model.isRollover();
        if (paintRollover && menu.isTopLevelMenu()) {
            MenuElement[] menus = ((JMenuBar)menu.getParent()).getSubElements();
            for (int i = 0; i < menus.length; ++i) {
                if (!((JMenuItem)menus[i]).isSelected()) continue;
                paintRollover = false;
                break;
            }
        }
        if (model.isSelected() && (WindowsLookAndFeel.isClassicWindows() || !menu.isTopLevelMenu()) || XPStyle.getXP() != null && (paintRollover || model.isArmed() || model.isSelected())) {
            g.setColor(this.selectionForeground);
        }
        WindowsGraphicsUtils.paintText(g, menuItem, textRect, text, 0);
        g.setColor(oldColor);
    }

    protected MouseInputListener createMouseInputListener(JComponent c) {
        return new WindowsMouseInputHandler();
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        Dimension d = super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        if (c instanceof JMenu && ((JMenu)c).isTopLevelMenu() && this.menuBarHeight != null && d.height < this.menuBarHeight) {
            d.height = this.menuBarHeight;
        }
        return d;
    }

    protected class WindowsMouseInputHandler
    extends BasicMenuUI.MouseInputHandler {
        protected WindowsMouseInputHandler() {
            super(WindowsMenuUI.this);
        }

        public void mouseEntered(MouseEvent evt) {
            super.mouseEntered(evt);
            JMenu menu = (JMenu)evt.getSource();
            if (WindowsMenuUI.this.hotTrackingOn && menu.isTopLevelMenu() && menu.isRolloverEnabled()) {
                menu.getModel().setRollover(true);
                WindowsMenuUI.this.menuItem.repaint();
            }
        }

        public void mouseExited(MouseEvent evt) {
            super.mouseExited(evt);
            JMenu menu = (JMenu)evt.getSource();
            ButtonModel model = menu.getModel();
            if (menu.isRolloverEnabled()) {
                model.setRollover(false);
                WindowsMenuUI.this.menuItem.repaint();
            }
        }
    }
}

