/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.naming.pcosnaming;

import com.sun.corba.se.impl.logging.NamingSystemException;
import com.sun.corba.se.impl.naming.cosnaming.InterOperableNamingImpl;
import com.sun.corba.se.impl.naming.cosnaming.NamingContextDataStore;
import com.sun.corba.se.impl.naming.cosnaming.NamingUtils;
import com.sun.corba.se.impl.naming.namingutil.INSURLHandler;
import com.sun.corba.se.impl.naming.pcosnaming.InternalBindingKey;
import com.sun.corba.se.impl.naming.pcosnaming.InternalBindingValue;
import com.sun.corba.se.impl.naming.pcosnaming.NameService;
import com.sun.corba.se.impl.naming.pcosnaming.PersistentBindingIterator;
import com.sun.corba.se.impl.naming.pcosnaming.ServantManagerImpl;
import com.sun.corba.se.spi.orb.ORB;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.BindingIterator;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.BindingTypeHolder;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class NamingContextImpl
extends NamingContextExtPOA
implements NamingContextDataStore,
Serializable {
    private transient ORB orb;
    private final String objKey;
    private final Hashtable theHashtable = new Hashtable();
    private transient NameService theNameServiceHandle;
    private transient ServantManagerImpl theServantManagerImplHandle;
    private transient InterOperableNamingImpl insImpl;
    private transient NamingSystemException readWrapper;
    private transient NamingSystemException updateWrapper;
    private static POA biPOA = null;
    private static boolean debug;

    public NamingContextImpl(ORB orb, String objKey, NameService theNameService, ServantManagerImpl theServantManagerImpl) throws Exception {
        this.orb = orb;
        this.readWrapper = NamingSystemException.get(orb, "naming.read");
        this.updateWrapper = NamingSystemException.get(orb, "naming.update");
        debug = true;
        this.objKey = objKey;
        this.theNameServiceHandle = theNameService;
        this.theServantManagerImplHandle = theServantManagerImpl;
        this.insImpl = new InterOperableNamingImpl();
    }

    InterOperableNamingImpl getINSImpl() {
        if (this.insImpl == null) {
            this.insImpl = new InterOperableNamingImpl();
        }
        return this.insImpl;
    }

    public void setRootNameService(NameService theNameService) {
        this.theNameServiceHandle = theNameService;
    }

    public void setORB(ORB theOrb) {
        this.orb = theOrb;
    }

    public void setServantManagerImpl(ServantManagerImpl theServantManagerImpl) {
        this.theServantManagerImplHandle = theServantManagerImpl;
    }

    public POA getNSPOA() {
        return this.theNameServiceHandle.getNSPOA();
    }

    public void bind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (obj == null) {
            throw this.updateWrapper.objectIsNull();
        }
        if (debug) {
            NamingContextImpl.dprint("bind " + NamingContextImpl.nameToString(n) + " to " + obj);
        }
        NamingContextImpl impl = this;
        this.doBind(impl, n, obj, false, BindingType.nobject);
    }

    public void bind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (nc == null) {
            throw this.updateWrapper.objectIsNull();
        }
        NamingContextImpl impl = this;
        this.doBind(impl, n, nc, false, BindingType.ncontext);
    }

    public void rebind(NameComponent[] n, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (obj == null) {
            throw this.updateWrapper.objectIsNull();
        }
        try {
            if (debug) {
                NamingContextImpl.dprint("rebind " + NamingContextImpl.nameToString(n) + " to " + obj);
            }
            NamingContextImpl impl = this;
            this.doBind(impl, n, obj, true, BindingType.nobject);
        }
        catch (AlreadyBound ex) {
            throw this.updateWrapper.namingCtxRebindAlreadyBound(ex);
        }
    }

    public void rebind_context(NameComponent[] n, NamingContext nc) throws NotFound, CannotProceed, InvalidName {
        try {
            if (debug) {
                NamingContextImpl.dprint("rebind_context " + NamingContextImpl.nameToString(n) + " to " + nc);
            }
            NamingContextImpl impl = this;
            this.doBind(impl, n, nc, true, BindingType.ncontext);
        }
        catch (AlreadyBound ex) {
            throw this.updateWrapper.namingCtxRebindAlreadyBound(ex);
        }
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (debug) {
            NamingContextImpl.dprint("resolve " + NamingContextImpl.nameToString(n));
        }
        NamingContextImpl impl = this;
        return NamingContextImpl.doResolve(impl, n);
    }

    public void unbind(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (debug) {
            NamingContextImpl.dprint("unbind " + NamingContextImpl.nameToString(n));
        }
        NamingContextImpl impl = this;
        NamingContextImpl.doUnbind(impl, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        NamingContextImpl impl;
        if (debug) {
            NamingContextImpl.dprint("list(" + how_many + ")");
        }
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            impl.List(how_many, bl, bi);
        }
        if (debug && bl.value != null) {
            NamingContextImpl.dprint("list(" + how_many + ") -> bindings[" + bl.value.length + "] + iterator: " + bi.value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NamingContext new_context() {
        NamingContextImpl impl;
        if (debug) {
            NamingContextImpl.dprint("new_context()");
        }
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            return impl.NewContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingContext bind_new_context(NameComponent[] n) throws NotFound, AlreadyBound, CannotProceed, InvalidName {
        NamingContext nc = null;
        NamingContext rnc = null;
        try {
            if (debug) {
                NamingContextImpl.dprint("bind_new_context " + NamingContextImpl.nameToString(n));
            }
            nc = this.new_context();
            this.bind_context(n, nc);
            rnc = nc;
            nc = null;
        }
        finally {
            try {
                if (nc != null) {
                    nc.destroy();
                }
            }
            catch (NotEmpty e) {}
        }
        return rnc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws NotEmpty {
        NamingContextImpl impl;
        if (debug) {
            NamingContextImpl.dprint("destroy ");
        }
        NamingContextImpl namingContextImpl = impl = this;
        synchronized (namingContextImpl) {
            if (!impl.IsEmpty()) {
                throw new NotEmpty();
            }
            impl.Destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBind(NamingContextDataStore impl, NameComponent[] n, Object obj, boolean rebind, BindingType bt) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
                throw new InvalidName();
            }
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                BindingTypeHolder bth = new BindingTypeHolder();
                if (rebind) {
                    Object objRef = impl.Resolve(n[0], bth);
                    if (objRef != null) {
                        if (bth.value.value() == BindingType.nobject.value()) {
                            if (bt.value() == BindingType.ncontext.value()) {
                                throw new NotFound(NotFoundReason.not_context, n);
                            }
                        } else if (bt.value() == BindingType.nobject.value()) {
                            throw new NotFound(NotFoundReason.not_object, n);
                        }
                        impl.Unbind(n[0]);
                    }
                } else if (impl.Resolve(n[0], bth) != null) {
                    throw new AlreadyBound();
                }
                impl.Bind(n[0], obj, bt);
            }
        } else {
            NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
            NameComponent[] tail = new NameComponent[n.length - 1];
            System.arraycopy(n, 1, tail, 0, n.length - 1);
            switch (bt.value()) {
                case 0: {
                    if (rebind) {
                        context.rebind(tail, obj);
                        break;
                    }
                    context.bind(tail, obj);
                    break;
                }
                case 1: {
                    NamingContext objContext = (NamingContext)obj;
                    if (rebind) {
                        context.rebind_context(tail, objContext);
                        break;
                    }
                    context.bind_context(tail, objContext);
                    break;
                }
                default: {
                    throw this.updateWrapper.namingCtxBadBindingtype();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doResolve(NamingContextDataStore impl, NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        Object obj = null;
        BindingTypeHolder bth = new BindingTypeHolder();
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                obj = impl.Resolve(n[0], bth);
            }
            if (obj == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
            return obj;
        }
        if (n[1].id.length() == 0 && n[1].kind.length() == 0) {
            throw new InvalidName();
        }
        NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
        NameComponent[] tail = new NameComponent[n.length - 1];
        System.arraycopy(n, 1, tail, 0, n.length - 1);
        return context.resolve(tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doUnbind(NamingContextDataStore impl, NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        if (n.length < 1) {
            throw new InvalidName();
        }
        if (n.length == 1) {
            if (n[0].id.length() == 0 && n[0].kind.length() == 0) {
                throw new InvalidName();
            }
            Object objRef = null;
            NamingContextDataStore namingContextDataStore = impl;
            synchronized (namingContextDataStore) {
                objRef = impl.Unbind(n[0]);
            }
            if (objRef == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
            return;
        }
        NamingContext context = NamingContextImpl.resolveFirstAsContext(impl, n);
        NameComponent[] tail = new NameComponent[n.length - 1];
        System.arraycopy(n, 1, tail, 0, n.length - 1);
        context.unbind(tail);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static NamingContext resolveFirstAsContext(NamingContextDataStore impl, NameComponent[] n) throws NotFound {
        Object topRef = null;
        BindingTypeHolder bth = new BindingTypeHolder();
        NamingContext context = null;
        NamingContextDataStore namingContextDataStore = impl;
        synchronized (namingContextDataStore) {
            topRef = impl.Resolve(n[0], bth);
            if (topRef == null) {
                throw new NotFound(NotFoundReason.missing_node, n);
            }
        }
        if (bth.value != BindingType.ncontext) {
            throw new NotFound(NotFoundReason.not_context, n);
        }
        try {
            context = NamingContextHelper.narrow(topRef);
        }
        catch (BAD_PARAM ex) {
            throw new NotFound(NotFoundReason.not_context, n);
        }
        return context;
    }

    public static String nameToString(NameComponent[] name) {
        StringBuffer s = new StringBuffer("{");
        if (name != null || name.length > 0) {
            for (int i = 0; i < name.length; ++i) {
                if (i > 0) {
                    s.append(",");
                }
                s.append("[").append(name[i].id).append(",").append(name[i].kind).append("]");
            }
        }
        s.append("}");
        return s.toString();
    }

    private static void dprint(String msg) {
        NamingUtils.dprint("NamingContextImpl(" + Thread.currentThread().getName() + " at " + System.currentTimeMillis() + " ems): " + msg);
    }

    public void Bind(NameComponent n, Object obj, BindingType bt) {
        if (obj == null) {
            return;
        }
        InternalBindingKey key = new InternalBindingKey(n);
        try {
            InternalBindingValue value;
            if (bt.value() == 0) {
                value = new InternalBindingValue(bt, this.orb.object_to_string(obj));
                value.setObjectRef(obj);
            } else {
                String theNCKey = this.theNameServiceHandle.getObjectKey(obj);
                value = new InternalBindingValue(bt, theNCKey);
                value.setObjectRef(obj);
            }
            InternalBindingValue oldValue = this.theHashtable.put(key, value);
            if (oldValue != null) {
                throw this.updateWrapper.namingCtxRebindAlreadyBound();
            }
            try {
                this.theServantManagerImplHandle.updateContext(this.objKey, this);
            }
            catch (Exception e) {
                throw this.updateWrapper.bindUpdateContextFailed(e);
            }
        }
        catch (Exception e) {
            throw this.updateWrapper.bindFailure(e);
        }
    }

    public Object Resolve(NameComponent n, BindingTypeHolder bth) throws SystemException {
        Object theObjectFromStringifiedReference;
        block7: {
            if (n.id.length() == 0 && n.kind.length() == 0) {
                bth.value = BindingType.ncontext;
                return this.theNameServiceHandle.getObjectReferenceFromKey(this.objKey);
            }
            InternalBindingKey key = new InternalBindingKey(n);
            InternalBindingValue value = (InternalBindingValue)this.theHashtable.get(key);
            if (value == null) {
                return null;
            }
            theObjectFromStringifiedReference = null;
            bth.value = value.theBindingType;
            try {
                if (value.strObjectRef.startsWith("NC")) {
                    bth.value = BindingType.ncontext;
                    return this.theNameServiceHandle.getObjectReferenceFromKey(value.strObjectRef);
                }
                theObjectFromStringifiedReference = value.getObjectRef();
                if (theObjectFromStringifiedReference != null) break block7;
                try {
                    theObjectFromStringifiedReference = this.orb.string_to_object(value.strObjectRef);
                    value.setObjectRef(theObjectFromStringifiedReference);
                }
                catch (Exception e) {
                    throw this.readWrapper.resolveConversionFailure(CompletionStatus.COMPLETED_MAYBE, e);
                }
            }
            catch (Exception e) {
                throw this.readWrapper.resolveFailure(CompletionStatus.COMPLETED_MAYBE, e);
            }
        }
        return theObjectFromStringifiedReference;
    }

    public Object Unbind(NameComponent n) throws SystemException {
        try {
            InternalBindingKey key = new InternalBindingKey(n);
            InternalBindingValue value = null;
            try {
                value = (InternalBindingValue)this.theHashtable.remove(key);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.theServantManagerImplHandle.updateContext(this.objKey, this);
            if (value == null) {
                return null;
            }
            if (value.strObjectRef.startsWith("NC")) {
                this.theServantManagerImplHandle.readInContext(value.strObjectRef);
                Object theObjectFromStringfiedReference = this.theNameServiceHandle.getObjectReferenceFromKey(value.strObjectRef);
                return theObjectFromStringfiedReference;
            }
            Object theObjectFromStringifiedReference = value.getObjectRef();
            if (theObjectFromStringifiedReference == null) {
                theObjectFromStringifiedReference = this.orb.string_to_object(value.strObjectRef);
            }
            return theObjectFromStringifiedReference;
        }
        catch (Exception e) {
            throw this.updateWrapper.unbindFailure(CompletionStatus.COMPLETED_MAYBE, e);
        }
    }

    public void List(int how_many, BindingListHolder bl, BindingIteratorHolder bi) throws SystemException {
        if (biPOA == null) {
            this.createbiPOA();
        }
        try {
            BindingIterator bindingRef;
            PersistentBindingIterator bindingIterator = new PersistentBindingIterator(this.orb, (Hashtable)this.theHashtable.clone(), biPOA);
            bindingIterator.list(how_many, bl);
            byte[] objectId = biPOA.activate_object(bindingIterator);
            Object obj = biPOA.id_to_reference(objectId);
            bi.value = bindingRef = BindingIteratorHelper.narrow(obj);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.readWrapper.transNcListGotExc(e);
        }
    }

    private synchronized void createbiPOA() {
        if (biPOA != null) {
            return;
        }
        try {
            POA rootPOA = (POA)this.orb.resolve_initial_references("RootPOA");
            rootPOA.the_POAManager().activate();
            int i = 0;
            Policy[] poaPolicy = new Policy[3];
            poaPolicy[i++] = rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT);
            poaPolicy[i++] = rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.SYSTEM_ID);
            poaPolicy[i++] = rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.RETAIN);
            biPOA = rootPOA.create_POA("BindingIteratorPOA", null, poaPolicy);
            biPOA.the_POAManager().activate();
        }
        catch (Exception e) {
            throw this.readWrapper.namingCtxBindingIteratorCreate(e);
        }
    }

    public NamingContext NewContext() throws SystemException {
        try {
            return this.theNameServiceHandle.NewContext();
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.updateWrapper.transNcNewctxGotExc(e);
        }
    }

    public void Destroy() throws SystemException {
    }

    public String to_string(NameComponent[] n) throws InvalidName {
        if (n == null || n.length == 0) {
            throw new InvalidName();
        }
        String theStringifiedName = this.getINSImpl().convertToString(n);
        if (theStringifiedName == null) {
            throw new InvalidName();
        }
        return theStringifiedName;
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        NameComponent[] theNameComponents = this.getINSImpl().convertToNameComponent(sn);
        if (theNameComponents == null || theNameComponents.length == 0) {
            throw new InvalidName();
        }
        for (int i = 0; i < theNameComponents.length; ++i) {
            if (theNameComponents[i].id != null && theNameComponents[i].id.length() != 0 || theNameComponents[i].kind != null && theNameComponents[i].kind.length() != 0) continue;
            throw new InvalidName();
        }
        return theNameComponents;
    }

    public String to_url(String addr, String sn) throws InvalidAddress, InvalidName {
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        if (addr == null) {
            throw new InvalidAddress();
        }
        String urlBasedAddress = null;
        try {
            urlBasedAddress = this.getINSImpl().createURLBasedAddress(addr, sn);
        }
        catch (Exception e) {
            urlBasedAddress = null;
        }
        try {
            INSURLHandler.getINSURLHandler().parseURL(urlBasedAddress);
        }
        catch (BAD_PARAM e) {
            throw new InvalidAddress();
        }
        return urlBasedAddress;
    }

    public Object resolve_str(String sn) throws NotFound, CannotProceed, InvalidName {
        Object theObject = null;
        if (sn == null || sn.length() == 0) {
            throw new InvalidName();
        }
        NameComponent[] theNameComponents = this.getINSImpl().convertToNameComponent(sn);
        if (theNameComponents == null || theNameComponents.length == 0) {
            throw new InvalidName();
        }
        theObject = this.resolve(theNameComponents);
        return theObject;
    }

    public boolean IsEmpty() {
        return this.theHashtable.isEmpty();
    }

    public void printSize() {
        System.out.println("Hashtable Size = " + this.theHashtable.size());
        Enumeration e = this.theHashtable.keys();
        while (e.hasMoreElements()) {
            InternalBindingValue thevalue = (InternalBindingValue)this.theHashtable.get(e.nextElement());
            if (thevalue == null) continue;
            System.out.println("value = " + thevalue.strObjectRef);
        }
    }
}

