/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.PKCS11Exception;
import sun.security.util.Debug;

final class SessionManager {
    private static final int DEFAULT_MAX_SESSIONS = 32;
    private static final Debug debug = Debug.getInstance("pkcs11");
    private final Token token;
    private final int maxSessions;
    private int activeSessions;
    private final Pool objSessions;
    private final Pool opSessions;
    private int maxActiveSessions;
    private final long openSessionFlags;

    SessionManager(Token token) {
        long n;
        if (token.isWriteProtected()) {
            this.openSessionFlags = 4L;
            n = token.tokenInfo.ulMaxSessionCount;
        } else {
            this.openSessionFlags = 6L;
            n = token.tokenInfo.ulMaxRwSessionCount;
        }
        if (n == 0L) {
            n = Integer.MAX_VALUE;
        } else if (n == -1L || n < 0L) {
            n = 32L;
        }
        this.maxSessions = (int)Math.min(n, Integer.MAX_VALUE);
        this.token = token;
        this.objSessions = new Pool(this);
        this.opSessions = new Pool(this);
    }

    boolean lowMaxSessions() {
        return this.maxSessions <= 32;
    }

    synchronized Session getObjSession() throws PKCS11Exception {
        Session session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        session = this.openSession();
        return this.ensureValid(session);
    }

    synchronized Session getOpSession() throws PKCS11Exception {
        Session session = this.opSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        if (this.activeSessions < this.maxSessions) {
            session = this.openSession();
            return this.ensureValid(session);
        }
        session = this.objSessions.poll();
        if (session != null) {
            return this.ensureValid(session);
        }
        throw new ProviderException("Could not obtain session");
    }

    private Session ensureValid(Session session) {
        session.id();
        return session;
    }

    synchronized Session killSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (debug != null) {
            String location = new Exception().getStackTrace()[2].toString();
            System.out.println("Killing session (" + location + ") active: " + this.activeSessions);
        }
        try {
            this.closeSession(session);
            return null;
        }
        catch (PKCS11Exception e) {
            throw new ProviderException(e);
        }
    }

    synchronized Session releaseSession(Session session) {
        if (session == null || !this.token.isValid()) {
            return null;
        }
        if (session.hasObjects()) {
            this.objSessions.release(session);
        } else {
            this.opSessions.release(session);
        }
        return null;
    }

    synchronized void demoteObjSession(Session session) {
        boolean present;
        if (!this.token.isValid()) {
            return;
        }
        if (debug != null) {
            System.out.println("Demoting session, active: " + this.activeSessions);
        }
        if (!(present = this.objSessions.remove(session))) {
            return;
        }
        this.opSessions.release(session);
    }

    private Session openSession() throws PKCS11Exception {
        if (this.activeSessions >= this.maxSessions) {
            throw new ProviderException("No more sessions available");
        }
        long id = this.token.p11.C_OpenSession(this.token.provider.slotID, this.openSessionFlags, null, null);
        Session session = new Session(this.token, id);
        ++this.activeSessions;
        if (debug != null && this.activeSessions > this.maxActiveSessions) {
            this.maxActiveSessions = this.activeSessions;
            if (this.maxActiveSessions % 10 == 0) {
                System.out.println("Open sessions: " + this.maxActiveSessions);
            }
        }
        return session;
    }

    private void closeSession(Session session) throws PKCS11Exception {
        if (session.hasObjects()) {
            throw new ProviderException("Internal error: close session with active objects");
        }
        this.token.p11.C_CloseSession(session.id());
        --this.activeSessions;
    }

    private static final class Pool {
        private final SessionManager mgr;
        private final List<Session> pool;

        Pool(SessionManager mgr) {
            this.mgr = mgr;
            this.pool = new ArrayList<Session>();
        }

        boolean remove(Session session) {
            return this.pool.remove(session);
        }

        Session poll() {
            int n = this.pool.size();
            if (n == 0) {
                return null;
            }
            Session session = this.pool.remove(n - 1);
            return session;
        }

        void release(Session session) {
            this.pool.add(session);
            if (session.hasObjects()) {
                return;
            }
            int n = this.pool.size();
            if (n < 5) {
                return;
            }
            Session oldestSession = this.pool.get(0);
            long time = System.currentTimeMillis();
            if (session.isLive(time) && oldestSession.isLive(time)) {
                return;
            }
            Collections.sort(this.pool);
            int i = 0;
            PKCS11Exception exc = null;
            while (i < n - 1 && !(oldestSession = this.pool.get(i)).isLive(time)) {
                ++i;
                try {
                    this.mgr.closeSession(oldestSession);
                }
                catch (PKCS11Exception e) {
                    exc = e;
                }
            }
            if (debug != null) {
                System.out.println("Closing " + i + " idle sessions, active: " + this.mgr.activeSessions);
            }
            List<Session> subList = this.pool.subList(0, i);
            subList.clear();
            if (exc != null) {
                throw new ProviderException(exc);
            }
        }
    }
}

