/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.Token;
import sun.security.pkcs11.wrapper.CK_ATTRIBUTE;
import sun.security.pkcs11.wrapper.PKCS11Exception;

final class P11SecretKeyFactory
extends SecretKeyFactorySpi {
    private final Token token;
    private final String algorithm;
    private static final Map<String, Long> keyTypes = new HashMap<String, Long>();

    P11SecretKeyFactory(Token token, String algorithm) {
        this.token = token;
        this.algorithm = algorithm;
    }

    private static void addKeyType(String name, long id) {
        Long l = id;
        keyTypes.put(name, l);
        keyTypes.put(name.toUpperCase(Locale.ENGLISH), l);
    }

    static long getKeyType(String algorithm) {
        Long l = keyTypes.get(algorithm);
        if (l == null && (l = keyTypes.get(algorithm = algorithm.toUpperCase(Locale.ENGLISH))) == null) {
            if (algorithm.startsWith("HMAC")) {
                return 2147483427L;
            }
            if (algorithm.startsWith("SSLMAC")) {
                return 2147483428L;
            }
        }
        return l != null ? l : -1L;
    }

    static P11Key convertKey(Token token, Key key, String algorithm) throws InvalidKeyException {
        P11Key p11Key;
        long algorithmType;
        token.ensureValid();
        if (key == null) {
            throw new InvalidKeyException("Key must not be null");
        }
        if (!(key instanceof SecretKey)) {
            throw new InvalidKeyException("Key must be a SecretKey");
        }
        if (algorithm == null) {
            algorithm = key.getAlgorithm();
            algorithmType = P11SecretKeyFactory.getKeyType(algorithm);
        } else {
            long keyAlgorithmType;
            algorithmType = P11SecretKeyFactory.getKeyType(algorithm);
            if (algorithmType != (keyAlgorithmType = P11SecretKeyFactory.getKeyType(key.getAlgorithm())) && algorithmType != 2147483427L && algorithmType != 2147483428L) {
                throw new InvalidKeyException("Key algorithm must be " + algorithm);
            }
        }
        if (key instanceof P11Key) {
            P11Key p11Key2 = (P11Key)key;
            if (p11Key2.token == token) {
                return p11Key2;
            }
        }
        if ((p11Key = token.secretCache.get(key)) != null) {
            return p11Key;
        }
        if (!"RAW".equals(key.getFormat())) {
            throw new InvalidKeyException("Encoded format must be RAW");
        }
        byte[] encoded = key.getEncoded();
        p11Key = P11SecretKeyFactory.createKey(token, encoded, algorithm, algorithmType);
        token.secretCache.put(key, p11Key);
        return p11Key;
    }

    static void fixDESParity(byte[] key, int offset) {
        for (int i = 0; i < 8; ++i) {
            int b = key[offset] & 0xFE;
            b |= Integer.bitCount(b) & 1 ^ 1;
            key[offset++] = (byte)b;
        }
    }

    private static P11Key createKey(Token token, byte[] encoded, String algorithm, long keyType) throws InvalidKeyException {
        P11Key p11Key;
        int keyLength;
        int n = encoded.length;
        switch ((int)keyType) {
            case 18: {
                if (n < 5 || n > 128) {
                    throw new InvalidKeyException("ARCFOUR key length must be between 5 and 128 bytes");
                }
                keyLength = n << 3;
                break;
            }
            case 19: {
                if (n != 8) {
                    throw new InvalidKeyException("DES key length must be 8 bytes");
                }
                keyLength = 56;
                P11SecretKeyFactory.fixDESParity(encoded, 0);
                break;
            }
            case 21: {
                if (n == 16) {
                    keyType = 20L;
                } else if (n == 24) {
                    keyType = 21L;
                    P11SecretKeyFactory.fixDESParity(encoded, 16);
                } else {
                    throw new InvalidKeyException("DESede key length must be 16 or 24 bytes");
                }
                P11SecretKeyFactory.fixDESParity(encoded, 0);
                P11SecretKeyFactory.fixDESParity(encoded, 8);
                keyLength = n * 7;
                break;
            }
            case 31: {
                if (n != 16 && n != 24 && n != 32) {
                    throw new InvalidKeyException("AES key length must be 16, 24, or 32 bytes");
                }
                keyLength = n << 3;
                break;
            }
            case 32: {
                if (n < 5 || n > 56) {
                    throw new InvalidKeyException("Blowfish key length must be between 5 and 56 bytes");
                }
                keyLength = n << 3;
                break;
            }
            case 16: 
            case 2147483429: 
            case 2147483430: 
            case 0x7FFFFF27: {
                keyType = 16L;
                keyLength = n << 3;
                break;
            }
            case 2147483427: 
            case 2147483428: {
                if (n == 0) {
                    throw new InvalidKeyException("MAC keys must not be empty");
                }
                keyType = 16L;
                keyLength = n << 3;
                break;
            }
            default: {
                throw new InvalidKeyException("Unknown algorithm " + algorithm);
            }
        }
        Session session = null;
        try {
            P11Key p11Key2;
            CK_ATTRIBUTE[] attributes = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(0L, 4L), new CK_ATTRIBUTE(256L, keyType), new CK_ATTRIBUTE(17L, encoded)};
            attributes = token.getAttributes("import", 4L, keyType, attributes);
            session = token.getObjSession();
            long keyID = token.p11.C_CreateObject(session.id(), attributes);
            p11Key = p11Key2 = (P11Key)((Object)P11Key.secretKey(session, keyID, algorithm, keyLength, attributes));
            token.releaseSession(session);
        }
        catch (PKCS11Exception e) {
            try {
                throw new InvalidKeyException("Could not create key", e);
            }
            catch (Throwable throwable) {
                token.releaseSession(session);
                throw throwable;
            }
        }
        return p11Key;
    }

    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        this.token.ensureValid();
        if (keySpec == null) {
            throw new InvalidKeySpecException("KeySpec must not be null");
        }
        if (keySpec instanceof SecretKeySpec) {
            try {
                P11Key key = P11SecretKeyFactory.convertKey(this.token, (SecretKey)((Object)keySpec), this.algorithm);
                return (SecretKey)((Object)key);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeySpecException(e);
            }
        }
        if (this.algorithm.equalsIgnoreCase("DES")) {
            if (keySpec instanceof DESKeySpec) {
                byte[] keyBytes = ((DESKeySpec)keySpec).getKey();
                keySpec = new SecretKeySpec(keyBytes, "DES");
                return this.engineGenerateSecret(keySpec);
            }
        } else if (this.algorithm.equalsIgnoreCase("DESede") && keySpec instanceof DESedeKeySpec) {
            byte[] keyBytes = ((DESedeKeySpec)keySpec).getKey();
            keySpec = new SecretKeySpec(keyBytes, "DESede");
            return this.engineGenerateSecret(keySpec);
        }
        throw new InvalidKeySpecException("Unsupported spec: " + keySpec.getClass().getName());
    }

    private byte[] getKeyBytes(SecretKey key) throws InvalidKeySpecException {
        try {
            key = this.engineTranslateKey(key);
            if (!"RAW".equals(key.getFormat())) {
                throw new InvalidKeySpecException("Could not obtain key bytes");
            }
            byte[] k = key.getEncoded();
            return k;
        }
        catch (InvalidKeyException e) {
            throw new InvalidKeySpecException(e);
        }
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        block10: {
            this.token.ensureValid();
            if (key == null || keySpec == null) {
                throw new InvalidKeySpecException("key and keySpec must not be null");
            }
            if (SecretKeySpec.class.isAssignableFrom(keySpec)) {
                return new SecretKeySpec(this.getKeyBytes(key), this.algorithm);
            }
            if (this.algorithm.equalsIgnoreCase("DES")) {
                try {
                    if (DESKeySpec.class.isAssignableFrom(keySpec)) {
                        return new DESKeySpec(this.getKeyBytes(key));
                    }
                    break block10;
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
            if (this.algorithm.equalsIgnoreCase("DESede")) {
                try {
                    if (DESedeKeySpec.class.isAssignableFrom(keySpec)) {
                        return new DESedeKeySpec(this.getKeyBytes(key));
                    }
                }
                catch (InvalidKeyException e) {
                    throw new InvalidKeySpecException(e);
                }
            }
        }
        throw new InvalidKeySpecException("Unsupported spec: " + keySpec.getName());
    }

    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        return (SecretKey)((Object)P11SecretKeyFactory.convertKey(this.token, key, this.algorithm));
    }

    static {
        P11SecretKeyFactory.addKeyType("RC4", 18L);
        P11SecretKeyFactory.addKeyType("ARCFOUR", 18L);
        P11SecretKeyFactory.addKeyType("DES", 19L);
        P11SecretKeyFactory.addKeyType("DESede", 21L);
        P11SecretKeyFactory.addKeyType("AES", 31L);
        P11SecretKeyFactory.addKeyType("Blowfish", 32L);
        P11SecretKeyFactory.addKeyType("RC2", 17L);
        P11SecretKeyFactory.addKeyType("IDEA", 26L);
        P11SecretKeyFactory.addKeyType("TlsPremasterSecret", 2147483429L);
        P11SecretKeyFactory.addKeyType("TlsRsaPremasterSecret", 2147483430L);
        P11SecretKeyFactory.addKeyType("TlsMasterSecret", 0x7FFFFF27L);
        P11SecretKeyFactory.addKeyType("Generic", 16L);
    }
}

