/*
 * Decompiled with CFR 0.152.
 */
package sun.swing.icon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;

public class SortArrowIcon
implements Icon,
UIResource,
Serializable {
    private static final int ARROW_HEIGHT = 5;
    private static final int X_PADDING = 7;
    private boolean ascending;
    private Color color;
    private String colorKey;

    public SortArrowIcon(boolean ascending, Color color) {
        this.ascending = ascending;
        this.color = color;
        if (color == null) {
            throw new IllegalArgumentException();
        }
    }

    public SortArrowIcon(boolean ascending, String colorKey) {
        this.ascending = ascending;
        this.colorKey = colorKey;
        if (colorKey == null) {
            throw new IllegalArgumentException();
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.getColor());
        int startX = 7 + x + 2;
        if (this.ascending) {
            int startY = y;
            g.fillRect(startX, startY, 1, 1);
            for (int line = 1; line < 5; ++line) {
                g.fillRect(startX - line, startY + line, line + line + 1, 1);
            }
        } else {
            int startY = y + 5 - 1;
            g.fillRect(startX, startY, 1, 1);
            for (int line = 1; line < 5; ++line) {
                g.fillRect(startX - line, startY - line, line + line + 1, 1);
            }
        }
    }

    public int getIconWidth() {
        return 17;
    }

    public int getIconHeight() {
        return 7;
    }

    private Color getColor() {
        if (this.color != null) {
            return this.color;
        }
        return UIManager.getColor(this.colorKey);
    }
}

