/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.spnego;

import java.security.Provider;
import java.util.Vector;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.GSSManagerImpl;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.SunProvider;
import sun.security.jgss.krb5.Krb5AcceptCredential;
import sun.security.jgss.krb5.Krb5InitCredential;
import sun.security.jgss.krb5.Krb5MechFactory;
import sun.security.jgss.krb5.Krb5NameElement;
import sun.security.jgss.spi.GSSContextSpi;
import sun.security.jgss.spi.GSSCredentialSpi;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.jgss.spi.MechanismFactory;
import sun.security.jgss.spnego.SpNegoContext;
import sun.security.jgss.spnego.SpNegoCredElement;

public final class SpNegoMechFactory
implements MechanismFactory {
    static final Provider PROVIDER = new SunProvider();
    static final Oid GSS_SPNEGO_MECH_OID = GSSUtil.createOid("1.3.6.1.5.5.2");
    private static Oid[] nameTypes = new Oid[]{GSSName.NT_USER_NAME, GSSName.NT_HOSTBASED_SERVICE, GSSName.NT_EXPORT_NAME};
    final GSSManagerImpl manager;
    final Oid[] availableMechs;

    private static SpNegoCredElement getCredFromSubject(GSSNameSpi name, boolean initiate) throws GSSException {
        GSSCredentialSpi cred;
        SpNegoCredElement result;
        Vector creds = GSSUtil.searchSubject(name, GSS_SPNEGO_MECH_OID, initiate, SpNegoCredElement.class);
        SpNegoCredElement spNegoCredElement = result = creds == null || creds.isEmpty() ? null : (SpNegoCredElement)creds.firstElement();
        if (result != null && GSSUtil.isKerberosMech((cred = result.getInternalCred()).getMechanism())) {
            if (initiate) {
                Krb5InitCredential krbCred = (Krb5InitCredential)cred;
                Krb5MechFactory.checkInitCredPermission((Krb5NameElement)krbCred.getName());
            } else {
                Krb5AcceptCredential krbCred = (Krb5AcceptCredential)cred;
                Krb5MechFactory.checkAcceptCredPermission((Krb5NameElement)krbCred.getName(), name);
            }
        }
        return result;
    }

    public SpNegoMechFactory(int caller) {
        this.manager = new GSSManagerImpl(caller, false);
        Oid[] mechs = this.manager.getMechs();
        this.availableMechs = new Oid[mechs.length - 1];
        int j = 0;
        for (int i = 0; i < mechs.length; ++i) {
            if (mechs[i].equals(GSS_SPNEGO_MECH_OID)) continue;
            this.availableMechs[j++] = mechs[i];
        }
    }

    public GSSNameSpi getNameElement(String nameStr, Oid nameType) throws GSSException {
        return this.manager.getNameElement(nameStr, nameType, null);
    }

    public GSSNameSpi getNameElement(byte[] name, Oid nameType) throws GSSException {
        return this.manager.getNameElement(name, nameType, null);
    }

    public GSSCredentialSpi getCredentialElement(GSSNameSpi name, int initLifetime, int acceptLifetime, int usage) throws GSSException {
        SpNegoCredElement credElement = SpNegoMechFactory.getCredFromSubject(name, usage != 2);
        if (credElement == null) {
            credElement = new SpNegoCredElement(this.manager.getCredentialElement(name, initLifetime, acceptLifetime, null, usage));
        }
        return credElement;
    }

    public GSSContextSpi getMechanismContext(GSSNameSpi peer, GSSCredentialSpi myInitiatorCred, int lifetime) throws GSSException {
        if (myInitiatorCred == null) {
            myInitiatorCred = SpNegoMechFactory.getCredFromSubject(null, true);
        } else if (!(myInitiatorCred instanceof SpNegoCredElement)) {
            SpNegoCredElement cred = new SpNegoCredElement(myInitiatorCred);
            return new SpNegoContext(this, peer, cred, lifetime);
        }
        return new SpNegoContext(this, peer, myInitiatorCred, lifetime);
    }

    public GSSContextSpi getMechanismContext(GSSCredentialSpi myAcceptorCred) throws GSSException {
        if (myAcceptorCred == null) {
            myAcceptorCred = SpNegoMechFactory.getCredFromSubject(null, false);
        } else if (!(myAcceptorCred instanceof SpNegoCredElement)) {
            SpNegoCredElement cred = new SpNegoCredElement(myAcceptorCred);
            return new SpNegoContext(this, cred);
        }
        return new SpNegoContext(this, myAcceptorCred);
    }

    public GSSContextSpi getMechanismContext(byte[] exportedContext) throws GSSException {
        return new SpNegoContext(this, exportedContext);
    }

    public final Oid getMechanismOid() {
        return GSS_SPNEGO_MECH_OID;
    }

    public Provider getProvider() {
        return PROVIDER;
    }

    public Oid[] getNameTypes() {
        return nameTypes;
    }
}

