/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import sun.net.NetProperties;
import sun.net.www.http.HttpClient;
import sun.net.www.http.KeepAliveCleanerEntry;
import sun.net.www.http.KeepAliveStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeepAliveStreamCleaner
extends LinkedBlockingQueue<KeepAliveCleanerEntry>
implements Runnable {
    protected static int MAX_DATA_REMAINING;
    protected static int MAX_CAPACITY;
    protected static final int TIMEOUT = 5000;
    private static final int MAX_RETRIES = 5;

    public KeepAliveStreamCleaner() {
        super(MAX_CAPACITY);
    }

    public KeepAliveStreamCleaner(int capacity) {
        super(capacity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        KeepAliveCleanerEntry kace = null;
        do {
            try {
                kace = (KeepAliveCleanerEntry)this.poll(5000L, TimeUnit.MILLISECONDS);
                if (kace == null) break;
                KeepAliveStream kas = kace.getKeepAliveStream();
                if (kas == null) continue;
                KeepAliveStream keepAliveStream = kas;
                synchronized (keepAliveStream) {
                    Object var12_11;
                    HttpClient hc = kace.getHttpClient();
                    try {
                        block13: {
                            try {
                                if (hc == null || hc.isInKeepAliveCache()) break block13;
                                int oldTimeout = hc.setTimeout(5000);
                                long remainingToRead = kas.remainingToRead();
                                if (remainingToRead > 0L) {
                                    long n = 0L;
                                    int retries = 0;
                                    while (n < remainingToRead && retries < 5) {
                                        if ((n = kas.skip(remainingToRead -= n)) != 0L) continue;
                                        ++retries;
                                    }
                                    remainingToRead -= n;
                                }
                                if (remainingToRead == 0L) {
                                    hc.setTimeout(oldTimeout);
                                    hc.finished();
                                    break block13;
                                }
                                hc.closeServer();
                            }
                            catch (IOException ioe) {
                                hc.closeServer();
                                var12_11 = null;
                                kas.setClosed();
                            }
                        }
                        var12_11 = null;
                        kas.setClosed();
                    }
                    catch (Throwable throwable) {
                        var12_11 = null;
                        kas.setClosed();
                        throw throwable;
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (kace != null);
    }

    static {
        int maxCapacity;
        int maxData;
        MAX_DATA_REMAINING = 512;
        MAX_CAPACITY = 10;
        String maxDataKey = "http.KeepAlive.remainingData";
        MAX_DATA_REMAINING = maxData = (Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Integer(NetProperties.getInteger("http.KeepAlive.remainingData", MAX_DATA_REMAINING));
            }
        }) * 1024;
        String maxCapacityKey = "http.KeepAlive.queuedConnections";
        MAX_CAPACITY = maxCapacity = ((Integer)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Integer(NetProperties.getInteger("http.KeepAlive.queuedConnections", MAX_CAPACITY));
            }
        })).intValue();
    }
}

