/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.VMOption;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Flag {
    private String name;
    private Object value;
    private VMOption.Origin origin;
    private boolean writeable;
    private boolean external;

    Flag(String name, Object value, boolean writeable, boolean external, VMOption.Origin origin) {
        this.name = name;
        this.value = value;
        this.origin = origin;
        this.writeable = writeable;
        this.external = external;
    }

    Object getValue() {
        return this.value;
    }

    boolean isWriteable() {
        return this.writeable;
    }

    boolean isExternal() {
        return this.external;
    }

    VMOption getVMOption() {
        return new VMOption(this.name, this.value.toString(), this.writeable, this.origin);
    }

    static Flag getFlag(String name) {
        Flag[] fs = new Flag[1];
        String[] names = new String[]{name};
        int count = Flag.getFlags(names, fs, 1);
        if (count == 1) {
            return fs[0];
        }
        return null;
    }

    static List<Flag> getAllFlags() {
        int numFlags = Flag.getInternalFlagCount();
        Flag[] fs = new Flag[numFlags];
        int count = Flag.getFlags(null, fs, numFlags);
        return Arrays.asList(fs);
    }

    private static native String[] getAllFlagNames();

    private static native int getFlags(String[] var0, Flag[] var1, int var2);

    private static native int getInternalFlagCount();

    static synchronized native void setLongValue(String var0, long var1);

    static synchronized native void setBooleanValue(String var0, boolean var1);

    static synchronized native void setStringValue(String var0, String var1);

    private static native void initialize();

    static {
        Flag.initialize();
    }
}

