/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import sun.awt.datatransfer.ClassLoaderObjectInputStream;
import sun.awt.datatransfer.ClassLoaderObjectOutputStream;

public class TransferableProxy
implements Transferable {
    protected final Transferable transferable;
    protected final boolean isLocal;

    public TransferableProxy(Transferable t, boolean local) {
        this.transferable = t;
        this.isLocal = local;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.transferable.getTransferDataFlavors();
    }

    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.transferable.isDataFlavorSupported(flavor);
    }

    public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
        Object data = this.transferable.getTransferData(df);
        if (data != null && this.isLocal && df.isFlavorSerializedObjectType()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ClassLoaderObjectOutputStream oos = new ClassLoaderObjectOutputStream(baos);
            oos.writeObject(data);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            try {
                ClassLoaderObjectInputStream ois = new ClassLoaderObjectInputStream(bais, oos.getClassLoaderMap());
                data = ois.readObject();
            }
            catch (ClassNotFoundException cnfe) {
                throw (IOException)new IOException().initCause(cnfe);
            }
        }
        return data;
    }
}

