/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.lang.reflect.Field;
import java.net.URLClassLoader;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashSet;
import sun.applet.AppletClassLoader;
import sun.awt.AWTSecurityManager;
import sun.awt.AppContext;
import sun.security.util.SecurityConstants;

public class AppletSecurity
extends AWTSecurityManager {
    private AppContext mainAppContext;
    private static Field facc = null;
    private static Field fcontext = null;
    private HashSet restrictedPackages = new HashSet();
    private boolean inThreadGroupCheck = false;

    public AppletSecurity() {
        this.reset();
        this.mainAppContext = AppContext.getAppContext();
    }

    public void reset() {
        this.restrictedPackages.clear();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Enumeration<?> e = System.getProperties().propertyNames();
                while (e.hasMoreElements()) {
                    String value;
                    String name = (String)e.nextElement();
                    if (name == null || !name.startsWith("package.restrict.access.") || (value = System.getProperty(name)) == null || !value.equalsIgnoreCase("true")) continue;
                    String pkg = name.substring(24);
                    AppletSecurity.this.restrictedPackages.add(pkg);
                }
                return null;
            }
        });
    }

    private AppletClassLoader currentAppletClassLoader() {
        int i;
        ClassLoader loader = this.currentClassLoader();
        if (loader == null || loader instanceof AppletClassLoader) {
            return (AppletClassLoader)loader;
        }
        Class[] context = this.getClassContext();
        for (i = 0; i < context.length; ++i) {
            loader = context[i].getClassLoader();
            if (!(loader instanceof AppletClassLoader)) continue;
            return (AppletClassLoader)loader;
        }
        for (i = 0; i < context.length; ++i) {
            final ClassLoader currentLoader = context[i].getClassLoader();
            if (!(currentLoader instanceof URLClassLoader) || (loader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AccessControlContext acc = null;
                    ProtectionDomain[] pds = null;
                    try {
                        acc = (AccessControlContext)facc.get(currentLoader);
                        if (acc == null) {
                            return null;
                        }
                        pds = (ProtectionDomain[])fcontext.get(acc);
                        if (pds == null) {
                            return null;
                        }
                    }
                    catch (Exception e) {
                        throw new UnsupportedOperationException(e);
                    }
                    for (int i = 0; i < pds.length; ++i) {
                        ClassLoader cl = pds[i].getClassLoader();
                        if (!(cl instanceof AppletClassLoader)) continue;
                        return cl;
                    }
                    return null;
                }
            })) == null) continue;
            return (AppletClassLoader)loader;
        }
        loader = Thread.currentThread().getContextClassLoader();
        if (loader instanceof AppletClassLoader) {
            return (AppletClassLoader)loader;
        }
        return null;
    }

    protected boolean inThreadGroup(ThreadGroup g) {
        if (this.currentAppletClassLoader() == null) {
            return false;
        }
        return this.getThreadGroup().parentOf(g);
    }

    protected boolean inThreadGroup(Thread thread) {
        return this.inThreadGroup(thread.getThreadGroup());
    }

    public void checkAccess(Thread t) {
        if (t.getState() != Thread.State.TERMINATED && !this.inThreadGroup(t)) {
            this.checkPermission(SecurityConstants.MODIFY_THREAD_PERMISSION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkAccess(ThreadGroup g) {
        if (this.inThreadGroupCheck) {
            this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
        } else {
            try {
                this.inThreadGroupCheck = true;
                if (!this.inThreadGroup(g)) {
                    this.checkPermission(SecurityConstants.MODIFY_THREADGROUP_PERMISSION);
                }
            }
            finally {
                this.inThreadGroupCheck = false;
            }
        }
    }

    public void checkPackageAccess(String pkgname) {
        super.checkPackageAccess(pkgname);
        for (String pkg : this.restrictedPackages) {
            if (!pkgname.equals(pkg) && !pkgname.startsWith(pkg + ".")) continue;
            this.checkPermission(new RuntimePermission("accessClassInPackage." + pkgname));
        }
    }

    public void checkAwtEventQueueAccess() {
        AppContext appContext = AppContext.getAppContext();
        AppletClassLoader appletClassLoader = this.currentAppletClassLoader();
        if (appContext == this.mainAppContext && appletClassLoader != null) {
            super.checkAwtEventQueueAccess();
        }
    }

    public ThreadGroup getThreadGroup() {
        ThreadGroup loaderGroup;
        AppletClassLoader appletLoader = this.currentAppletClassLoader();
        ThreadGroup threadGroup = loaderGroup = appletLoader == null ? null : appletLoader.getThreadGroup();
        if (loaderGroup != null) {
            return loaderGroup;
        }
        return super.getThreadGroup();
    }

    public AppContext getAppContext() {
        AppletClassLoader appletLoader = this.currentAppletClassLoader();
        if (appletLoader == null) {
            return null;
        }
        AppContext context = appletLoader.getAppContext();
        if (context == null) {
            throw new SecurityException("Applet classloader has invalid AppContext");
        }
        return context;
    }

    static {
        try {
            facc = URLClassLoader.class.getDeclaredField("acc");
            facc.setAccessible(true);
            fcontext = AccessControlContext.class.getDeclaredField("context");
            fcontext.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new UnsupportedOperationException(e);
        }
    }
}

