/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal;

import com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigesterOutputStream
extends OutputStream {
    private boolean buffer = false;
    private UnsyncByteArrayOutputStream bos;
    private final MessageDigest md;
    private static Logger log = Logger.getLogger("org.jcp.xml.dsig.internal");

    public DigesterOutputStream(MessageDigest md) {
        this(md, false);
    }

    public DigesterOutputStream(MessageDigest md, boolean buffer) {
        this.md = md;
        this.buffer = buffer;
        if (buffer) {
            this.bos = new UnsyncByteArrayOutputStream();
        }
    }

    public void write(byte[] input) {
        this.write(input, 0, input.length);
    }

    public void write(int input) {
        if (this.buffer) {
            this.bos.write(input);
        }
        this.md.update((byte)input);
    }

    public void write(byte[] input, int offset, int len) {
        if (this.buffer) {
            this.bos.write(input, offset, len);
        }
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "Pre-digested input:");
            StringBuffer sb = new StringBuffer(len);
            for (int i = offset; i < offset + len; ++i) {
                sb.append((char)input[i]);
            }
            log.log(Level.FINER, sb.toString());
        }
        this.md.update(input, offset, len);
    }

    public byte[] getDigestValue() {
        return this.md.digest();
    }

    public InputStream getInputStream() {
        if (this.buffer) {
            return new ByteArrayInputStream(this.bos.toByteArray());
        }
        return null;
    }
}

