/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import net.sourceforge.jnlp.IconDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.StreamEater;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.FileUtils;

public class XDesktopEntry {
    public static final String JAVA_ICON_NAME = "java.png";
    private JNLPFile file = null;
    private int iconSize = -1;
    private String iconLocation = null;
    private int[] VALID_ICON_SIZES = new int[]{16, 22, 32, 48, 64, 128};

    public XDesktopEntry(JNLPFile file) {
        this.file = file;
        this.iconSize = this.VALID_ICON_SIZES[2];
    }

    public Reader getContentsAsReader() {
        String pathToJavaws = System.getProperty("java.home") + File.separator + "bin" + File.separator + "javaws";
        File cacheFile = CacheUtil.urlToPath(this.file.getSourceLocation(), "cache");
        String fileContents = "[Desktop Entry]\n";
        fileContents = fileContents + "Version=1.0\n";
        fileContents = fileContents + "Name=" + this.file.getTitle() + "\n";
        fileContents = fileContents + "GenericName=Java Web Start Application\n";
        fileContents = fileContents + "Comment=" + this.file.getInformation().getDescription() + "\n";
        fileContents = fileContents + "Type=Application\n";
        fileContents = this.iconLocation != null ? fileContents + "Icon=" + this.iconLocation + "\n" : fileContents + "Icon=java.png\n";
        if (this.file.getInformation().getVendor() != null) {
            fileContents = fileContents + "Vendor=" + this.file.getInformation().getVendor() + "\n";
        }
        fileContents = fileContents + "Exec=javaws \"" + cacheFile.getAbsolutePath() + "\"\n";
        return new StringReader(fileContents);
    }

    public int getIconSize() {
        return this.iconSize;
    }

    public void setIconSize(int size) {
        this.iconSize = size;
    }

    public void createDesktopShortcut() {
        try {
            this.cacheIcon();
            this.installDesktopLauncher();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void installDesktopLauncher() {
        File shortcutFile = new File(JNLPRuntime.TMP_DIR + File.separator + FileUtils.sanitizeFileName(this.file.getTitle()) + ".desktop");
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(shortcutFile), Charset.forName("UTF-8"));
            Reader reader = this.getContentsAsReader();
            char[] buffer = new char[1024];
            int ret = 0;
            while (-1 != (ret = reader.read(buffer))) {
                writer.write(buffer, 0, ret);
            }
            reader.close();
            writer.close();
            Object[] execString = new String[]{"xdg-desktop-icon", "install", "--novendor", shortcutFile.getCanonicalPath()};
            if (JNLPRuntime.isDebug()) {
                System.err.println("Execing: " + Arrays.toString(execString));
            }
            Process installer = Runtime.getRuntime().exec((String[])execString);
            new StreamEater(installer.getInputStream()).start();
            new StreamEater(installer.getErrorStream()).start();
            try {
                installer.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (!shortcutFile.delete()) {
                throw new IOException("Unable to delete temporary file:" + shortcutFile);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void cacheIcon() {
        URL iconLocation = this.file.getInformation().getIconLocation(IconDesc.SHORTCUT, this.iconSize, this.iconSize);
        if (iconLocation == null) {
            iconLocation = this.file.getInformation().getIconLocation(IconDesc.DEFAULT, this.iconSize, this.iconSize);
        }
        if (iconLocation != null) {
            String location = CacheUtil.getCachedResource(iconLocation, null, UpdatePolicy.SESSION).toString();
            if (!location.startsWith("file:")) {
                throw new RuntimeException("Unable to cache icon");
            }
            this.iconLocation = location.substring("file:".length());
            if (JNLPRuntime.isDebug()) {
                System.err.println("Cached desktop shortcut icon: " + this.iconLocation);
            }
        }
    }
}

