/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.jnlp.BasicService;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.JARDesc;
import net.sourceforge.jnlp.JNLPFile;
import net.sourceforge.jnlp.Launcher;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.util.PropertiesFile;

class XBasicService
implements BasicService {
    private String command = null;
    private boolean initialized = false;

    protected XBasicService() {
    }

    @Override
    public URL getCodeBase() {
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app != null) {
            JNLPFile file = app.getJNLPFile();
            if (file.getCodeBase() != null) {
                return file.getCodeBase();
            }
            JARDesc mainJar = file.getResources().getMainJAR();
            if (mainJar != null) {
                return mainJar.getLocation();
            }
        }
        return null;
    }

    @Override
    public boolean isOffline() {
        URL url = this.findFirstURLFromJNLPFile();
        try {
            url.openConnection().getInputStream().close();
            return false;
        }
        catch (IOException exception) {
            return true;
        }
    }

    private URL findFirstURLFromJNLPFile() {
        URL arbitraryURL;
        ApplicationInstance app = JNLPRuntime.getApplication();
        if (app != null) {
            JNLPFile jnlpFile = app.getJNLPFile();
            URL sourceURL = jnlpFile.getSourceLocation();
            if (sourceURL != null) {
                return sourceURL;
            }
            URL codeBaseURL = jnlpFile.getCodeBase();
            if (codeBaseURL != null) {
                return codeBaseURL;
            }
            InformationDesc informationDesc = jnlpFile.getInformation();
            URL homePage = informationDesc.getHomepage();
            if (homePage != null) {
                return homePage;
            }
            int i$ = 0;
            JARDesc[] jarDescs = jnlpFile.getResources().getJARs();
            JARDesc[] arr$ = jarDescs;
            int len$ = arr$.length;
            if (i$ < len$) {
                JARDesc jarDesc = arr$[i$];
                return jarDesc.getLocation();
            }
        }
        try {
            arbitraryURL = new URL("http://icedtea.classpath.org");
        }
        catch (MalformedURLException malformedURL) {
            throw new RuntimeException(malformedURL);
        }
        return arbitraryURL;
    }

    @Override
    public boolean isWebBrowserSupported() {
        this.initialize();
        return this.command != null;
    }

    @Override
    public boolean showDocument(URL url) {
        block6: {
            this.initialize();
            if (url.toString().endsWith(".jnlp")) {
                try {
                    new Launcher().launchExternal(url);
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }
            if (this.command != null) {
                try {
                    Runtime.getRuntime().exec(this.command + " " + url.toString());
                    return true;
                }
                catch (IOException ex) {
                    if (!JNLPRuntime.isDebug()) break block6;
                    ex.printStackTrace();
                }
            }
        }
        return false;
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.isWindows()) {
            this.command = "rundll32 url.dll,FileProtocolHandler ";
        } else {
            PropertiesFile props = JNLPRuntime.getProperties();
            this.command = props.getProperty("browser.command");
            if (this.command == null) {
                this.command = this.promptForCommand(null);
                if (this.command != null) {
                    props.setProperty("browser.command", this.command);
                    props.store();
                }
            }
        }
    }

    private boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    private String promptForCommand(String cmd) {
        return JOptionPane.showInputDialog(new JPanel(), "Browser Location:", "Specify Browser Location", -1);
    }
}

