/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

class IsindexView
extends ComponentView
implements ActionListener {
    JTextField textField;

    public IsindexView(Element elem) {
        super(elem);
    }

    public Component createComponent() {
        AttributeSet attr = this.getElement().getAttributes();
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(null);
        String prompt = (String)attr.getAttribute(HTML.Attribute.PROMPT);
        if (prompt == null) {
            prompt = UIManager.getString("IsindexView.prompt");
        }
        JLabel label = new JLabel(prompt);
        this.textField = new JTextField();
        this.textField.addActionListener(this);
        panel.add((Component)label, "West");
        panel.add((Component)this.textField, "Center");
        panel.setAlignmentY(1.0f);
        panel.setOpaque(false);
        return panel;
    }

    public void actionPerformed(ActionEvent evt) {
        String data = this.textField.getText();
        if (data != null) {
            data = URLEncoder.encode(data);
        }
        AttributeSet attr = this.getElement().getAttributes();
        HTMLDocument hdoc = (HTMLDocument)this.getElement().getDocument();
        String action = (String)attr.getAttribute(HTML.Attribute.ACTION);
        if (action == null) {
            action = hdoc.getBase().toString();
        }
        try {
            URL url = new URL(action + "?" + data);
            JEditorPane pane = (JEditorPane)this.getContainer();
            pane.setPage(url);
        }
        catch (MalformedURLException e1) {
        }
        catch (IOException e2) {
            // empty catch block
        }
    }
}

