/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.ssl;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SslRMIServerSocketFactory
implements RMIServerSocketFactory {
    private static SSLSocketFactory defaultSSLSocketFactory = null;
    private final String[] enabledCipherSuites;
    private final String[] enabledProtocols;
    private final boolean needClientAuth;
    private List enabledCipherSuitesList;
    private List enabledProtocolsList;

    public SslRMIServerSocketFactory() {
        this(null, null, false);
    }

    public SslRMIServerSocketFactory(String[] enabledCipherSuites, String[] enabledProtocols, boolean needClientAuth) throws IllegalArgumentException {
        this.enabledCipherSuites = enabledCipherSuites == null ? null : (String[])enabledCipherSuites.clone();
        this.enabledProtocols = enabledProtocols == null ? null : (String[])enabledProtocols.clone();
        this.needClientAuth = needClientAuth;
        SSLSocketFactory sslSocketFactory = SslRMIServerSocketFactory.getDefaultSSLSocketFactory();
        SSLSocket sslSocket = null;
        if (this.enabledCipherSuites != null || this.enabledProtocols != null) {
            try {
                sslSocket = (SSLSocket)sslSocketFactory.createSocket();
            }
            catch (Exception e) {
                String msg = "Unable to check if the cipher suites and protocols to enable are supported";
                throw (IllegalArgumentException)new IllegalArgumentException("Unable to check if the cipher suites and protocols to enable are supported").initCause(e);
            }
        }
        if (this.enabledCipherSuites != null) {
            sslSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            this.enabledCipherSuitesList = Arrays.asList(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sslSocket.setEnabledProtocols(this.enabledProtocols);
            this.enabledProtocolsList = Arrays.asList(this.enabledProtocols);
        }
    }

    public final String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites == null ? null : (String[])this.enabledCipherSuites.clone();
    }

    public final String[] getEnabledProtocols() {
        return this.enabledProtocols == null ? null : (String[])this.enabledProtocols.clone();
    }

    public final boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        final SSLSocketFactory sslSocketFactory = SslRMIServerSocketFactory.getDefaultSSLSocketFactory();
        return new ServerSocket(port){

            public Socket accept() throws IOException {
                Socket socket = super.accept();
                SSLSocket sslSocket = (SSLSocket)sslSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sslSocket.setUseClientMode(false);
                if (SslRMIServerSocketFactory.this.enabledCipherSuites != null) {
                    sslSocket.setEnabledCipherSuites(SslRMIServerSocketFactory.this.enabledCipherSuites);
                }
                if (SslRMIServerSocketFactory.this.enabledProtocols != null) {
                    sslSocket.setEnabledProtocols(SslRMIServerSocketFactory.this.enabledProtocols);
                }
                sslSocket.setNeedClientAuth(SslRMIServerSocketFactory.this.needClientAuth);
                return sslSocket;
            }
        };
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SslRMIServerSocketFactory)) {
            return false;
        }
        SslRMIServerSocketFactory that = (SslRMIServerSocketFactory)obj;
        return this.getClass().equals(that.getClass()) && this.checkParameters(that);
    }

    private boolean checkParameters(SslRMIServerSocketFactory that) {
        List<String> thatEnabledProtocolsList;
        List<String> thatEnabledCipherSuitesList;
        if (this.needClientAuth != that.needClientAuth) {
            return false;
        }
        if (this.enabledCipherSuites == null && that.enabledCipherSuites != null || this.enabledCipherSuites != null && that.enabledCipherSuites == null) {
            return false;
        }
        if (this.enabledCipherSuites != null && that.enabledCipherSuites != null && !((Object)this.enabledCipherSuitesList).equals(thatEnabledCipherSuitesList = Arrays.asList(that.enabledCipherSuites))) {
            return false;
        }
        if (this.enabledProtocols == null && that.enabledProtocols != null || this.enabledProtocols != null && that.enabledProtocols == null) {
            return false;
        }
        return this.enabledProtocols == null || that.enabledProtocols == null || ((Object)this.enabledProtocolsList).equals(thatEnabledProtocolsList = Arrays.asList(that.enabledProtocols));
    }

    public int hashCode() {
        return this.getClass().hashCode() + (this.needClientAuth ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()) + (this.enabledCipherSuites == null ? 0 : ((Object)this.enabledCipherSuitesList).hashCode()) + (this.enabledProtocols == null ? 0 : ((Object)this.enabledProtocolsList).hashCode());
    }

    private static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
        if (defaultSSLSocketFactory == null) {
            defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return defaultSSLSocketFactory;
    }
}

