/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public class DigestOutputStream
extends FilterOutputStream {
    private boolean on = true;
    protected MessageDigest digest;

    public DigestOutputStream(OutputStream stream, MessageDigest digest) {
        super(stream);
        this.setMessageDigest(digest);
    }

    public MessageDigest getMessageDigest() {
        return this.digest;
    }

    public void setMessageDigest(MessageDigest digest) {
        this.digest = digest;
    }

    public void write(int b) throws IOException {
        if (this.on) {
            this.digest.update((byte)b);
        }
        this.out.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.on) {
            this.digest.update(b, off, len);
        }
        this.out.write(b, off, len);
    }

    public void on(boolean on) {
        this.on = on;
    }

    public String toString() {
        return "[Digest Output Stream] " + this.digest.toString();
    }
}

