/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends Number
implements Comparable<BigDecimal> {
    private volatile BigInteger intVal;
    private int scale = 0;
    private volatile transient int precision = 0;
    private volatile transient String stringCache = null;
    private static final long INFLATED = Long.MIN_VALUE;
    private transient long intCompact = Long.MIN_VALUE;
    private static final int MAX_COMPACT_DIGITS = 18;
    private static final int MAX_BIGINT_BITS = 62;
    private static final long serialVersionUID = 6108874887143696463L;
    private static final BigDecimal[] zeroThroughTen = new BigDecimal[]{new BigDecimal(BigInteger.ZERO, 0L, 0), new BigDecimal(BigInteger.ONE, 1L, 0), new BigDecimal(BigInteger.valueOf(2L), 2L, 0), new BigDecimal(BigInteger.valueOf(3L), 3L, 0), new BigDecimal(BigInteger.valueOf(4L), 4L, 0), new BigDecimal(BigInteger.valueOf(5L), 5L, 0), new BigDecimal(BigInteger.valueOf(6L), 6L, 0), new BigDecimal(BigInteger.valueOf(7L), 7L, 0), new BigDecimal(BigInteger.valueOf(8L), 8L, 0), new BigDecimal(BigInteger.valueOf(9L), 9L, 0), new BigDecimal(BigInteger.TEN, 10L, 0)};
    public static final BigDecimal ZERO = zeroThroughTen[0];
    public static final BigDecimal ONE = zeroThroughTen[1];
    public static final BigDecimal TEN = zeroThroughTen[10];
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private static BigInteger[] TENPOWERS = new BigInteger[]{BigInteger.ONE, BigInteger.valueOf(10L), BigInteger.valueOf(100L), BigInteger.valueOf(1000L), BigInteger.valueOf(10000L), BigInteger.valueOf(100000L), BigInteger.valueOf(1000000L), BigInteger.valueOf(10000000L), BigInteger.valueOf(100000000L), BigInteger.valueOf(1000000000L)};
    private static long[][] thresholds = new long[][]{{Long.MAX_VALUE, 1L}, {0xCCCCCCCCCCCCCCCL, 10L}, {92233720368547758L, 100L}, {9223372036854775L, 1000L}, {922337203685477L, 10000L}, {92233720368547L, 100000L}, {9223372036854L, 1000000L}, {922337203685L, 10000000L}, {92233720368L, 100000000L}, {9223372036L, 1000000000L}, {922337203L, 10000000000L}, {92233720L, 100000000000L}, {0x8CBCCCL, 1000000000000L}, {92233L, 10000000000000L}};
    private static int[] ilogTable = new int[]{0, 9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    public BigDecimal(char[] in, int offset, int len) {
        try {
            char[] quick;
            boolean isneg = false;
            if (in[offset] == '-') {
                isneg = true;
                ++offset;
                --len;
            } else if (in[offset] == '+') {
                ++offset;
                --len;
            }
            int dotoff = -1;
            int cfirst = offset;
            long exp = 0L;
            if (len > in.length) {
                throw new NumberFormatException();
            }
            char[] coeff = new char[len];
            while (len > 0) {
                char c = in[offset];
                if (c >= '0' && c <= '9' || Character.isDigit(c)) {
                    coeff[this.precision] = c;
                    ++this.precision;
                } else if (c == '.') {
                    if (dotoff >= 0) {
                        throw new NumberFormatException();
                    }
                    dotoff = offset;
                } else {
                    if (c != 'e' && c != 'E') {
                        throw new NumberFormatException();
                    }
                    c = in[++offset];
                    --len;
                    boolean negexp = false;
                    if (c == '-' || c == '+') {
                        negexp = c == '-';
                        c = in[++offset];
                        --len;
                    }
                    if (len <= 0) {
                        throw new NumberFormatException();
                    }
                    while (len > 10 && Character.digit(c, 10) == 0) {
                        c = in[++offset];
                        --len;
                    }
                    if (len > 10) {
                        throw new NumberFormatException();
                    }
                    while (true) {
                        int v;
                        if (c >= '0' && c <= '9') {
                            v = c - 48;
                        } else {
                            v = Character.digit(c, 10);
                            if (v < 0) {
                                throw new NumberFormatException();
                            }
                        }
                        exp = exp * 10L + (long)v;
                        if (len == 1) break;
                        c = in[++offset];
                        --len;
                    }
                    if (negexp) {
                        exp = -exp;
                    }
                    if ((long)((int)exp) == exp) break;
                    throw new NumberFormatException();
                }
                ++offset;
                --len;
            }
            if (this.precision == 0) {
                throw new NumberFormatException();
            }
            if (dotoff >= 0) {
                this.scale = this.precision - (dotoff - cfirst);
            }
            if (exp != 0L) {
                try {
                    this.scale = this.checkScale(-exp + (long)this.scale);
                }
                catch (ArithmeticException e) {
                    throw new NumberFormatException("Scale out of range.");
                }
            }
            int first = 0;
            while ((coeff[first] == '0' || Character.digit(coeff[first], 10) == 0) && this.precision > 1) {
                --this.precision;
                ++first;
            }
            if (!isneg) {
                quick = new char[this.precision];
                System.arraycopy(coeff, first, quick, 0, this.precision);
            } else {
                quick = new char[this.precision + 1];
                quick[0] = 45;
                System.arraycopy(coeff, first, quick, 1, this.precision);
            }
            if (this.precision <= 18) {
                this.intCompact = Long.parseLong(new String(quick));
            } else {
                this.intVal = new BigInteger(quick);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NumberFormatException();
        }
        catch (NegativeArraySizeException e) {
            throw new NumberFormatException();
        }
    }

    public BigDecimal(char[] in, int offset, int len, MathContext mc) {
        this(in, offset, len);
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(char[] in) {
        this(in, 0, in.length);
    }

    public BigDecimal(char[] in, MathContext mc) {
        this(in, 0, in.length, mc);
    }

    public BigDecimal(String val) {
        this(val.toCharArray(), 0, val.length());
    }

    public BigDecimal(String val, MathContext mc) {
        this(val.toCharArray(), 0, val.length());
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(double val) {
        if (Double.isInfinite(val) || Double.isNaN(val)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        long valBits = Double.doubleToLongBits(val);
        int sign = valBits >> 63 == 0L ? 1 : -1;
        int exponent = (int)(valBits >> 52 & 0x7FFL);
        long significand = exponent == 0 ? (valBits & 0xFFFFFFFFFFFFFL) << 1 : valBits & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        exponent -= 1075;
        if (significand == 0L) {
            this.intVal = BigInteger.ZERO;
            this.intCompact = 0L;
            this.precision = 1;
            return;
        }
        while ((significand & 1L) == 0L) {
            significand >>= 1;
            ++exponent;
        }
        this.intVal = BigInteger.valueOf((long)sign * significand);
        if (exponent < 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(5L).pow(-exponent));
            this.scale = -exponent;
        } else if (exponent > 0) {
            this.intVal = this.intVal.multiply(BigInteger.valueOf(2L).pow(exponent));
        }
        if (this.intVal.bitLength() <= 62) {
            this.intCompact = this.intVal.longValue();
        }
    }

    public BigDecimal(double val, MathContext mc) {
        this(val);
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(BigInteger val) {
        this.intVal = val;
        if (val.bitLength() <= 62) {
            this.intCompact = val.longValue();
        }
    }

    public BigDecimal(BigInteger val, MathContext mc) {
        this.intVal = val;
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(BigInteger unscaledVal, int scale) {
        this.intVal = unscaledVal;
        this.scale = scale;
        if (unscaledVal.bitLength() <= 62) {
            this.intCompact = unscaledVal.longValue();
        }
    }

    public BigDecimal(BigInteger unscaledVal, int scale, MathContext mc) {
        this.intVal = unscaledVal;
        this.scale = scale;
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(int val) {
        this.intCompact = val;
    }

    public BigDecimal(int val, MathContext mc) {
        this.intCompact = val;
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    public BigDecimal(long val) {
        if (BigDecimal.compactLong(val)) {
            this.intCompact = val;
        } else {
            this.intVal = BigInteger.valueOf(val);
        }
    }

    public BigDecimal(long val, MathContext mc) {
        if (BigDecimal.compactLong(val)) {
            this.intCompact = val;
        } else {
            this.intVal = BigInteger.valueOf(val);
        }
        if (mc.precision > 0) {
            this.roundThis(mc);
        }
    }

    private BigDecimal(long val, int scale) {
        this.intCompact = val;
        this.scale = scale;
    }

    private BigDecimal(BigInteger intVal, long val, int scale) {
        this.intVal = intVal;
        this.intCompact = val;
        this.scale = scale;
    }

    public static BigDecimal valueOf(long unscaledVal, int scale) {
        if (scale == 0 && unscaledVal >= 0L && unscaledVal <= 10L) {
            return zeroThroughTen[(int)unscaledVal];
        }
        if (BigDecimal.compactLong(unscaledVal)) {
            return new BigDecimal(unscaledVal, scale);
        }
        return new BigDecimal(BigInteger.valueOf(unscaledVal), scale);
    }

    public static BigDecimal valueOf(long val) {
        return BigDecimal.valueOf(val, 0);
    }

    public static BigDecimal valueOf(double val) {
        return new BigDecimal(Double.toString(val));
    }

    public BigDecimal add(BigDecimal augend) {
        long sum;
        BigDecimal[] arg = new BigDecimal[]{this, augend};
        BigDecimal.matchScale(arg);
        long x = arg[0].intCompact;
        long y = arg[1].intCompact;
        if (x != Long.MIN_VALUE && y != Long.MIN_VALUE && (((sum = x + y) ^ x) & (sum ^ y)) >> 63 == 0L) {
            return BigDecimal.valueOf(sum, arg[0].scale);
        }
        return new BigDecimal(arg[0].inflate().intVal.add(arg[1].inflate().intVal), arg[0].scale);
    }

    public BigDecimal add(BigDecimal augend, MathContext mc) {
        boolean augendIsZero;
        if (mc.precision == 0) {
            return this.add(augend);
        }
        BigDecimal lhs = this;
        this.inflate();
        augend.inflate();
        boolean lhsIsZero = lhs.signum() == 0;
        boolean bl = augendIsZero = augend.signum() == 0;
        if (lhsIsZero || augendIsZero) {
            int scaleDiff;
            BigDecimal result;
            int preferredScale = Math.max(lhs.scale(), augend.scale());
            if (lhsIsZero && augendIsZero) {
                return new BigDecimal(BigInteger.ZERO, 0L, preferredScale);
            }
            BigDecimal bigDecimal = result = lhsIsZero ? augend.doRound(mc) : lhs.doRound(mc);
            if (result.scale() == preferredScale) {
                return result;
            }
            if (result.scale() > preferredScale) {
                return new BigDecimal(result.intVal, result.intCompact, result.scale).stripZerosToMatchScale(preferredScale);
            }
            int precisionDiff = mc.precision - result.precision();
            if (precisionDiff >= (scaleDiff = preferredScale - result.scale())) {
                return result.setScale(preferredScale);
            }
            return result.setScale(result.scale() + precisionDiff);
        }
        long padding = (long)lhs.scale - (long)augend.scale;
        if (padding != 0L) {
            BigDecimal[] arg = this.preAlign(lhs, augend, padding, mc);
            BigDecimal.matchScale(arg);
            lhs = arg[0];
            augend = arg[1];
        }
        return new BigDecimal(lhs.inflate().intVal.add(augend.inflate().intVal), lhs.scale).doRound(mc);
    }

    private BigDecimal[] preAlign(BigDecimal lhs, BigDecimal augend, long padding, MathContext mc) {
        BigDecimal small;
        BigDecimal big;
        assert (padding != 0L);
        if (padding < 0L) {
            big = lhs;
            small = augend;
        } else {
            big = augend;
            small = lhs;
        }
        long estResultUlpScale = (long)big.scale - (long)big.precision() + (long)mc.precision;
        long smallHighDigitPos = (long)small.scale - (long)small.precision() + 1L;
        if (smallHighDigitPos > (long)(big.scale + 2) && smallHighDigitPos > estResultUlpScale + 2L) {
            small = BigDecimal.valueOf(small.signum(), this.checkScale(Math.max((long)big.scale, estResultUlpScale) + 3L));
        }
        BigDecimal[] result = new BigDecimal[]{big, small};
        return result;
    }

    public BigDecimal subtract(BigDecimal subtrahend) {
        long difference;
        BigDecimal[] arg = new BigDecimal[]{this, subtrahend};
        BigDecimal.matchScale(arg);
        long x = arg[0].intCompact;
        long y = arg[1].intCompact;
        if (x != Long.MIN_VALUE && y != Long.MIN_VALUE && ((x ^ y) & ((difference = x - y) ^ x)) >> 63 == 0L) {
            return BigDecimal.valueOf(difference, arg[0].scale);
        }
        return new BigDecimal(arg[0].inflate().intVal.subtract(arg[1].inflate().intVal), arg[0].scale);
    }

    public BigDecimal subtract(BigDecimal subtrahend, MathContext mc) {
        if (mc.precision == 0) {
            return this.subtract(subtrahend);
        }
        this.inflate();
        subtrahend.inflate();
        BigDecimal rhs = new BigDecimal(subtrahend.intVal.negate(), subtrahend.scale);
        rhs.precision = subtrahend.precision;
        return this.add(rhs, mc);
    }

    public BigDecimal multiply(BigDecimal multiplicand) {
        long x = this.intCompact;
        long y = multiplicand.intCompact;
        int productScale = this.checkScale((long)this.scale + (long)multiplicand.scale);
        if (x != Long.MIN_VALUE && y != Long.MIN_VALUE) {
            long product = x * y;
            if (y == 0L || product / y == x) {
                return BigDecimal.valueOf(product, productScale);
            }
        }
        BigDecimal result = new BigDecimal(this.inflate().intVal.multiply(multiplicand.inflate().intVal), productScale);
        return result;
    }

    public BigDecimal multiply(BigDecimal multiplicand, MathContext mc) {
        if (mc.precision == 0) {
            return this.multiply(multiplicand);
        }
        BigDecimal lhs = this;
        return lhs.inflate().multiply(multiplicand.inflate()).doRound(mc);
    }

    public BigDecimal divide(BigDecimal divisor, int scale, int roundingMode) {
        int cmpFracHalf;
        BigDecimal dividend;
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (this.checkScale((long)scale + (long)divisor.scale) >= this.scale) {
            dividend = this.setScale(scale + divisor.scale);
        } else {
            dividend = this;
            divisor = divisor.setScale(this.checkScale((long)this.scale - (long)scale));
        }
        boolean compact = dividend.intCompact != Long.MIN_VALUE && divisor.intCompact != Long.MIN_VALUE;
        long div = Long.MIN_VALUE;
        long rem = Long.MIN_VALUE;
        BigInteger q = null;
        BigInteger r = null;
        if (compact) {
            div = dividend.intCompact / divisor.intCompact;
            rem = dividend.intCompact % divisor.intCompact;
        } else {
            BigInteger[] i = dividend.inflate().intVal.divideAndRemainder(divisor.inflate().intVal);
            q = i[0];
            r = i[1];
        }
        if (compact) {
            if (rem == 0L) {
                return new BigDecimal(div, scale);
            }
        } else if (r.signum() == 0) {
            return new BigDecimal(q, scale);
        }
        if (roundingMode == 7) {
            throw new ArithmeticException("Rounding necessary");
        }
        int signum = dividend.signum() * divisor.signum();
        boolean increment = roundingMode == 0 ? true : (roundingMode == 1 ? false : (roundingMode == 2 ? signum > 0 : (roundingMode == 3 ? signum < 0 : ((cmpFracHalf = compact ? BigDecimal.longCompareTo(Math.abs(2L * rem), Math.abs(divisor.intCompact)) : r.add(r).abs().compareTo(divisor.intVal.abs())) < 0 ? false : (cmpFracHalf > 0 ? true : (roundingMode == 4 ? true : (roundingMode == 5 ? false : (compact ? (div & 1L) != 0L : q.testBit(0)))))))));
        if (compact) {
            if (increment) {
                div += (long)signum;
            }
            return new BigDecimal(div, scale);
        }
        return increment ? new BigDecimal(q.add(BigInteger.valueOf(signum)), scale) : new BigDecimal(q, scale);
    }

    public BigDecimal divide(BigDecimal divisor, int scale, RoundingMode roundingMode) {
        return this.divide(divisor, scale, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal divisor, int roundingMode) {
        return this.divide(divisor, this.scale, roundingMode);
    }

    public BigDecimal divide(BigDecimal divisor, RoundingMode roundingMode) {
        return this.divide(divisor, this.scale, roundingMode.oldMode);
    }

    public BigDecimal divide(BigDecimal divisor) {
        BigDecimal quotient;
        if (divisor.signum() == 0) {
            if (this.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        int preferredScale = (int)Math.max(Math.min((long)this.scale() - (long)divisor.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        if (this.signum() == 0) {
            return new BigDecimal(0L, preferredScale);
        }
        this.inflate();
        divisor.inflate();
        MathContext mc = new MathContext((int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)divisor.precision() / 3.0), Integer.MAX_VALUE), RoundingMode.UNNECESSARY);
        try {
            quotient = this.divide(divisor, mc);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Non-terminating decimal expansion; no exact representable decimal result.");
        }
        int quotientScale = quotient.scale();
        if (preferredScale > quotientScale) {
            return quotient.setScale(preferredScale);
        }
        return quotient;
    }

    public BigDecimal divide(BigDecimal divisor, MathContext mc) {
        if (mc.precision == 0) {
            return this.divide(divisor);
        }
        BigDecimal lhs = this.inflate();
        BigDecimal rhs = divisor.inflate();
        long preferredScale = (long)lhs.scale() - (long)rhs.scale();
        if (rhs.signum() == 0) {
            if (lhs.signum() == 0) {
                throw new ArithmeticException("Division undefined");
            }
            throw new ArithmeticException("Division by zero");
        }
        if (lhs.signum() == 0) {
            return new BigDecimal(BigInteger.ZERO, (int)Math.max(Math.min(preferredScale, Integer.MAX_VALUE), Integer.MIN_VALUE));
        }
        BigDecimal xprime = new BigDecimal(lhs.intVal.abs(), lhs.precision());
        BigDecimal yprime = new BigDecimal(rhs.intVal.abs(), rhs.precision());
        if ((mc.roundingMode == RoundingMode.CEILING || mc.roundingMode == RoundingMode.FLOOR) && xprime.signum() != lhs.signum() ^ yprime.signum() != rhs.signum()) {
            mc = new MathContext(mc.precision, mc.roundingMode == RoundingMode.CEILING ? RoundingMode.FLOOR : RoundingMode.CEILING);
        }
        if (xprime.compareTo(yprime) > 0) {
            --yprime.scale;
        }
        BigDecimal result = xprime.divide(yprime, mc.precision, mc.roundingMode.oldMode);
        result.scale = this.checkScale((long)yprime.scale - (long)xprime.scale - (long)(rhs.scale - lhs.scale) + (long)mc.precision);
        if (lhs.signum() != rhs.signum()) {
            result = result.negate();
        }
        if ((result = result.doRound(mc)).multiply(divisor).compareTo(this) == 0) {
            return result.stripZerosToMatchScale(preferredScale);
        }
        return result;
    }

    public BigDecimal divideToIntegralValue(BigDecimal divisor) {
        int preferredScale = (int)Math.max(Math.min((long)this.scale() - (long)divisor.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        this.inflate();
        divisor.inflate();
        if (this.abs().compareTo(divisor.abs()) < 0) {
            return BigDecimal.valueOf(0L, preferredScale);
        }
        if (this.signum() == 0 && divisor.signum() != 0) {
            return this.setScale(preferredScale);
        }
        int maxDigits = (int)Math.min((long)this.precision() + (long)Math.ceil(10.0 * (double)divisor.precision() / 3.0) + Math.abs((long)this.scale() - (long)divisor.scale()) + 2L, Integer.MAX_VALUE);
        BigDecimal quotient = this.divide(divisor, new MathContext(maxDigits, RoundingMode.DOWN));
        if (quotient.scale > 0) {
            quotient = quotient.setScale(0, RoundingMode.DOWN).stripZerosToMatchScale(preferredScale);
        }
        if (quotient.scale < preferredScale) {
            quotient = quotient.setScale(preferredScale);
        }
        return quotient;
    }

    public BigDecimal divideToIntegralValue(BigDecimal divisor, MathContext mc) {
        int precisionDiff;
        if (mc.precision == 0 || this.abs().compareTo(divisor.abs()) < 0) {
            return this.divideToIntegralValue(divisor);
        }
        int preferredScale = (int)Math.max(Math.min((long)this.scale() - (long)divisor.scale(), Integer.MAX_VALUE), Integer.MIN_VALUE);
        BigDecimal result = this.divide(divisor, new MathContext(mc.precision, RoundingMode.DOWN));
        int resultScale = result.scale();
        if (result.scale() < 0) {
            BigDecimal product = result.multiply(divisor);
            if (this.subtract(product).abs().compareTo(divisor.abs()) >= 0) {
                throw new ArithmeticException("Division impossible");
            }
        } else if (result.scale() > 0) {
            result = result.setScale(0, RoundingMode.DOWN);
        }
        if (preferredScale > result.scale() && (precisionDiff = mc.precision - result.precision()) > 0) {
            return result.setScale(result.scale() + Math.min(precisionDiff, preferredScale - result.scale));
        }
        return result.stripZerosToMatchScale(preferredScale);
    }

    public BigDecimal remainder(BigDecimal divisor) {
        BigDecimal[] divrem = this.divideAndRemainder(divisor);
        return divrem[1];
    }

    public BigDecimal remainder(BigDecimal divisor, MathContext mc) {
        BigDecimal[] divrem = this.divideAndRemainder(divisor, mc);
        return divrem[1];
    }

    public BigDecimal[] divideAndRemainder(BigDecimal divisor) {
        BigDecimal[] result;
        result = new BigDecimal[]{this.divideToIntegralValue(divisor), this.subtract(result[0].multiply(divisor))};
        return result;
    }

    public BigDecimal[] divideAndRemainder(BigDecimal divisor, MathContext mc) {
        if (mc.precision == 0) {
            return this.divideAndRemainder(divisor);
        }
        BigDecimal[] result = new BigDecimal[2];
        BigDecimal lhs = this;
        result[0] = lhs.divideToIntegralValue(divisor, mc);
        result[1] = lhs.subtract(result[0].multiply(divisor));
        return result;
    }

    public BigDecimal pow(int n) {
        if (n < 0 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        int newScale = this.checkScale((long)this.scale * (long)n);
        this.inflate();
        return new BigDecimal(this.intVal.pow(n), newScale);
    }

    public BigDecimal pow(int n, MathContext mc) {
        if (mc.precision == 0) {
            return this.pow(n);
        }
        if (n < -999999999 || n > 999999999) {
            throw new ArithmeticException("Invalid operation");
        }
        if (n == 0) {
            return ONE;
        }
        this.inflate();
        BigDecimal lhs = this;
        MathContext workmc = mc;
        int mag = Math.abs(n);
        if (mc.precision > 0) {
            int elength = this.intLength(mag);
            if (elength > mc.precision) {
                throw new ArithmeticException("Invalid operation");
            }
            workmc = new MathContext(mc.precision + elength + 1, mc.roundingMode);
        }
        BigDecimal acc = ONE;
        boolean seenbit = false;
        int i = 1;
        while (true) {
            if ((mag += mag) < 0) {
                seenbit = true;
                acc = acc.multiply(lhs, workmc);
            }
            if (i == 31) break;
            if (seenbit) {
                acc = acc.multiply(acc, workmc);
            }
            ++i;
        }
        if (n < 0) {
            acc = ONE.divide(acc, workmc);
        }
        return acc.doRound(mc);
    }

    public BigDecimal abs() {
        return this.signum() < 0 ? this.negate() : this;
    }

    public BigDecimal abs(MathContext mc) {
        return this.signum() < 0 ? this.negate(mc) : this.plus(mc);
    }

    public BigDecimal negate() {
        BigDecimal result;
        if (this.intCompact != Long.MIN_VALUE) {
            result = BigDecimal.valueOf(-this.intCompact, this.scale);
        } else {
            result = new BigDecimal(this.intVal.negate(), this.scale);
            result.precision = this.precision;
        }
        return result;
    }

    public BigDecimal negate(MathContext mc) {
        return this.negate().plus(mc);
    }

    public BigDecimal plus() {
        return this;
    }

    public BigDecimal plus(MathContext mc) {
        if (mc.precision == 0) {
            return this;
        }
        return this.doRound(mc);
    }

    public int signum() {
        return this.intCompact != Long.MIN_VALUE ? Long.signum(this.intCompact) : this.intVal.signum();
    }

    public int scale() {
        return this.scale;
    }

    public int precision() {
        int result = this.precision;
        if (result == 0) {
            this.precision = result = this.digitLength();
        }
        return result;
    }

    public BigInteger unscaledValue() {
        return this.inflate().intVal;
    }

    public BigDecimal round(MathContext mc) {
        return this.plus(mc);
    }

    public BigDecimal setScale(int newScale, RoundingMode roundingMode) {
        return this.setScale(newScale, roundingMode.oldMode);
    }

    public BigDecimal setScale(int newScale, int roundingMode) {
        if (roundingMode < 0 || roundingMode > 7) {
            throw new IllegalArgumentException("Invalid rounding mode");
        }
        if (newScale == this.scale) {
            return this;
        }
        if (this.signum() == 0) {
            return BigDecimal.valueOf(0L, newScale);
        }
        if (newScale > this.scale) {
            int raise = this.checkScale((long)newScale - (long)this.scale);
            if (this.intCompact != Long.MIN_VALUE) {
                long scaledResult = BigDecimal.longTenToThe(this.intCompact, raise);
                if (scaledResult != Long.MIN_VALUE) {
                    return BigDecimal.valueOf(scaledResult, newScale);
                }
                this.inflate();
            }
            BigDecimal result = new BigDecimal(this.intVal.multiply(BigDecimal.tenToThe(raise)), newScale);
            if (this.precision > 0) {
                result.precision = this.precision + newScale - this.scale;
            }
            return result;
        }
        return this.divide(ONE, newScale, roundingMode);
    }

    public BigDecimal setScale(int newScale) {
        return this.setScale(newScale, 7);
    }

    public BigDecimal movePointLeft(int n) {
        int newScale = this.checkScale((long)this.scale + (long)n);
        BigDecimal num = this.intCompact != Long.MIN_VALUE ? BigDecimal.valueOf(this.intCompact, newScale) : new BigDecimal(this.intVal, newScale);
        return num.scale < 0 ? num.setScale(0) : num;
    }

    public BigDecimal movePointRight(int n) {
        int newScale = this.checkScale((long)this.scale - (long)n);
        BigDecimal num = this.intCompact != Long.MIN_VALUE ? BigDecimal.valueOf(this.intCompact, newScale) : new BigDecimal(this.intVal, newScale);
        return num.scale < 0 ? num.setScale(0) : num;
    }

    public BigDecimal scaleByPowerOfTen(int n) {
        this.inflate();
        BigDecimal num = new BigDecimal(this.intVal, this.checkScale((long)this.scale - (long)n));
        num.precision = this.precision;
        return num;
    }

    public BigDecimal stripTrailingZeros() {
        this.inflate();
        return new BigDecimal(this.intVal, this.scale).stripZerosToMatchScale(Long.MIN_VALUE);
    }

    @Override
    public int compareTo(BigDecimal val) {
        int aeval;
        if (this.scale == val.scale && this.intCompact != Long.MIN_VALUE && val.intCompact != Long.MIN_VALUE) {
            return BigDecimal.longCompareTo(this.intCompact, val.intCompact);
        }
        int sigDiff = this.signum() - val.signum();
        if (sigDiff != 0) {
            return sigDiff > 0 ? 1 : -1;
        }
        int aethis = this.precision() - this.scale;
        if (aethis < (aeval = val.precision() - val.scale)) {
            return -this.signum();
        }
        if (aethis > aeval) {
            return this.signum();
        }
        BigDecimal[] arg = new BigDecimal[]{this, val};
        BigDecimal.matchScale(arg);
        if (arg[0].intCompact != Long.MIN_VALUE && arg[1].intCompact != Long.MIN_VALUE) {
            return BigDecimal.longCompareTo(arg[0].intCompact, arg[1].intCompact);
        }
        return arg[0].inflate().intVal.compareTo(arg[1].inflate().intVal);
    }

    public boolean equals(Object x) {
        if (!(x instanceof BigDecimal)) {
            return false;
        }
        BigDecimal xDec = (BigDecimal)x;
        if (this.scale != xDec.scale) {
            return false;
        }
        if (this.intCompact != Long.MIN_VALUE && xDec.intCompact != Long.MIN_VALUE) {
            return this.intCompact == xDec.intCompact;
        }
        return this.inflate().intVal.equals(xDec.inflate().intVal);
    }

    public BigDecimal min(BigDecimal val) {
        return this.compareTo(val) <= 0 ? this : val;
    }

    public BigDecimal max(BigDecimal val) {
        return this.compareTo(val) >= 0 ? this : val;
    }

    public int hashCode() {
        if (this.intCompact != Long.MIN_VALUE) {
            long val2 = this.intCompact < 0L ? -this.intCompact : this.intCompact;
            int temp = (int)((long)((int)(val2 >>> 32) * 31) + (val2 & 0xFFFFFFFFL));
            return 31 * (this.intCompact < 0L ? -temp : temp) + this.scale;
        }
        return 31 * this.intVal.hashCode() + this.scale;
    }

    public String toString() {
        if (this.stringCache == null) {
            this.stringCache = this.layoutChars(true);
        }
        return this.stringCache;
    }

    public String toEngineeringString() {
        return this.layoutChars(false);
    }

    public String toPlainString() {
        BigDecimal bd = this;
        if (bd.scale < 0) {
            bd = bd.setScale(0);
        }
        bd.inflate();
        if (bd.scale == 0) {
            return bd.intVal.toString();
        }
        return bd.getValueString(bd.signum(), bd.intVal.abs().toString(), bd.scale);
    }

    private String getValueString(int signum, String intString, int scale) {
        StringBuilder buf;
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return (signum < 0 ? "-0." : "0.") + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuilder(intString);
            buf.insert(insertionPoint, '.');
            if (signum < 0) {
                buf.insert(0, '-');
            }
        } else {
            buf = new StringBuilder(3 - insertionPoint + intString.length());
            buf.append(signum < 0 ? "-0." : "0.");
            for (int i = 0; i < -insertionPoint; ++i) {
                buf.append('0');
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    public BigInteger toBigInteger() {
        return this.setScale((int)0, (int)1).inflate().intVal;
    }

    public BigInteger toBigIntegerExact() {
        return this.setScale((int)0, (int)7).inflate().intVal;
    }

    @Override
    public long longValue() {
        return this.intCompact != Long.MIN_VALUE && this.scale == 0 ? this.intCompact : this.toBigInteger().longValue();
    }

    public long longValueExact() {
        if (this.intCompact != Long.MIN_VALUE && this.scale == 0) {
            return this.intCompact;
        }
        if (this.precision() - this.scale > 19) {
            throw new ArithmeticException("Overflow");
        }
        if (this.signum() == 0) {
            return 0L;
        }
        if (this.precision() - this.scale <= 0) {
            throw new ArithmeticException("Rounding necessary");
        }
        BigDecimal num = this.setScale(0, 7).inflate();
        if (num.precision() >= 19) {
            LongOverflow.check(num);
        }
        return num.intVal.longValue();
    }

    @Override
    public int intValue() {
        return this.intCompact != Long.MIN_VALUE && this.scale == 0 ? (int)this.intCompact : this.toBigInteger().intValue();
    }

    public int intValueExact() {
        long num = this.longValueExact();
        if ((long)((int)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (int)num;
    }

    public short shortValueExact() {
        long num = this.longValueExact();
        if ((long)((short)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (short)num;
    }

    public byte byteValueExact() {
        long num = this.longValueExact();
        if ((long)((byte)num) != num) {
            throw new ArithmeticException("Overflow");
        }
        return (byte)num;
    }

    @Override
    public float floatValue() {
        if (this.scale == 0 && this.intCompact != Long.MIN_VALUE) {
            return this.intCompact;
        }
        return Float.parseFloat(this.toString());
    }

    @Override
    public double doubleValue() {
        if (this.scale == 0 && this.intCompact != Long.MIN_VALUE) {
            return this.intCompact;
        }
        return Double.parseDouble(this.toString());
    }

    public BigDecimal ulp() {
        return BigDecimal.valueOf(1L, this.scale());
    }

    private String layoutChars(boolean sci) {
        StringBuilder buf;
        block18: {
            long adjusted;
            block20: {
                int sig;
                char[] coeff;
                block21: {
                    block19: {
                        block17: {
                            if (this.scale == 0) {
                                return this.intCompact != Long.MIN_VALUE ? Long.toString(this.intCompact) : this.intVal.toString();
                            }
                            coeff = this.intCompact != Long.MIN_VALUE ? Long.toString(Math.abs(this.intCompact)).toCharArray() : this.intVal.abs().toString().toCharArray();
                            buf = new StringBuilder(coeff.length + 14);
                            if (this.signum() < 0) {
                                buf.append('-');
                            }
                            adjusted = -((long)this.scale) + (long)(coeff.length - 1);
                            if (this.scale < 0 || adjusted < -6L) break block17;
                            int pad = this.scale - coeff.length;
                            if (pad >= 0) {
                                buf.append('0');
                                buf.append('.');
                                while (pad > 0) {
                                    buf.append('0');
                                    --pad;
                                }
                                buf.append(coeff);
                            } else {
                                buf.append(coeff, 0, -pad);
                                buf.append('.');
                                buf.append(coeff, -pad, this.scale);
                            }
                            break block18;
                        }
                        if (!sci) break block19;
                        buf.append(coeff[0]);
                        if (coeff.length > 1) {
                            buf.append('.');
                            buf.append(coeff, 1, coeff.length - 1);
                        }
                        break block20;
                    }
                    sig = (int)(adjusted % 3L);
                    if (sig < 0) {
                        sig += 3;
                    }
                    adjusted -= (long)sig;
                    ++sig;
                    if (this.signum() != 0) break block21;
                    switch (sig) {
                        case 1: {
                            buf.append('0');
                            break block20;
                        }
                        case 2: {
                            buf.append("0.00");
                            adjusted += 3L;
                            break block20;
                        }
                        case 3: {
                            buf.append("0.0");
                            adjusted += 3L;
                            break block20;
                        }
                        default: {
                            throw new AssertionError((Object)("Unexpected sig value " + sig));
                        }
                    }
                }
                if (sig >= coeff.length) {
                    buf.append(coeff, 0, coeff.length);
                    for (int i = sig - coeff.length; i > 0; --i) {
                        buf.append('0');
                    }
                } else {
                    buf.append(coeff, 0, sig);
                    buf.append('.');
                    buf.append(coeff, sig, coeff.length - sig);
                }
            }
            if (adjusted != 0L) {
                buf.append('E');
                if (adjusted > 0L) {
                    buf.append('+');
                }
                buf.append(adjusted);
            }
        }
        return buf.toString();
    }

    private static BigInteger tenToThe(int n) {
        if (n < TENPOWERS.length) {
            return TENPOWERS[n];
        }
        char[] tenpow = new char[n + 1];
        tenpow[0] = 49;
        for (int i = 1; i <= n; ++i) {
            tenpow[i] = 48;
        }
        return new BigInteger(tenpow);
    }

    private static long longTenToThe(long val, int n) {
        if (n >= 0 && n < thresholds.length && Math.abs(val) <= thresholds[n][0]) {
            return val * thresholds[n][1];
        }
        return Long.MIN_VALUE;
    }

    private static boolean compactLong(long val) {
        return val != Long.MIN_VALUE;
    }

    private BigDecimal inflate() {
        if (this.intVal == null) {
            this.intVal = BigInteger.valueOf(this.intCompact);
        }
        return this;
    }

    private static void matchScale(BigDecimal[] val) {
        if (val[0].scale < val[1].scale) {
            val[0] = val[0].setScale(val[1].scale);
        } else if (val[1].scale < val[0].scale) {
            val[1] = val[1].setScale(val[0].scale);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.intVal == null) {
            String message = "BigDecimal: null intVal in stream";
            throw new StreamCorruptedException(message);
        }
        this.intCompact = Long.MIN_VALUE;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.inflate();
        s.defaultWriteObject();
    }

    private int digitLength() {
        if (this.intCompact != Long.MIN_VALUE && Math.abs(this.intCompact) <= Integer.MAX_VALUE) {
            return this.intLength(Math.abs((int)this.intCompact));
        }
        if (this.signum() == 0) {
            return 1;
        }
        this.inflate();
        BigInteger work = this.intVal;
        int digits = 0;
        while (work.mag.length > 1) {
            work = work.divide(TENPOWERS[9]);
            digits += 9;
            if (work.signum() != 0) continue;
            return digits;
        }
        return digits += this.intLength(work.mag[0]);
    }

    private int intLength(int x) {
        if (x < 0) {
            return 10;
        }
        if (x <= 9) {
            return 1;
        }
        int i = -1;
        while (x > ilogTable[i + 1]) {
            ++i;
        }
        return i + 1;
    }

    private BigDecimal stripZerosToMatchScale(long preferredScale) {
        BigInteger[] qr;
        boolean compact = this.intCompact != Long.MIN_VALUE;
        this.inflate();
        while (this.intVal.abs().compareTo(BigInteger.TEN) >= 0 && (long)this.scale > preferredScale && !this.intVal.testBit(0) && (qr = this.intVal.divideAndRemainder(BigInteger.TEN))[1].signum() == 0) {
            this.intVal = qr[0];
            this.scale = this.checkScale((long)this.scale - 1L);
            if (this.precision <= 0) continue;
            --this.precision;
        }
        if (compact) {
            this.intCompact = this.intVal.longValue();
        }
        return this;
    }

    private int checkScale(long val) {
        if ((long)((int)val) != val) {
            if (this.intCompact != Long.MIN_VALUE && this.intCompact != 0L || this.intVal != null && this.signum() != 0 || this.intVal == null && this.intCompact == Long.MIN_VALUE) {
                if (val > Integer.MAX_VALUE) {
                    throw new ArithmeticException("Underflow");
                }
                if (val < Integer.MIN_VALUE) {
                    throw new ArithmeticException("Overflow");
                }
            } else {
                return val > Integer.MAX_VALUE ? Integer.MAX_VALUE : Integer.MIN_VALUE;
            }
        }
        return (int)val;
    }

    private BigDecimal roundOp(MathContext mc) {
        BigDecimal rounded = this.doRound(mc);
        return rounded;
    }

    private void roundThis(MathContext mc) {
        BigDecimal rounded = this.doRound(mc);
        if (rounded == this) {
            return;
        }
        this.intVal = rounded.intVal;
        this.intCompact = rounded.intCompact;
        this.scale = rounded.scale;
        this.precision = rounded.precision;
    }

    private BigDecimal doRound(MathContext mc) {
        int drop;
        this.inflate();
        if (this.precision == 0) {
            if (mc.roundingMax != null && this.intVal.compareTo(mc.roundingMax) < 0 && this.intVal.compareTo(mc.roundingMin) > 0) {
                return this;
            }
            this.precision();
        }
        if ((drop = this.precision - mc.precision) <= 0) {
            return this;
        }
        BigDecimal rounded = this.dropDigits(mc, drop);
        return rounded.doRound(mc);
    }

    private BigDecimal dropDigits(MathContext mc, int drop) {
        BigDecimal divisor = new BigDecimal(BigDecimal.tenToThe(drop), 0);
        BigDecimal rounded = this.divide(divisor, this.scale, mc.roundingMode.oldMode);
        rounded.scale = this.checkScale((long)rounded.scale - (long)drop);
        return rounded;
    }

    private static int longCompareTo(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private static void print(String name, BigDecimal bd) {
        System.err.format("%s:\tintCompact %d\tintVal %d\tscale %d\tprecision %d%n", name, bd.intCompact, bd.intVal, bd.scale, bd.precision);
    }

    private BigDecimal audit() {
        long val;
        if (this.precision > 0 && this.precision != this.digitLength()) {
            BigDecimal.print("audit", this);
            throw new AssertionError((Object)"precision mismatch");
        }
        if (this.intCompact == Long.MIN_VALUE) {
            if (this.intVal == null) {
                BigDecimal.print("audit", this);
                throw new AssertionError((Object)"null intVal");
            }
        } else if (this.intVal != null && (val = this.intVal.longValue()) != this.intCompact) {
            BigDecimal.print("audit", this);
            throw new AssertionError((Object)("Inconsistent state, intCompact=" + this.intCompact + "\t intVal=" + val));
        }
        return this;
    }

    private static class LongOverflow {
        private static final BigInteger LONGMIN = BigInteger.valueOf(Long.MIN_VALUE);
        private static final BigInteger LONGMAX = BigInteger.valueOf(Long.MAX_VALUE);

        private LongOverflow() {
        }

        public static void check(BigDecimal num) {
            if (num.intVal.compareTo(LONGMIN) < 0 || num.intVal.compareTo(LONGMAX) > 0) {
                throw new ArithmeticException("Overflow");
            }
        }
    }
}

