/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import sun.awt.image.ImagingLib;

public class BandCombineOp
implements RasterOp {
    float[][] matrix;
    int nrows = 0;
    int ncols = 0;
    RenderingHints hints;

    public BandCombineOp(float[][] matrix, RenderingHints hints) {
        this.nrows = matrix.length;
        this.ncols = matrix[0].length;
        this.matrix = new float[this.nrows][];
        for (int i = 0; i < this.nrows; ++i) {
            if (this.ncols > matrix[i].length) {
                throw new IndexOutOfBoundsException("row " + i + " too short");
            }
            this.matrix[i] = Arrays.copyOf(matrix[i], this.ncols);
        }
        this.hints = hints;
    }

    public final float[][] getMatrix() {
        float[][] ret = new float[this.nrows][];
        for (int i = 0; i < this.nrows; ++i) {
            ret[i] = Arrays.copyOf(this.matrix[i], this.ncols);
        }
        return ret;
    }

    public WritableRaster filter(Raster src, WritableRaster dst) {
        int nBands = src.getNumBands();
        if (this.ncols != nBands && this.ncols != nBands + 1) {
            throw new IllegalArgumentException("Number of columns in the matrix (" + this.ncols + ") must be equal to the number" + " of bands ([+1]) in src (" + nBands + ").");
        }
        if (dst == null) {
            dst = this.createCompatibleDestRaster(src);
        } else if (this.nrows != dst.getNumBands()) {
            throw new IllegalArgumentException("Number of rows in the matrix (" + this.nrows + ") must be equal to the number" + " of bands ([+1]) in dst (" + nBands + ").");
        }
        if (ImagingLib.filter(this, src, dst) != null) {
            return dst;
        }
        int[] pixel = null;
        int[] dstPixel = new int[dst.getNumBands()];
        int sminX = src.getMinX();
        int sY = src.getMinY();
        int dminX = dst.getMinX();
        int dY = dst.getMinY();
        if (this.ncols == nBands) {
            int y = 0;
            while (y < src.getHeight()) {
                int dX = dminX;
                int sX = sminX;
                int x = 0;
                while (x < src.getWidth()) {
                    pixel = src.getPixel(sX, sY, pixel);
                    for (int r = 0; r < this.nrows; ++r) {
                        float accum = 0.0f;
                        for (int c = 0; c < this.ncols; ++c) {
                            accum += this.matrix[r][c] * (float)pixel[c];
                        }
                        dstPixel[r] = (int)accum;
                    }
                    dst.setPixel(dX, dY, dstPixel);
                    ++x;
                    ++sX;
                    ++dX;
                }
                ++y;
                ++sY;
                ++dY;
            }
        } else {
            int y = 0;
            while (y < src.getHeight()) {
                int dX = dminX;
                int sX = sminX;
                int x = 0;
                while (x < src.getWidth()) {
                    pixel = src.getPixel(sX, sY, pixel);
                    for (int r = 0; r < this.nrows; ++r) {
                        float accum = 0.0f;
                        for (int c = 0; c < nBands; ++c) {
                            accum += this.matrix[r][c] * (float)pixel[c];
                        }
                        dstPixel[r] = (int)(accum + this.matrix[r][nBands]);
                    }
                    dst.setPixel(dX, dY, dstPixel);
                    ++x;
                    ++sX;
                    ++dX;
                }
                ++y;
                ++sY;
                ++dY;
            }
        }
        return dst;
    }

    public final Rectangle2D getBounds2D(Raster src) {
        return src.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        int nBands = src.getNumBands();
        if (this.ncols != nBands && this.ncols != nBands + 1) {
            throw new IllegalArgumentException("Number of columns in the matrix (" + this.ncols + ") must be equal to the number" + " of bands ([+1]) in src (" + nBands + ").");
        }
        if (src.getNumBands() == this.nrows) {
            return src.createCompatibleWritableRaster();
        }
        throw new IllegalArgumentException("Don't know how to create a  compatible Raster with " + this.nrows + " bands.");
    }

    public final Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        if (dstPt == null) {
            dstPt = new Point2D.Float();
        }
        dstPt.setLocation(srcPt.getX(), srcPt.getY());
        return dstPt;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }
}

