/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextField
extends TextComponent {
    int columns;
    char echoChar;
    transient ActionListener actionListener;
    private static final String base = "textfield";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -2966288784432217853L;
    private int textFieldSerializedDataVersion = 1;

    private static native void initIDs();

    public TextField() throws HeadlessException {
        this("", 0);
    }

    public TextField(String text) throws HeadlessException {
        this(text, text != null ? text.length() : 0);
    }

    public TextField(int columns) throws HeadlessException {
        this("", columns);
    }

    public TextField(String text, int columns) throws HeadlessException {
        super(text);
        this.columns = columns >= 0 ? columns : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    String constructComponentName() {
        Class<TextField> clazz = TextField.class;
        synchronized (TextField.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return base + nameCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createTextField(this);
            }
            super.addNotify();
        }
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char c) {
        this.setEchoCharacter(c);
    }

    @Deprecated
    public synchronized void setEchoCharacter(char c) {
        if (this.echoChar != c) {
            this.echoChar = c;
            TextFieldPeer peer = (TextFieldPeer)this.peer;
            if (peer != null) {
                peer.setEchoCharacter(c);
            }
        }
    }

    @Override
    public void setText(String t) {
        super.setText(t);
        if (this.valid) {
            this.invalidate();
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public int getColumns() {
        return this.columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumns(int columns) {
        int oldVal;
        TextField textField = this;
        synchronized (textField) {
            oldVal = this.columns;
            if (columns < 0) {
                throw new IllegalArgumentException("columns less than zero.");
            }
            if (columns != oldVal) {
                this.columns = columns;
            }
        }
        if (columns != oldVal) {
            this.invalidate();
        }
    }

    public Dimension getPreferredSize(int columns) {
        return this.preferredSize(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension preferredSize(int columns) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextFieldPeer peer = (TextFieldPeer)this.peer;
            return peer != null ? peer.preferredSize(columns) : super.preferredSize();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.columns > 0 ? this.preferredSize(this.columns) : super.preferredSize();
        }
    }

    public Dimension getMinimumSize(int columns) {
        return this.minimumSize(columns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Dimension minimumSize(int columns) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextFieldPeer peer = (TextFieldPeer)this.peer;
            return peer != null ? peer.minimumSize(columns) : super.minimumSize();
        }
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.columns > 0 ? this.minimumSize(this.columns) : super.minimumSize();
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        this.newEventsOnly = true;
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (l == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    public synchronized ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(ActionListener.class);
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        ActionListener l = null;
        if (listenerType != ActionListener.class) {
            return super.getListeners(listenerType);
        }
        l = this.actionListener;
        return AWTEventMulticaster.getListeners((EventListener)l, listenerType);
    }

    @Override
    boolean eventEnabled(AWTEvent e) {
        if (e.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(e);
    }

    @Override
    protected void processEvent(AWTEvent e) {
        if (e instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)e);
            return;
        }
        super.processEvent(e);
    }

    protected void processActionEvent(ActionEvent e) {
        ActionListener listener = this.actionListener;
        if (listener != null) {
            listener.actionPerformed(e);
        }
    }

    @Override
    protected String paramString() {
        String str = super.paramString();
        if (this.echoChar != '\u0000') {
            str = str + ",echo=" + this.echoChar;
        }
        return str;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "actionL", this.actionListener);
        s.writeObject(null);
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException, HeadlessException {
        Object keyOrNull;
        s.defaultReadObject();
        if (this.columns < 0) {
            this.columns = 0;
        }
        while (null != (keyOrNull = s.readObject())) {
            String key = ((String)keyOrNull).intern();
            if ("actionL" == key) {
                this.addActionListener((ActionListener)s.readObject());
                continue;
            }
            s.readObject();
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTTextField();
        }
        return this.accessibleContext;
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            TextField.initIDs();
        }
    }

    protected class AccessibleAWTTextField
    extends TextComponent.AccessibleAWTTextComponent {
        private static final long serialVersionUID = 6219164359235943158L;

        protected AccessibleAWTTextField() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            states.add(AccessibleState.SINGLE_LINE);
            return states;
        }
    }
}

