/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.cert.internal.x509;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.util.Date;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509Certificate;

public class X509V1CertImpl
extends X509Certificate
implements Serializable {
    static final long serialVersionUID = -2048442350420423405L;
    private java.security.cert.X509Certificate wrappedCert;

    private static synchronized CertificateFactory getFactory() throws java.security.cert.CertificateException {
        return CertificateFactory.getInstance("X.509");
    }

    public X509V1CertImpl() {
    }

    public X509V1CertImpl(byte[] certData) throws CertificateException {
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(certData);
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.getFactory().generateCertificate(bs);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public X509V1CertImpl(InputStream in) throws CertificateException {
        try {
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.getFactory().generateCertificate(in);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.wrappedCert.getEncoded();
        }
        catch (java.security.cert.CertificateEncodingException e) {
            throw new CertificateEncodingException(e.getMessage());
        }
    }

    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.wrappedCert.verify(key);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            this.wrappedCert.verify(key, sigProvider);
        }
        catch (java.security.cert.CertificateException e) {
            throw new CertificateException(e.getMessage());
        }
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        try {
            this.wrappedCert.checkValidity(date);
        }
        catch (java.security.cert.CertificateNotYetValidException e) {
            throw new CertificateNotYetValidException(e.getMessage());
        }
        catch (java.security.cert.CertificateExpiredException e) {
            throw new CertificateExpiredException(e.getMessage());
        }
    }

    public String toString() {
        return this.wrappedCert.toString();
    }

    public PublicKey getPublicKey() {
        PublicKey key = this.wrappedCert.getPublicKey();
        return key;
    }

    public int getVersion() {
        return this.wrappedCert.getVersion() - 1;
    }

    public BigInteger getSerialNumber() {
        return this.wrappedCert.getSerialNumber();
    }

    public Principal getSubjectDN() {
        return this.wrappedCert.getSubjectDN();
    }

    public Principal getIssuerDN() {
        return this.wrappedCert.getIssuerDN();
    }

    public Date getNotBefore() {
        return this.wrappedCert.getNotBefore();
    }

    public Date getNotAfter() {
        return this.wrappedCert.getNotAfter();
    }

    public String getSigAlgName() {
        return this.wrappedCert.getSigAlgName();
    }

    public String getSigAlgOID() {
        return this.wrappedCert.getSigAlgOID();
    }

    public byte[] getSigAlgParams() {
        return this.wrappedCert.getSigAlgParams();
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        try {
            stream.write(this.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new IOException("getEncoded failed: " + e.getMessage());
        }
    }

    private synchronized void readObject(ObjectInputStream stream) throws IOException {
        try {
            this.wrappedCert = (java.security.cert.X509Certificate)X509V1CertImpl.getFactory().generateCertificate(stream);
        }
        catch (java.security.cert.CertificateException e) {
            throw new IOException("generateCertificate failed: " + e.getMessage());
        }
    }

    public java.security.cert.X509Certificate getX509Certificate() {
        return this.wrappedCert;
    }
}

