/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.LdapSchemaCtx;
import java.util.Vector;
import javax.naming.ConfigurationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;

final class LdapSchemaParser {
    private static final boolean debug = false;
    static final String OBJECTCLASSDESC_ATTR_ID = "objectClasses";
    static final String ATTRIBUTEDESC_ATTR_ID = "attributeTypes";
    static final String SYNTAXDESC_ATTR_ID = "ldapSyntaxes";
    static final String MATCHRULEDESC_ATTR_ID = "matchingRules";
    static final String OBJECTCLASS_DEFINITION_NAME = "ClassDefinition";
    private static final String[] CLASS_DEF_ATTRS = new String[]{"objectclass", "ClassDefinition"};
    static final String ATTRIBUTE_DEFINITION_NAME = "AttributeDefinition";
    private static final String[] ATTR_DEF_ATTRS = new String[]{"objectclass", "AttributeDefinition"};
    static final String SYNTAX_DEFINITION_NAME = "SyntaxDefinition";
    private static final String[] SYNTAX_DEF_ATTRS = new String[]{"objectclass", "SyntaxDefinition"};
    static final String MATCHRULE_DEFINITION_NAME = "MatchingRule";
    private static final String[] MATCHRULE_DEF_ATTRS = new String[]{"objectclass", "MatchingRule"};
    private static final char SINGLE_QUOTE = '\'';
    private static final char WHSP = ' ';
    private static final char OID_LIST_BEGIN = '(';
    private static final char OID_LIST_END = ')';
    private static final char OID_SEPARATOR = '$';
    private static final String NUMERICOID_ID = "NUMERICOID";
    private static final String NAME_ID = "NAME";
    private static final String DESC_ID = "DESC";
    private static final String OBSOLETE_ID = "OBSOLETE";
    private static final String SUP_ID = "SUP";
    private static final String PRIVATE_ID = "X-";
    private static final String ABSTRACT_ID = "ABSTRACT";
    private static final String STRUCTURAL_ID = "STRUCTURAL";
    private static final String AUXILARY_ID = "AUXILIARY";
    private static final String MUST_ID = "MUST";
    private static final String MAY_ID = "MAY";
    private static final String EQUALITY_ID = "EQUALITY";
    private static final String ORDERING_ID = "ORDERING";
    private static final String SUBSTR_ID = "SUBSTR";
    private static final String SYNTAX_ID = "SYNTAX";
    private static final String SINGLE_VAL_ID = "SINGLE-VALUE";
    private static final String COLLECTIVE_ID = "COLLECTIVE";
    private static final String NO_USER_MOD_ID = "NO-USER-MODIFICATION";
    private static final String USAGE_ID = "USAGE";
    private static final String SCHEMA_TRUE_VALUE = "true";
    private boolean netscapeBug;

    LdapSchemaParser(boolean netscapeBug) {
        this.netscapeBug = netscapeBug;
    }

    static final void LDAP2JNDISchema(Attributes schemaAttrs, LdapSchemaCtx schemaRoot) throws NamingException {
        Attribute objectClassesAttr = null;
        Attribute attributeDefAttr = null;
        Attribute syntaxDefAttr = null;
        Attribute matchRuleDefAttr = null;
        objectClassesAttr = schemaAttrs.get(OBJECTCLASSDESC_ATTR_ID);
        if (objectClassesAttr != null) {
            LdapSchemaParser.objectDescs2ClassDefs(objectClassesAttr, schemaRoot);
        }
        if ((attributeDefAttr = schemaAttrs.get(ATTRIBUTEDESC_ATTR_ID)) != null) {
            LdapSchemaParser.attrDescs2AttrDefs(attributeDefAttr, schemaRoot);
        }
        if ((syntaxDefAttr = schemaAttrs.get(SYNTAXDESC_ATTR_ID)) != null) {
            LdapSchemaParser.syntaxDescs2SyntaxDefs(syntaxDefAttr, schemaRoot);
        }
        if ((matchRuleDefAttr = schemaAttrs.get(MATCHRULEDESC_ATTR_ID)) != null) {
            LdapSchemaParser.matchRuleDescs2MatchRuleDefs(matchRuleDefAttr, schemaRoot);
        }
    }

    private static final DirContext objectDescs2ClassDefs(Attribute objDescsAttr, LdapSchemaCtx schemaRoot) throws NamingException {
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(CLASS_DEF_ATTRS[0], CLASS_DEF_ATTRS[1]);
        LdapSchemaCtx classDefTree = schemaRoot.setup(2, OBJECTCLASS_DEFINITION_NAME, attrs);
        NamingEnumeration<?> objDescs = objDescsAttr.getAll();
        while (objDescs.hasMore()) {
            String objDesc = (String)objDescs.next();
            try {
                Object[] def = LdapSchemaParser.desc2Def(objDesc);
                String currentName = (String)def[0];
                Attributes objDef = (Attributes)def[1];
                classDefTree.setup(6, currentName, objDef);
            }
            catch (NamingException ne) {}
        }
        return classDefTree;
    }

    private static final DirContext attrDescs2AttrDefs(Attribute attributeDescAttr, LdapSchemaCtx schemaRoot) throws NamingException {
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(ATTR_DEF_ATTRS[0], ATTR_DEF_ATTRS[1]);
        LdapSchemaCtx attrDefTree = schemaRoot.setup(3, ATTRIBUTE_DEFINITION_NAME, attrs);
        NamingEnumeration<?> attrDescs = attributeDescAttr.getAll();
        while (attrDescs.hasMore()) {
            String attrDesc = (String)attrDescs.next();
            try {
                Object[] def = LdapSchemaParser.desc2Def(attrDesc);
                String currentName = (String)def[0];
                Attributes attrDef = (Attributes)def[1];
                attrDefTree.setup(7, currentName, attrDef);
            }
            catch (NamingException ne) {}
        }
        return attrDefTree;
    }

    private static final DirContext syntaxDescs2SyntaxDefs(Attribute syntaxDescAttr, LdapSchemaCtx schemaRoot) throws NamingException {
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(SYNTAX_DEF_ATTRS[0], SYNTAX_DEF_ATTRS[1]);
        LdapSchemaCtx syntaxDefTree = schemaRoot.setup(4, SYNTAX_DEFINITION_NAME, attrs);
        NamingEnumeration<?> syntaxDescs = syntaxDescAttr.getAll();
        while (syntaxDescs.hasMore()) {
            String syntaxDesc = (String)syntaxDescs.next();
            try {
                Object[] def = LdapSchemaParser.desc2Def(syntaxDesc);
                String currentName = (String)def[0];
                Attributes syntaxDef = (Attributes)def[1];
                syntaxDefTree.setup(8, currentName, syntaxDef);
            }
            catch (NamingException ne) {}
        }
        return syntaxDefTree;
    }

    private static final DirContext matchRuleDescs2MatchRuleDefs(Attribute matchRuleDescAttr, LdapSchemaCtx schemaRoot) throws NamingException {
        BasicAttributes attrs = new BasicAttributes(true);
        attrs.put(MATCHRULE_DEF_ATTRS[0], MATCHRULE_DEF_ATTRS[1]);
        LdapSchemaCtx matchRuleDefTree = schemaRoot.setup(5, MATCHRULE_DEFINITION_NAME, attrs);
        NamingEnumeration<?> matchRuleDescs = matchRuleDescAttr.getAll();
        while (matchRuleDescs.hasMore()) {
            String matchRuleDesc = (String)matchRuleDescs.next();
            try {
                Object[] def = LdapSchemaParser.desc2Def(matchRuleDesc);
                String currentName = (String)def[0];
                Attributes matchRuleDef = (Attributes)def[1];
                matchRuleDefTree.setup(9, currentName, matchRuleDef);
            }
            catch (NamingException ne) {}
        }
        return matchRuleDefTree;
    }

    private static final Object[] desc2Def(String desc) throws NamingException {
        BasicAttributes attrs = new BasicAttributes(true);
        Attribute attr = null;
        int[] pos = new int[]{1};
        boolean moreTags = true;
        attr = LdapSchemaParser.readNumericOID(desc, pos);
        String currentName = (String)attr.get(0);
        attrs.put(attr);
        LdapSchemaParser.skipWhitespace(desc, pos);
        while (moreTags) {
            attr = LdapSchemaParser.readNextTag(desc, pos);
            attrs.put(attr);
            if (attr.getID().equals(NAME_ID)) {
                currentName = (String)attr.get(0);
            }
            LdapSchemaParser.skipWhitespace(desc, pos);
            if (pos[0] < desc.length() - 1) continue;
            moreTags = false;
        }
        return new Object[]{currentName, attrs};
    }

    private static final int findTrailingWhitespace(String string, int pos) {
        for (int i = pos; i > 0; --i) {
            if (string.charAt(i) == ' ') continue;
            return i + 1;
        }
        return 0;
    }

    private static final void skipWhitespace(String string, int[] pos) {
        for (int i = pos[0]; i < string.length(); ++i) {
            if (string.charAt(i) == ' ') continue;
            pos[0] = i;
            return;
        }
    }

    private static final Attribute readNumericOID(String string, int[] pos) throws NamingException {
        String value = null;
        LdapSchemaParser.skipWhitespace(string, pos);
        int begin = pos[0];
        int end = string.indexOf(32, begin);
        if (end == -1 || end - begin < 1) {
            throw new InvalidAttributeValueException("no numericoid found: " + string);
        }
        value = string.substring(begin, end);
        pos[0] = pos[0] + value.length();
        return new BasicAttribute(NUMERICOID_ID, value);
    }

    private static final Attribute readNextTag(String string, int[] pos) throws NamingException {
        BasicAttribute attr = null;
        String tagName = null;
        String[] values = null;
        LdapSchemaParser.skipWhitespace(string, pos);
        int trailingSpace = string.indexOf(32, pos[0]);
        tagName = trailingSpace < 0 ? string.substring(pos[0], string.length() - 1) : string.substring(pos[0], trailingSpace);
        values = LdapSchemaParser.readTag(tagName, string, pos);
        if (values.length < 0) {
            throw new InvalidAttributeValueException("no values for attribute \"" + tagName + "\"");
        }
        attr = new BasicAttribute(tagName, values[0]);
        for (int i = 1; i < values.length; ++i) {
            attr.add(values[i]);
        }
        return attr;
    }

    private static final String[] readTag(String tag, String string, int[] pos) throws NamingException {
        pos[0] = pos[0] + tag.length();
        LdapSchemaParser.skipWhitespace(string, pos);
        if (tag.equals(NAME_ID)) {
            return LdapSchemaParser.readQDescrs(string, pos);
        }
        if (tag.equals(DESC_ID)) {
            return LdapSchemaParser.readQDString(string, pos);
        }
        if (tag.equals(EQUALITY_ID) || tag.equals(ORDERING_ID) || tag.equals(SUBSTR_ID) || tag.equals(SYNTAX_ID)) {
            return LdapSchemaParser.readWOID(string, pos);
        }
        if (tag.equals(OBSOLETE_ID) || tag.equals(ABSTRACT_ID) || tag.equals(STRUCTURAL_ID) || tag.equals(AUXILARY_ID) || tag.equals(SINGLE_VAL_ID) || tag.equals(COLLECTIVE_ID) || tag.equals(NO_USER_MOD_ID)) {
            return new String[]{SCHEMA_TRUE_VALUE};
        }
        if (tag.equals(SUP_ID) || tag.equals(MUST_ID) || tag.equals(MAY_ID) || tag.equals(USAGE_ID)) {
            return LdapSchemaParser.readOIDs(string, pos);
        }
        return LdapSchemaParser.readQDStrings(string, pos);
    }

    private static final String[] readQDString(String string, int[] pos) throws NamingException {
        int begin = string.indexOf(39, pos[0]) + 1;
        int end = string.indexOf(39, begin);
        if (begin == -1 || end == -1 || begin == end) {
            throw new InvalidAttributeIdentifierException("malformed QDString: " + string);
        }
        if (string.charAt(begin - 1) != '\'') {
            throw new InvalidAttributeIdentifierException("qdstring has no end mark: " + string);
        }
        pos[0] = end + 1;
        return new String[]{string.substring(begin, end)};
    }

    private static final String[] readQDStrings(String string, int[] pos) throws NamingException {
        return LdapSchemaParser.readQDescrs(string, pos);
    }

    private static final String[] readQDescrs(String string, int[] pos) throws NamingException {
        LdapSchemaParser.skipWhitespace(string, pos);
        switch (string.charAt(pos[0])) {
            case '(': {
                return LdapSchemaParser.readQDescrList(string, pos);
            }
            case '\'': {
                return LdapSchemaParser.readQDString(string, pos);
            }
        }
        throw new InvalidAttributeValueException("unexpected oids string: " + string);
    }

    private static final String[] readQDescrList(String string, int[] pos) throws NamingException {
        Vector<String> values = new Vector<String>(5);
        pos[0] = pos[0] + 1;
        LdapSchemaParser.skipWhitespace(string, pos);
        int begin = pos[0];
        int end = string.indexOf(41, begin);
        if (end == -1) {
            throw new InvalidAttributeValueException("oidlist has no end mark: " + string);
        }
        while (begin < end) {
            String[] one = LdapSchemaParser.readQDString(string, pos);
            values.addElement(one[0]);
            LdapSchemaParser.skipWhitespace(string, pos);
            begin = pos[0];
        }
        pos[0] = end + 1;
        String[] answer = new String[values.size()];
        for (int i = 0; i < answer.length; ++i) {
            answer[i] = (String)values.elementAt(i);
        }
        return answer;
    }

    private static final String[] readWOID(String string, int[] pos) throws NamingException {
        LdapSchemaParser.skipWhitespace(string, pos);
        if (string.charAt(pos[0]) == '\'') {
            return LdapSchemaParser.readQDString(string, pos);
        }
        int begin = pos[0];
        int end = string.indexOf(32, begin);
        if (end == -1 || begin == end) {
            throw new InvalidAttributeIdentifierException("malformed OID: " + string);
        }
        pos[0] = end + 1;
        return new String[]{string.substring(begin, end)};
    }

    private static final String[] readOIDs(String string, int[] pos) throws NamingException {
        int wsBegin;
        LdapSchemaParser.skipWhitespace(string, pos);
        if (string.charAt(pos[0]) != '(') {
            return LdapSchemaParser.readWOID(string, pos);
        }
        String oidName = null;
        Vector<String> values = new Vector<String>(5);
        pos[0] = pos[0] + 1;
        LdapSchemaParser.skipWhitespace(string, pos);
        int begin = pos[0];
        int end = string.indexOf(41, begin);
        int cur = string.indexOf(36, begin);
        if (end == -1) {
            throw new InvalidAttributeValueException("oidlist has no end mark: " + string);
        }
        if (cur == -1 || end < cur) {
            cur = end;
        }
        while (cur < end && cur > 0) {
            wsBegin = LdapSchemaParser.findTrailingWhitespace(string, cur - 1);
            oidName = string.substring(begin, wsBegin);
            values.addElement(oidName);
            pos[0] = cur + 1;
            LdapSchemaParser.skipWhitespace(string, pos);
            begin = pos[0];
            cur = string.indexOf(36, begin);
        }
        wsBegin = LdapSchemaParser.findTrailingWhitespace(string, end - 1);
        oidName = string.substring(begin, wsBegin);
        values.addElement(oidName);
        pos[0] = end + 1;
        String[] answer = new String[values.size()];
        for (int i = 0; i < answer.length; ++i) {
            answer[i] = (String)values.elementAt(i);
        }
        return answer;
    }

    private final String classDef2ObjectDesc(Attributes attrs) throws NamingException {
        StringBuffer objectDesc = new StringBuffer("( ");
        Attribute attr = null;
        int count = 0;
        attr = attrs.get(NUMERICOID_ID);
        if (attr != null) {
            objectDesc.append(this.writeNumericOID(attr));
            ++count;
        } else {
            throw new ConfigurationException("Class definition doesn'thave a numeric OID");
        }
        attr = attrs.get(NAME_ID);
        if (attr != null) {
            objectDesc.append(this.writeQDescrs(attr));
            ++count;
        }
        if ((attr = attrs.get(DESC_ID)) != null) {
            objectDesc.append(this.writeQDString(attr));
            ++count;
        }
        if ((attr = attrs.get(OBSOLETE_ID)) != null) {
            objectDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(SUP_ID)) != null) {
            objectDesc.append(this.writeOIDs(attr));
            ++count;
        }
        if ((attr = attrs.get(ABSTRACT_ID)) != null) {
            objectDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(STRUCTURAL_ID)) != null) {
            objectDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(AUXILARY_ID)) != null) {
            objectDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(MUST_ID)) != null) {
            objectDesc.append(this.writeOIDs(attr));
            ++count;
        }
        if ((attr = attrs.get(MAY_ID)) != null) {
            objectDesc.append(this.writeOIDs(attr));
            ++count;
        }
        if (count < attrs.size()) {
            String attrId = null;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                attr = ae.next();
                attrId = attr.getID();
                if (attrId.equals(NUMERICOID_ID) || attrId.equals(NAME_ID) || attrId.equals(SUP_ID) || attrId.equals(MAY_ID) || attrId.equals(MUST_ID) || attrId.equals(STRUCTURAL_ID) || attrId.equals(DESC_ID) || attrId.equals(AUXILARY_ID) || attrId.equals(ABSTRACT_ID) || attrId.equals(OBSOLETE_ID)) continue;
                objectDesc.append(this.writeQDStrings(attr));
            }
        }
        objectDesc.append(")");
        return objectDesc.toString();
    }

    private final String attrDef2AttrDesc(Attributes attrs) throws NamingException {
        StringBuffer attrDesc = new StringBuffer("( ");
        Attribute attr = null;
        int count = 0;
        attr = attrs.get(NUMERICOID_ID);
        if (attr != null) {
            attrDesc.append(this.writeNumericOID(attr));
            ++count;
        } else {
            throw new ConfigurationException("Attribute type doesn'thave a numeric OID");
        }
        attr = attrs.get(NAME_ID);
        if (attr != null) {
            attrDesc.append(this.writeQDescrs(attr));
            ++count;
        }
        if ((attr = attrs.get(DESC_ID)) != null) {
            attrDesc.append(this.writeQDString(attr));
            ++count;
        }
        if ((attr = attrs.get(OBSOLETE_ID)) != null) {
            attrDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(SUP_ID)) != null) {
            attrDesc.append(this.writeWOID(attr));
            ++count;
        }
        if ((attr = attrs.get(EQUALITY_ID)) != null) {
            attrDesc.append(this.writeWOID(attr));
            ++count;
        }
        if ((attr = attrs.get(ORDERING_ID)) != null) {
            attrDesc.append(this.writeWOID(attr));
            ++count;
        }
        if ((attr = attrs.get(SUBSTR_ID)) != null) {
            attrDesc.append(this.writeWOID(attr));
            ++count;
        }
        if ((attr = attrs.get(SYNTAX_ID)) != null) {
            attrDesc.append(this.writeWOID(attr));
            ++count;
        }
        if ((attr = attrs.get(SINGLE_VAL_ID)) != null) {
            attrDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(COLLECTIVE_ID)) != null) {
            attrDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(NO_USER_MOD_ID)) != null) {
            attrDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(USAGE_ID)) != null) {
            attrDesc.append(this.writeQDString(attr));
            ++count;
        }
        if (count < attrs.size()) {
            String attrId = null;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                attr = ae.next();
                attrId = attr.getID();
                if (attrId.equals(NUMERICOID_ID) || attrId.equals(NAME_ID) || attrId.equals(SYNTAX_ID) || attrId.equals(DESC_ID) || attrId.equals(SINGLE_VAL_ID) || attrId.equals(EQUALITY_ID) || attrId.equals(ORDERING_ID) || attrId.equals(SUBSTR_ID) || attrId.equals(NO_USER_MOD_ID) || attrId.equals(USAGE_ID) || attrId.equals(SUP_ID) || attrId.equals(COLLECTIVE_ID) || attrId.equals(OBSOLETE_ID)) continue;
                attrDesc.append(this.writeQDStrings(attr));
            }
        }
        attrDesc.append(")");
        return attrDesc.toString();
    }

    private final String syntaxDef2SyntaxDesc(Attributes attrs) throws NamingException {
        StringBuffer syntaxDesc = new StringBuffer("( ");
        Attribute attr = null;
        int count = 0;
        attr = attrs.get(NUMERICOID_ID);
        if (attr != null) {
            syntaxDesc.append(this.writeNumericOID(attr));
            ++count;
        } else {
            throw new ConfigurationException("Attribute type doesn'thave a numeric OID");
        }
        attr = attrs.get(DESC_ID);
        if (attr != null) {
            syntaxDesc.append(this.writeQDString(attr));
            ++count;
        }
        if (count < attrs.size()) {
            String attrId = null;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                attr = ae.next();
                attrId = attr.getID();
                if (attrId.equals(NUMERICOID_ID) || attrId.equals(DESC_ID)) continue;
                syntaxDesc.append(this.writeQDStrings(attr));
            }
        }
        syntaxDesc.append(")");
        return syntaxDesc.toString();
    }

    private final String matchRuleDef2MatchRuleDesc(Attributes attrs) throws NamingException {
        StringBuffer matchRuleDesc = new StringBuffer("( ");
        Attribute attr = null;
        int count = 0;
        attr = attrs.get(NUMERICOID_ID);
        if (attr != null) {
            matchRuleDesc.append(this.writeNumericOID(attr));
            ++count;
        } else {
            throw new ConfigurationException("Attribute type doesn'thave a numeric OID");
        }
        attr = attrs.get(NAME_ID);
        if (attr != null) {
            matchRuleDesc.append(this.writeQDescrs(attr));
            ++count;
        }
        if ((attr = attrs.get(DESC_ID)) != null) {
            matchRuleDesc.append(this.writeQDString(attr));
            ++count;
        }
        if ((attr = attrs.get(OBSOLETE_ID)) != null) {
            matchRuleDesc.append(this.writeBoolean(attr));
            ++count;
        }
        if ((attr = attrs.get(SYNTAX_ID)) == null) {
            throw new ConfigurationException("Attribute type doesn'thave a syntax OID");
        }
        matchRuleDesc.append(this.writeWOID(attr));
        if (++count < attrs.size()) {
            String attrId = null;
            NamingEnumeration<? extends Attribute> ae = attrs.getAll();
            while (ae.hasMoreElements()) {
                attr = ae.next();
                attrId = attr.getID();
                if (attrId.equals(NUMERICOID_ID) || attrId.equals(NAME_ID) || attrId.equals(SYNTAX_ID) || attrId.equals(DESC_ID) || attrId.equals(OBSOLETE_ID)) continue;
                matchRuleDesc.append(this.writeQDStrings(attr));
            }
        }
        matchRuleDesc.append(")");
        return matchRuleDesc.toString();
    }

    private final String writeNumericOID(Attribute nOIDAttr) throws NamingException {
        if (nOIDAttr.size() != 1) {
            throw new InvalidAttributeValueException("A class definition must have exactly one numeric OID");
        }
        return (String)nOIDAttr.get() + ' ';
    }

    private final String writeWOID(Attribute attr) throws NamingException {
        if (this.netscapeBug) {
            return this.writeQDString(attr);
        }
        return attr.getID() + ' ' + attr.get() + ' ';
    }

    private final String writeQDString(Attribute qdStringAttr) throws NamingException {
        if (qdStringAttr.size() != 1) {
            throw new InvalidAttributeValueException(qdStringAttr.getID() + " must have exactly one value");
        }
        return qdStringAttr.getID() + ' ' + '\'' + qdStringAttr.get() + '\'' + ' ';
    }

    private final String writeQDStrings(Attribute attr) throws NamingException {
        return this.writeQDescrs(attr);
    }

    private final String writeQDescrs(Attribute attr) throws NamingException {
        switch (attr.size()) {
            case 0: {
                throw new InvalidAttributeValueException(attr.getID() + "has no values");
            }
            case 1: {
                return this.writeQDString(attr);
            }
        }
        StringBuffer qdList = new StringBuffer(attr.getID());
        qdList.append(' ');
        qdList.append('(');
        NamingEnumeration<?> values = attr.getAll();
        while (values.hasMore()) {
            qdList.append(' ');
            qdList.append('\'');
            qdList.append((String)values.next());
            qdList.append('\'');
            qdList.append(' ');
        }
        qdList.append(')');
        qdList.append(' ');
        return qdList.toString();
    }

    private final String writeOIDs(Attribute oidsAttr) throws NamingException {
        switch (oidsAttr.size()) {
            case 0: {
                throw new InvalidAttributeValueException(oidsAttr.getID() + "has no values");
            }
            case 1: {
                if (this.netscapeBug) break;
                return this.writeWOID(oidsAttr);
            }
        }
        StringBuffer oidList = new StringBuffer(oidsAttr.getID());
        oidList.append(' ');
        oidList.append('(');
        NamingEnumeration<?> values = oidsAttr.getAll();
        oidList.append(' ');
        oidList.append(values.next());
        while (values.hasMore()) {
            oidList.append(' ');
            oidList.append('$');
            oidList.append(' ');
            oidList.append((String)values.next());
        }
        oidList.append(' ');
        oidList.append(')');
        oidList.append(' ');
        return oidList.toString();
    }

    private final String writeBoolean(Attribute booleanAttr) throws NamingException {
        return booleanAttr.getID() + ' ';
    }

    final Attribute stringifyObjDesc(Attributes classDefAttrs) throws NamingException {
        BasicAttribute objDescAttr = new BasicAttribute(OBJECTCLASSDESC_ATTR_ID);
        objDescAttr.add(this.classDef2ObjectDesc(classDefAttrs));
        return objDescAttr;
    }

    final Attribute stringifyAttrDesc(Attributes attrDefAttrs) throws NamingException {
        BasicAttribute attrDescAttr = new BasicAttribute(ATTRIBUTEDESC_ATTR_ID);
        attrDescAttr.add(this.attrDef2AttrDesc(attrDefAttrs));
        return attrDescAttr;
    }

    final Attribute stringifySyntaxDesc(Attributes syntaxDefAttrs) throws NamingException {
        BasicAttribute syntaxDescAttr = new BasicAttribute(SYNTAXDESC_ATTR_ID);
        syntaxDescAttr.add(this.syntaxDef2SyntaxDesc(syntaxDefAttrs));
        return syntaxDescAttr;
    }

    final Attribute stringifyMatchRuleDesc(Attributes matchRuleDefAttrs) throws NamingException {
        BasicAttribute matchRuleDescAttr = new BasicAttribute(MATCHRULEDESC_ATTR_ID);
        matchRuleDescAttr.add(this.matchRuleDef2MatchRuleDesc(matchRuleDefAttrs));
        return matchRuleDescAttr;
    }
}

