/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.mbeanserver;

import com.sun.jmx.mbeanserver.MBeanAnalyzer;
import com.sun.jmx.mbeanserver.MBeanIntrospector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.WeakHashMap;
import javax.management.Descriptor;
import javax.management.ImmutableDescriptor;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationBroadcasterSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StandardMBeanIntrospector
extends MBeanIntrospector<Method> {
    private static final StandardMBeanIntrospector instance = new StandardMBeanIntrospector();
    private static final WeakHashMap<Class<?>, Boolean> definitelyImmutable = new WeakHashMap();
    private static final MBeanIntrospector.PerInterfaceMap<Method> perInterfaceMap = new MBeanIntrospector.PerInterfaceMap();
    private static final MBeanIntrospector.MBeanInfoMap mbeanInfoMap = new MBeanIntrospector.MBeanInfoMap();

    StandardMBeanIntrospector() {
    }

    static StandardMBeanIntrospector getInstance() {
        return instance;
    }

    @Override
    MBeanIntrospector.PerInterfaceMap<Method> getPerInterfaceMap() {
        return perInterfaceMap;
    }

    @Override
    MBeanIntrospector.MBeanInfoMap getMBeanInfoMap() {
        return mbeanInfoMap;
    }

    @Override
    MBeanAnalyzer<Method> getAnalyzer(Class<?> mbeanInterface) throws NotCompliantMBeanException {
        return MBeanAnalyzer.analyzer(mbeanInterface, this);
    }

    @Override
    boolean isMXBean() {
        return false;
    }

    @Override
    Method mFrom(Method m) {
        return m;
    }

    @Override
    String getName(Method m) {
        return m.getName();
    }

    @Override
    Type getGenericReturnType(Method m) {
        return m.getGenericReturnType();
    }

    @Override
    Type[] getGenericParameterTypes(Method m) {
        return m.getGenericParameterTypes();
    }

    @Override
    String[] getSignature(Method m) {
        Class<?>[] params = m.getParameterTypes();
        String[] sig = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            sig[i] = params[i].getName();
        }
        return sig;
    }

    @Override
    void checkMethod(Method m) {
    }

    @Override
    Object invokeM2(Method m, Object target, Object[] args, Object cookie) throws InvocationTargetException, IllegalAccessException, MBeanException {
        return m.invoke(target, args);
    }

    @Override
    boolean validParameter(Method m, Object value, int paramNo, Object cookie) {
        return StandardMBeanIntrospector.isValidParameter(m, value, paramNo);
    }

    @Override
    MBeanAttributeInfo getMBeanAttributeInfo(String attributeName, Method getter, Method setter) {
        String description = "Attribute exposed for management";
        try {
            return new MBeanAttributeInfo(attributeName, "Attribute exposed for management", getter, setter);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    MBeanOperationInfo getMBeanOperationInfo(String operationName, Method operation) {
        String description = "Operation exposed for management";
        return new MBeanOperationInfo("Operation exposed for management", operation);
    }

    @Override
    Descriptor getBasicMBeanDescriptor() {
        return ImmutableDescriptor.EMPTY_DESCRIPTOR;
    }

    @Override
    Descriptor getMBeanDescriptor(Class<?> resourceClass) {
        boolean immutable = StandardMBeanIntrospector.isDefinitelyImmutableInfo(resourceClass);
        return new ImmutableDescriptor("mxbean=false", "immutableInfo=" + immutable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isDefinitelyImmutableInfo(Class<?> implClass) {
        if (!NotificationBroadcaster.class.isAssignableFrom(implClass)) {
            return true;
        }
        WeakHashMap<Class<?>, Boolean> weakHashMap = definitelyImmutable;
        synchronized (weakHashMap) {
            Boolean immutable = definitelyImmutable.get(implClass);
            if (immutable == null) {
                Class<NotificationBroadcasterSupport> nbs = NotificationBroadcasterSupport.class;
                if (nbs.isAssignableFrom(implClass)) {
                    try {
                        Method m = implClass.getMethod("getNotificationInfo", new Class[0]);
                        immutable = m.getDeclaringClass() == nbs;
                    }
                    catch (Exception e) {
                        return false;
                    }
                } else {
                    immutable = false;
                }
                definitelyImmutable.put(implClass, immutable);
            }
            return immutable;
        }
    }
}

