/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class MotifSplitPaneDivider
extends BasicSplitPaneDivider {
    private static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    public static final int minimumThumbSize = 6;
    public static final int defaultDividerSize = 18;
    protected static final int pad = 6;
    private int hThumbOffset = 30;
    private int vThumbOffset = 40;
    protected int hThumbWidth = 12;
    protected int hThumbHeight = 18;
    protected int vThumbWidth = 18;
    protected int vThumbHeight = 12;
    protected Color highlightColor = UIManager.getColor("SplitPane.highlight");
    protected Color shadowColor = UIManager.getColor("SplitPane.shadow");
    protected Color focusedColor = UIManager.getColor("SplitPane.activeThumb");

    public MotifSplitPaneDivider(BasicSplitPaneUI ui) {
        super(ui);
        this.setDividerSize(this.hThumbWidth + 6);
    }

    public void setDividerSize(int newSize) {
        Insets insets = this.getInsets();
        int borderSize = 0;
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            if (insets != null) {
                borderSize = insets.left + insets.right;
            }
        } else if (insets != null) {
            borderSize = insets.top + insets.bottom;
        }
        if (newSize < 12 + borderSize) {
            this.setDividerSize(12 + borderSize);
        } else {
            this.vThumbHeight = this.hThumbWidth = newSize - 6 - borderSize;
            super.setDividerSize(newSize);
        }
    }

    public void paint(Graphics g) {
        Color bgColor = this.getBackground();
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            int center = size.width / 2;
            int x = center - this.hThumbWidth / 2;
            int y = this.hThumbOffset;
            g.setColor(this.shadowColor);
            g.drawLine(center - 1, 0, center - 1, size.height);
            g.setColor(this.highlightColor);
            g.drawLine(center, 0, center, size.height);
            g.setColor(this.splitPane.hasFocus() ? this.focusedColor : this.getBackground());
            g.fillRect(x + 1, y + 1, this.hThumbWidth - 2, this.hThumbHeight - 1);
            g.setColor(this.highlightColor);
            g.drawLine(x, y, x + this.hThumbWidth - 1, y);
            g.drawLine(x, y + 1, x, y + this.hThumbHeight - 1);
            g.setColor(this.shadowColor);
            g.drawLine(x + 1, y + this.hThumbHeight - 1, x + this.hThumbWidth - 1, y + this.hThumbHeight - 1);
            g.drawLine(x + this.hThumbWidth - 1, y + 1, x + this.hThumbWidth - 1, y + this.hThumbHeight - 2);
        } else {
            int center = size.height / 2;
            int x = size.width - this.vThumbOffset;
            int y = size.height / 2 - this.vThumbHeight / 2;
            g.setColor(this.shadowColor);
            g.drawLine(0, center - 1, size.width, center - 1);
            g.setColor(this.highlightColor);
            g.drawLine(0, center, size.width, center);
            g.setColor(this.splitPane.hasFocus() ? this.focusedColor : this.getBackground());
            g.fillRect(x + 1, y + 1, this.vThumbWidth - 1, this.vThumbHeight - 1);
            g.setColor(this.highlightColor);
            g.drawLine(x, y, x + this.vThumbWidth, y);
            g.drawLine(x, y + 1, x, y + this.vThumbHeight);
            g.setColor(this.shadowColor);
            g.drawLine(x + 1, y + this.vThumbHeight, x + this.vThumbWidth, y + this.vThumbHeight);
            g.drawLine(x + this.vThumbWidth, y + 1, x + this.vThumbWidth, y + this.vThumbHeight - 1);
        }
        super.paint(g);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = newUI;
        if (newUI != null) {
            this.splitPane = newUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MotifMouseHandler();
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    private boolean isInThumb(int x, int y) {
        int thumbHeight;
        int thumbWidth;
        int thumbY;
        int thumbX;
        Dimension size = this.getSize();
        if (this.getBasicSplitPaneUI().getOrientation() == 1) {
            int center = size.width / 2;
            thumbX = center - this.hThumbWidth / 2;
            thumbY = this.hThumbOffset;
            thumbWidth = this.hThumbWidth;
            thumbHeight = this.hThumbHeight;
        } else {
            int center = size.height / 2;
            thumbX = size.width - this.vThumbOffset;
            thumbY = size.height / 2 - this.vThumbHeight / 2;
            thumbWidth = this.vThumbWidth;
            thumbHeight = this.vThumbHeight;
        }
        return x >= thumbX && x < thumbX + thumbWidth && y >= thumbY && y < thumbY + thumbHeight;
    }

    private BasicSplitPaneDivider.DragController getDragger() {
        return this.dragger;
    }

    private JSplitPane getSplitPane() {
        return this.splitPane;
    }

    private class MotifMouseHandler
    extends BasicSplitPaneDivider.MouseHandler {
        private MotifMouseHandler() {
            super(MotifSplitPaneDivider.this);
        }

        public void mousePressed(MouseEvent e) {
            if (e.getSource() == MotifSplitPaneDivider.this && MotifSplitPaneDivider.this.getDragger() == null && MotifSplitPaneDivider.this.getSplitPane().isEnabled() && MotifSplitPaneDivider.this.isInThumb(e.getX(), e.getY())) {
                super.mousePressed(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (MotifSplitPaneDivider.this.getDragger() != null) {
                return;
            }
            if (!MotifSplitPaneDivider.this.isInThumb(e.getX(), e.getY())) {
                if (MotifSplitPaneDivider.this.getCursor() != defaultCursor) {
                    MotifSplitPaneDivider.this.setCursor(defaultCursor);
                }
                return;
            }
            super.mouseMoved(e);
        }
    }
}

