/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.transport;

import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.encoding.CDROutputObject;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.protocol.CorbaMessageMediatorImpl;
import com.sun.corba.se.impl.protocol.giopmsgheaders.Message;
import com.sun.corba.se.impl.protocol.giopmsgheaders.MessageBase;
import com.sun.corba.se.pept.broker.Broker;
import com.sun.corba.se.pept.encoding.InputObject;
import com.sun.corba.se.pept.encoding.OutputObject;
import com.sun.corba.se.pept.protocol.ClientRequestDispatcher;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.pept.transport.Connection;
import com.sun.corba.se.pept.transport.ContactInfo;
import com.sun.corba.se.pept.transport.ContactInfoList;
import com.sun.corba.se.pept.transport.OutboundConnectionCache;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.ior.iiop.IIOPProfile;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.protocol.CorbaMessageMediator;
import com.sun.corba.se.spi.protocol.RequestDispatcherRegistry;
import com.sun.corba.se.spi.transport.CorbaConnection;
import com.sun.corba.se.spi.transport.CorbaContactInfo;
import com.sun.corba.se.spi.transport.CorbaContactInfoList;
import java.nio.ByteBuffer;

public abstract class CorbaContactInfoBase
implements CorbaContactInfo {
    protected ORB orb;
    protected CorbaContactInfoList contactInfoList;
    protected IOR effectiveTargetIOR;
    protected short addressingDisposition;
    protected OutboundConnectionCache connectionCache;

    public Broker getBroker() {
        return this.orb;
    }

    public ContactInfoList getContactInfoList() {
        return this.contactInfoList;
    }

    public ClientRequestDispatcher getClientRequestDispatcher() {
        int scid = this.getEffectiveProfile().getObjectKeyTemplate().getSubcontractId();
        RequestDispatcherRegistry scr = this.orb.getRequestDispatcherRegistry();
        return scr.getClientRequestDispatcher(scid);
    }

    public void setConnectionCache(OutboundConnectionCache connectionCache) {
        this.connectionCache = connectionCache;
    }

    public OutboundConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    public MessageMediator createMessageMediator(Broker broker, ContactInfo contactInfo, Connection connection, String methodName, boolean isOneWay) {
        CorbaMessageMediatorImpl messageMediator = new CorbaMessageMediatorImpl((ORB)broker, contactInfo, connection, GIOPVersion.chooseRequestVersion((ORB)broker, this.effectiveTargetIOR), this.effectiveTargetIOR, ((CorbaConnection)connection).getNextRequestId(), this.getAddressingDisposition(), methodName, isOneWay);
        return messageMediator;
    }

    public MessageMediator createMessageMediator(Broker broker, Connection conn) {
        ORB orb = (ORB)broker;
        CorbaConnection connection = (CorbaConnection)conn;
        if (orb.transportDebugFlag) {
            if (connection.shouldReadGiopHeaderOnly()) {
                this.dprint(".createMessageMediator: waiting for message header on connection: " + connection);
            } else {
                this.dprint(".createMessageMediator: waiting for message on connection: " + connection);
            }
        }
        MessageBase msg = null;
        msg = connection.shouldReadGiopHeaderOnly() ? MessageBase.readGIOPHeader(orb, connection) : MessageBase.readGIOPMessage(orb, connection);
        ByteBuffer byteBuffer = msg.getByteBuffer();
        msg.setByteBuffer(null);
        CorbaMessageMediatorImpl messageMediator = new CorbaMessageMediatorImpl(orb, connection, msg, byteBuffer);
        return messageMediator;
    }

    public MessageMediator finishCreatingMessageMediator(Broker broker, Connection conn, MessageMediator messageMediator) {
        ORB orb = (ORB)broker;
        CorbaConnection connection = (CorbaConnection)conn;
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        if (orb.transportDebugFlag) {
            this.dprint(".finishCreatingMessageMediator: waiting for message body on connection: " + connection);
        }
        Message msg = corbaMessageMediator.getDispatchHeader();
        msg.setByteBuffer(corbaMessageMediator.getDispatchBuffer());
        msg = MessageBase.readGIOPBody(orb, connection, msg);
        ByteBuffer byteBuffer = msg.getByteBuffer();
        msg.setByteBuffer(null);
        corbaMessageMediator.setDispatchHeader(msg);
        corbaMessageMediator.setDispatchBuffer(byteBuffer);
        return corbaMessageMediator;
    }

    public OutputObject createOutputObject(MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        CDROutputObject outputObject = new CDROutputObject(this.orb, messageMediator, corbaMessageMediator.getRequestHeader(), corbaMessageMediator.getStreamFormatVersion());
        messageMediator.setOutputObject(outputObject);
        return outputObject;
    }

    public InputObject createInputObject(Broker broker, MessageMediator messageMediator) {
        CorbaMessageMediator corbaMessageMediator = (CorbaMessageMediator)messageMediator;
        return new CDRInputObject((ORB)broker, (CorbaConnection)messageMediator.getConnection(), corbaMessageMediator.getDispatchBuffer(), corbaMessageMediator.getDispatchHeader());
    }

    public short getAddressingDisposition() {
        return this.addressingDisposition;
    }

    public void setAddressingDisposition(short addressingDisposition) {
        this.addressingDisposition = addressingDisposition;
    }

    public IOR getTargetIOR() {
        return this.contactInfoList.getTargetIOR();
    }

    public IOR getEffectiveTargetIOR() {
        return this.effectiveTargetIOR;
    }

    public IIOPProfile getEffectiveProfile() {
        return this.effectiveTargetIOR.getProfile();
    }

    public String toString() {
        return "CorbaContactInfoBase[]";
    }

    protected void dprint(String msg) {
        ORBUtility.dprint("CorbaContactInfoBase", msg);
    }
}

