/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.ByteToCharConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;
import sun.nio.cs.ext.EUC_TW;

public class ByteToCharEUC_TW
extends ByteToCharConverter {
    private final byte G0 = 0;
    private final byte G1 = 1;
    private final byte G2 = (byte)2;
    private final byte G3 = (byte)3;
    private final byte G4 = (byte)4;
    private final byte MSB = (byte)-128;
    private final byte SS2 = (byte)-114;
    private final byte P2 = (byte)-94;
    private final byte P3 = (byte)-93;
    protected final char REPLACE_CHAR = (char)65533;
    private byte firstByte = 0;
    private byte state = 0;
    public static String unicodeCNS2;
    public static String unicodeCNS3;
    private static String unicodeCNS4;
    private static String unicodeCNS5;
    private static String unicodeCNS6;
    private static String unicodeCNS7;
    private static String unicodeCNS15;
    private int cnsPlane = 0;
    private static final EUC_TW nioCoder;
    public static String unicodeCNS1;
    static String[] cnsChars;

    public int flush(char[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.state != 0) {
            this.state = 0;
            this.firstByte = 0;
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.reset();
        return 0;
    }

    public void reset() {
        this.state = 0;
        this.firstByte = 0;
        this.charOff = 0;
        this.byteOff = 0;
    }

    public int convert(byte[] input, int inOff, int inEnd, char[] output, int outOff, int outEnd) throws UnknownCharacterException, MalformedInputException, ConversionBufferFullException {
        int inputSize = 0;
        int outputChar = 0;
        this.byteOff = inOff;
        this.charOff = outOff;
        this.cnsPlane = 3;
        while (this.byteOff < inEnd) {
            if (this.charOff >= outEnd) {
                throw new ConversionBufferFullException();
            }
            switch (this.state) {
                case 0: {
                    if ((input[this.byteOff] & 0xFFFFFF80) == 0) {
                        outputChar = (char)input[this.byteOff];
                        break;
                    }
                    if (input[this.byteOff] == -114) {
                        this.state = (byte)2;
                        break;
                    }
                    this.firstByte = input[this.byteOff];
                    this.state = 1;
                    break;
                }
                case 1: {
                    inputSize = 2;
                    if ((input[this.byteOff] & 0xFFFFFF80) == 0) {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                    this.cnsPlane = 1;
                    outputChar = this.convToUnicode(this.firstByte, input[this.byteOff], unicodeCNS1);
                    this.firstByte = 0;
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.cnsPlane = input[this.byteOff] & 0xF;
                    int n = this.cnsPlane = this.cnsPlane == 15 ? 8 : this.cnsPlane;
                    if (this.cnsPlane < 15) {
                        this.state = (byte)3;
                        break;
                    }
                    this.badInputLength = 2;
                    throw new MalformedInputException();
                }
                case 3: {
                    if ((input[this.byteOff] & 0xFFFFFF80) != 0) {
                        this.firstByte = input[this.byteOff];
                        this.state = (byte)4;
                        break;
                    }
                    this.state = 0;
                    this.badInputLength = 2;
                    throw new MalformedInputException();
                }
                case 4: {
                    if ((input[this.byteOff] & 0xFFFFFF80) == 0) {
                        this.badInputLength = 3;
                        throw new MalformedInputException();
                    }
                    outputChar = this.convToUnicode(this.firstByte, input[this.byteOff], cnsChars[this.cnsPlane - 2]);
                    this.firstByte = 0;
                    this.state = 0;
                }
            }
            ++this.byteOff;
            if (outputChar == 0) continue;
            if (outputChar == 65533) {
                if (this.subMode) {
                    outputChar = this.subChars[0];
                } else {
                    this.badInputLength = inputSize;
                    throw new UnknownCharacterException();
                }
            }
            output[this.charOff++] = outputChar;
            outputChar = 0;
        }
        return this.charOff - outOff;
    }

    public String getCharacterEncoding() {
        return "EUC_TW";
    }

    protected char convToUnicode(byte byte1, byte byte2, String table) {
        if ((byte1 & 0xFF) < 161 || (byte2 & 0xFF) < 161 || (byte1 & 0xFF) > 254 || (byte2 & 0xFF) > 254) {
            return '\ufffd';
        }
        int index = ((byte1 & 0xFF) - 161) * 94 + (byte2 & 0xFF) - 161;
        if (index < 0 || index >= table.length()) {
            return '\ufffd';
        }
        if (this.cnsPlane >= 3) {
            index = index * 2 + 1;
        }
        return table.charAt(index);
    }

    static {
        nioCoder = new EUC_TW();
        unicodeCNS1 = nioCoder.getUnicodeCNS1();
        String[] stringArray = new String[7];
        stringArray[0] = unicodeCNS2 = nioCoder.getUnicodeCNS2();
        stringArray[1] = unicodeCNS3 = nioCoder.getUnicodeCNS3();
        stringArray[2] = unicodeCNS4 = nioCoder.getUnicodeCNS4();
        stringArray[3] = unicodeCNS5 = nioCoder.getUnicodeCNS5();
        stringArray[4] = unicodeCNS6 = nioCoder.getUnicodeCNS6();
        stringArray[5] = unicodeCNS7 = nioCoder.getUnicodeCNS7();
        stringArray[6] = unicodeCNS15 = nioCoder.getUnicodeCNS15();
        cnsChars = stringArray;
    }
}

