/*
 * Decompiled with CFR 0.152.
 */
package build.tools.javazic;

import build.tools.javazic.BackEnd;
import build.tools.javazic.Mappings;
import build.tools.javazic.Timezone;
import build.tools.javazic.Zone;
import build.tools.javazic.Zoneinfo;
import java.util.ArrayList;
import java.util.List;

public class Main {
    private static boolean verbose = false;
    static boolean outputDoc = false;
    private List<String> ziFiles = new ArrayList<String>();
    private static String zoneNamesFile = null;
    private static String versionName = "unknown";
    private static String outputDir = "zoneinfo";
    private static String mapFile = null;

    void processArgs(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string.startsWith("-h")) {
                this.usage();
                System.exit(0);
                continue;
            }
            if (string.equals("-d")) {
                outputDir = stringArray[++i];
                continue;
            }
            if (string.equals("-v")) {
                verbose = true;
                continue;
            }
            if (string.equals("-V")) {
                versionName = stringArray[++i];
                continue;
            }
            if (string.equals("-doc")) {
                outputDoc = true;
                continue;
            }
            if (string.equals("-map")) {
                outputDoc = true;
                mapFile = stringArray[++i];
                continue;
            }
            if (string.equals("-f")) {
                zoneNamesFile = stringArray[++i];
                continue;
            }
            if (string.equals("-S")) {
                try {
                    Zoneinfo.setYear(Integer.parseInt(stringArray[++i]));
                }
                catch (Exception exception) {
                    Main.error("invalid year: " + stringArray[i]);
                    this.usage();
                    System.exit(1);
                }
                continue;
            }
            boolean bl = string.equals("-s");
            if (bl || string.equals("-e")) {
                try {
                    int n = Integer.parseInt(stringArray[++i]);
                    if (bl) {
                        Zoneinfo.setStartYear(n);
                        continue;
                    }
                    Zoneinfo.setEndYear(n);
                }
                catch (Exception exception) {
                    Main.error("invalid year: " + stringArray[i]);
                    this.usage();
                    System.exit(1);
                }
                continue;
            }
            while (i < stringArray.length) {
                this.ziFiles.add(stringArray[i++]);
            }
        }
    }

    int compile() {
        int n = this.ziFiles.size();
        int n2 = 0;
        Mappings mappings = new Mappings();
        BackEnd backEnd = BackEnd.getBackEnd();
        for (int i = 0; i < n; ++i) {
            Zoneinfo zoneinfo = Zoneinfo.parse(this.ziFiles.get(i));
            for (String string : zoneinfo.getZones().keySet()) {
                Main.info(string);
                Timezone timezone = zoneinfo.phase2(string);
                n2 |= backEnd.processZoneinfo(timezone);
            }
            mappings.add(zoneinfo);
        }
        Zone.addMET();
        mappings.resolve();
        return n2 |= backEnd.generateSrc(mappings);
    }

    public static void main(String[] stringArray) {
        Main main = new Main();
        main.processArgs(stringArray);
        if (zoneNamesFile != null) {
            Zone.readZoneNames(zoneNamesFile);
        }
        int n = main.compile();
        System.exit(n);
    }

    void usage() {
        System.err.println("Usage: javazic [options] file...\n         -f namefile  file containing zone names\n                      to be generated (ie, generating subset)\n         -d dir       output directory\n         -v           verbose\n         -V datavers  specifies the tzdata version string\n                      (eg, \"tzdata2000g\")         -S year      output only SimleTimeZone data of that year\n         -s year      start year (default: 1900)\n         -e year      end year (default: 2037)\n         -doc         generates HTML documents\n         -map mapfile generates HTML documents with map information\n         file...      zoneinfo source file(s)");
    }

    static String getOutputDir() {
        return outputDir;
    }

    static String getMapFile() {
        return mapFile;
    }

    static String getVersionName() {
        return versionName;
    }

    static void panic(String string) {
        Main.printMessage("fatal error", string);
        System.exit(1);
    }

    static void error(String string) {
        Main.printMessage("error", string);
    }

    static void warning(String string) {
        Main.printMessage("warning", string);
    }

    static void info(String string) {
        if (verbose) {
            Main.printMessage(null, string);
        }
    }

    private static void printMessage(String string, String string2) {
        string = string != null ? string + ": " : "";
        System.err.println("javazic: " + string + string2);
    }
}

