/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.TabularData;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultMutableTreeNode;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.TableSorter;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XNodeInfo;
import sun.tools.jconsole.inspector.XTextFieldEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMBeanNotifications
extends JTable
implements NotificationListener {
    private static final String[] columnNames = new String[]{Resources.getText("TimeStamp", new Object[0]), Resources.getText("Type", new Object[0]), Resources.getText("UserData", new Object[0]), Resources.getText("SeqNum", new Object[0]), Resources.getText("Message", new Object[0]), Resources.getText("Event", new Object[0]), Resources.getText("Source", new Object[0])};
    private HashMap<ObjectName, XMBeanNotificationsListener> listeners = new HashMap();
    private boolean subscribed;
    private XMBeanNotificationsListener currentListener;
    public static final String NOTIFICATION_RECEIVED_EVENT = "jconsole.xnotification.received";
    private List<NotificationListener> notificationListenersList;
    private boolean enabled;
    private Font normalFont;
    private Font boldFont;
    private int rowMinHeight = -1;
    private TableCellEditor userDataEditor = new UserDataCellEditor();
    private NotifMouseListener mouseListener = new NotifMouseListener();
    private SimpleDateFormat timeFormater = new SimpleDateFormat("HH:mm:ss:SSS");
    private static TableCellEditor editor = new Utils.ReadOnlyTableCellEditor(new JTextField());

    public XMBeanNotifications() {
        super(new TableSorter(columnNames, 0));
        this.setColumnSelectionAllowed(false);
        this.setRowSelectionAllowed(false);
        this.getTableHeader().setReorderingAllowed(false);
        ArrayList l = new ArrayList(1);
        this.notificationListenersList = Collections.synchronizedList(l);
        this.addMouseListener(this.mouseListener);
        TableColumnModel colModel = this.getColumnModel();
        colModel.getColumn(0).setPreferredWidth(45);
        colModel.getColumn(1).setPreferredWidth(50);
        colModel.getColumn(2).setPreferredWidth(50);
        colModel.getColumn(3).setPreferredWidth(40);
        colModel.getColumn(4).setPreferredWidth(50);
        colModel.getColumn(5).setPreferredWidth(50);
        this.setColumnEditors();
        this.addKeyListener(new Utils.CopyKeyAdapter());
    }

    public void cancelCellEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.cancelCellEditing();
        }
    }

    public void stopCellEditing() {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        UserDataCell cell = this.getUserDataCell(row, col);
        if (cell != null) {
            return cell.isMaximized();
        }
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
    }

    @Override
    public synchronized Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        if (row >= this.getRowCount()) {
            return null;
        }
        Component comp = super.prepareRenderer(renderer, row, column);
        if (this.normalFont == null) {
            this.normalFont = comp.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }
        UserDataCell cell = this.getUserDataCell(row, 2);
        if (column == 2 && cell != null) {
            comp.setFont(this.boldFont);
            int size = cell.getHeight();
            if (size > 0 && this.getRowHeight(row) != size) {
                this.setRowHeight(row, size);
            }
        } else {
            comp.setFont(this.normalFont);
        }
        return comp;
    }

    @Override
    public synchronized TableCellRenderer getCellRenderer(int row, int column) {
        if (row >= this.getRowCount()) {
            return null;
        }
        String toolTip = null;
        UserDataCell cell = this.getUserDataCell(row, column);
        DefaultTableCellRenderer renderer = cell != null && cell.isInited() ? (DefaultTableCellRenderer)cell.getRenderer() : (DefaultTableCellRenderer)super.getCellRenderer(row, column);
        if (cell != null) {
            toolTip = Resources.getText("Double click to expand/collapse", new Object[0]) + ". " + cell.toString();
        } else {
            Object val = ((DefaultTableModel)this.getModel()).getValueAt(row, column);
            if (val != null) {
                toolTip = val.toString();
            }
        }
        renderer.setToolTipText(toolTip);
        return renderer;
    }

    private UserDataCell getUserDataCell(int row, int column) {
        Object obj = ((DefaultTableModel)this.getModel()).getValueAt(row, column);
        if (obj instanceof UserDataCell) {
            return (UserDataCell)obj;
        }
        return null;
    }

    synchronized void dispose() {
        this.listeners.clear();
    }

    public long getReceivedNotifications(XMBean mbean) {
        XMBeanNotificationsListener listener = this.listeners.get(mbean.getObjectName());
        if (listener == null) {
            return 0L;
        }
        return listener.getReceivedNotifications();
    }

    public synchronized boolean clearCurrentNotifications() {
        this.emptyTable();
        if (this.currentListener != null) {
            this.currentListener.clear();
            return true;
        }
        return false;
    }

    public synchronized boolean unregisterListener(DefaultMutableTreeNode node) {
        XMBean mbean = (XMBean)((XNodeInfo)node.getUserObject()).getData();
        return this.unregister(mbean.getObjectName());
    }

    public synchronized void registerListener(DefaultMutableTreeNode node) throws InstanceNotFoundException, IOException {
        XMBeanNotificationsListener listener;
        XMBean mbean = (XMBean)((XNodeInfo)node.getUserObject()).getData();
        if (!this.subscribed) {
            try {
                mbean.getMBeanServerConnection().addNotificationListener(new ObjectName("JMImplementation:type=MBeanServerDelegate"), this, null, null);
                this.subscribed = true;
            }
            catch (Exception e) {
                System.out.println("Error adding listener for delegate :" + e.getMessage());
            }
        }
        if ((listener = this.listeners.get(mbean.getObjectName())) == null) {
            listener = new XMBeanNotificationsListener(this, mbean, node, columnNames);
            this.listeners.put(mbean.getObjectName(), listener);
        } else if (!listener.isRegistered()) {
            this.emptyTable();
            listener.register(node);
        }
        this.enabled = true;
        this.currentListener = listener;
    }

    @Override
    public synchronized void handleNotification(Notification notif, Object handback) {
        try {
            if (notif instanceof MBeanServerNotification) {
                ObjectName mbean = ((MBeanServerNotification)notif).getMBeanName();
                if (notif.getType().indexOf("JMX.mbean.unregistered") >= 0) {
                    this.unregister(mbean);
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error unregistering notification:" + e.getMessage());
        }
    }

    public synchronized void disableNotifications() {
        this.emptyTable();
        this.currentListener = null;
        this.enabled = false;
    }

    private synchronized boolean unregister(ObjectName mbean) {
        XMBeanNotificationsListener listener = this.listeners.get(mbean);
        if (listener != null && listener.isRegistered()) {
            listener.unregister();
            return true;
        }
        return false;
    }

    public void addNotificationsListener(NotificationListener nl) {
        this.notificationListenersList.add(nl);
    }

    public void removeNotificationsListener(NotificationListener nl) {
        this.notificationListenersList.remove(nl);
    }

    void fireNotificationReceived(XMBeanNotificationsListener listener, XMBean mbean, DefaultMutableTreeNode node, Object[] rowData, long received) {
        if (this.enabled) {
            DefaultTableModel tableModel = (DefaultTableModel)this.getModel();
            if (listener == this.currentListener) {
                tableModel.insertRow(0, rowData);
                this.repaint();
            }
        }
        Notification notif = new Notification(NOTIFICATION_RECEIVED_EVENT, this, 0L);
        notif.setUserData(new Long(received));
        for (NotificationListener nl : this.notificationListenersList) {
            nl.handleNotification(notif, node);
        }
    }

    private void updateModel(List<Object[]> data) {
        this.emptyTable();
        DefaultTableModel tableModel = (DefaultTableModel)this.getModel();
        for (Object[] rowData : data) {
            tableModel.addRow(rowData);
        }
    }

    public synchronized boolean isListenerRegistered(XMBean mbean) {
        XMBeanNotificationsListener listener = this.listeners.get(mbean.getObjectName());
        if (listener == null) {
            return false;
        }
        return listener.isRegistered();
    }

    public synchronized void loadNotifications(XMBean mbean) {
        XMBeanNotificationsListener listener = this.listeners.get(mbean.getObjectName());
        this.emptyTable();
        if (listener != null) {
            this.enabled = true;
            List<Object[]> data = listener.getData();
            this.updateModel(data);
            this.currentListener = listener;
            this.validate();
            this.repaint();
        } else {
            this.enabled = false;
        }
    }

    private void setColumnEditors() {
        TableColumnModel tcm = this.getColumnModel();
        for (int i = 0; i < columnNames.length; ++i) {
            TableColumn tc = tcm.getColumn(i);
            if (i == 2) {
                tc.setCellEditor(this.userDataEditor);
                continue;
            }
            tc.setCellEditor(editor);
        }
    }

    public boolean isTableEditable() {
        return true;
    }

    public synchronized void emptyTable() {
        DefaultTableModel model = (DefaultTableModel)this.getModel();
        while (model.getRowCount() > 0) {
            model.removeRow(0);
        }
        this.validate();
    }

    synchronized void updateUserDataCell(int row, int col) {
        Object obj = this.getModel().getValueAt(row, 2);
        if (obj instanceof UserDataCell) {
            UserDataCell cell = (UserDataCell)obj;
            if (!cell.isInited()) {
                if (this.rowMinHeight == -1) {
                    this.rowMinHeight = this.getRowHeight(row);
                }
                cell.init(super.getCellRenderer(row, col), this.rowMinHeight);
            }
            cell.switchState();
            this.setRowHeight(row, cell.getHeight());
            if (!cell.isMaximized()) {
                this.cancelCellEditing();
                this.editCellAt(row, 2);
            }
            this.invalidate();
            this.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class XMBeanNotificationsListener
    implements NotificationListener {
        private String[] columnNames;
        private XMBean xmbean;
        private DefaultMutableTreeNode node;
        private long received;
        private XMBeanNotifications notifications;
        private boolean unregistered;
        private ArrayList<Object[]> data = new ArrayList();

        public XMBeanNotificationsListener(XMBeanNotifications notifications, XMBean xmbean, DefaultMutableTreeNode node, String[] columnNames) {
            this.notifications = notifications;
            this.xmbean = xmbean;
            this.node = node;
            this.columnNames = columnNames;
            this.register(node);
        }

        public synchronized List<Object[]> getData() {
            return this.data;
        }

        public synchronized void clear() {
            this.data.clear();
            this.received = 0L;
        }

        public boolean isRegistered() {
            return !this.unregistered;
        }

        public synchronized void unregister() {
            try {
                this.xmbean.getMBeanServerConnection().removeNotificationListener(this.xmbean.getObjectName(), this, null, null);
            }
            catch (Exception e) {
                System.out.println("Error removing listener :" + e.getMessage());
            }
            this.unregistered = true;
        }

        public long getReceivedNotifications() {
            return this.received;
        }

        public synchronized void register(DefaultMutableTreeNode node) {
            this.clear();
            this.node = node;
            try {
                this.xmbean.getMBeanServerConnection().addNotificationListener(this.xmbean.getObjectName(), this, null, null);
                this.unregistered = false;
            }
            catch (Exception e) {
                System.out.println("Error adding listener :" + e.getMessage());
            }
        }

        @Override
        public synchronized void handleNotification(Notification e, Object handback) {
            try {
                if (this.unregistered) {
                    return;
                }
                Date receivedDate = new Date(e.getTimeStamp());
                String time = XMBeanNotifications.this.timeFormater.format(receivedDate);
                Object userData = e.getUserData();
                Component comp = null;
                UserDataCell cell = null;
                comp = XDataViewer.createNotificationViewer(userData);
                if (comp != null) {
                    XDataViewer.registerForMouseEvent(comp, XMBeanNotifications.this.mouseListener);
                    cell = new UserDataCell(userData, comp);
                }
                Object[] rowData = new Object[]{time, e.getType(), cell == null ? userData : cell, new Long(e.getSequenceNumber()), e.getMessage(), e, e.getSource()};
                ++this.received;
                this.data.add(0, rowData);
                this.notifications.fireNotificationReceived(this, this.xmbean, this.node, rowData, this.received);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.out.println("Error when handling notification :" + ex.toString());
            }
        }
    }

    class UserDataCellEditor
    extends XTextFieldEditor {
        UserDataCellEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Object val = value;
            if (column == 2) {
                Object obj = XMBeanNotifications.this.getModel().getValueAt(row, column);
                if (obj instanceof UserDataCell) {
                    UserDataCell cell = (UserDataCell)obj;
                    if (cell.getRenderer() instanceof UserDataCellRenderer) {
                        UserDataCellRenderer zr = (UserDataCellRenderer)cell.getRenderer();
                        return zr.getComponent();
                    }
                } else {
                    Component comp = super.getTableCellEditorComponent(table, val, isSelected, row, column);
                    this.textField.setEditable(false);
                    return comp;
                }
            }
            return super.getTableCellEditorComponent(table, val, isSelected, row, column);
        }

        public boolean stopCellEditing() {
            UserDataCell cell;
            Object obj;
            int editingRow = XMBeanNotifications.this.getEditingRow();
            int editingColumn = XMBeanNotifications.this.getEditingColumn();
            if (editingColumn == 2 && (obj = XMBeanNotifications.this.getModel().getValueAt(editingRow, editingColumn)) instanceof UserDataCell && (cell = (UserDataCell)obj).isMaximized()) {
                this.cancelCellEditing();
                return true;
            }
            return super.stopCellEditing();
        }
    }

    class NotifMouseListener
    extends MouseAdapter {
        NotifMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 1 && e.getClickCount() >= 2) {
                int row = XMBeanNotifications.this.getSelectedRow();
                int col = XMBeanNotifications.this.getSelectedColumn();
                if (col != 2) {
                    return;
                }
                if (col == -1 || row == -1) {
                    return;
                }
                XMBeanNotifications.this.updateUserDataCell(row, col);
            }
        }
    }

    class UserDataCell {
        TableCellRenderer minRenderer;
        UserDataCellRenderer maxRenderer;
        int minHeight;
        boolean minimized = true;
        boolean init = false;
        Object userData;

        UserDataCell(Object userData, Component max) {
            this.userData = userData;
            this.maxRenderer = new UserDataCellRenderer(max);
        }

        public String toString() {
            if (this.userData == null) {
                return null;
            }
            if (this.userData.getClass().isArray()) {
                String name = Utils.getArrayClassName(this.userData.getClass().getName());
                int length = Array.getLength(this.userData);
                return name + "[" + length + "]";
            }
            if (this.userData instanceof CompositeData || this.userData instanceof TabularData) {
                return this.userData.getClass().getName();
            }
            return this.userData.toString();
        }

        boolean isInited() {
            return this.init;
        }

        void init(TableCellRenderer minRenderer, int minHeight) {
            this.minRenderer = minRenderer;
            this.minHeight = minHeight;
            this.init = true;
        }

        void switchState() {
            this.minimized = !this.minimized;
        }

        boolean isMaximized() {
            return !this.minimized;
        }

        void minimize() {
            this.minimized = true;
        }

        void maximize() {
            this.minimized = false;
        }

        int getHeight() {
            if (this.minimized) {
                return this.minHeight;
            }
            return (int)this.maxRenderer.getComponent().getPreferredSize().getHeight();
        }

        TableCellRenderer getRenderer() {
            if (this.minimized) {
                return this.minRenderer;
            }
            return this.maxRenderer;
        }
    }

    class UserDataCellRenderer
    extends DefaultTableCellRenderer {
        Component comp;

        UserDataCellRenderer(Component comp) {
            this.comp = comp;
            Dimension d = comp.getPreferredSize();
            if (d.getHeight() > 200.0) {
                comp.setPreferredSize(new Dimension((int)d.getWidth(), 200));
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this.comp;
        }

        public Component getComponent() {
            return this.comp;
        }
    }
}

