/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.XArrayDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XOpenTypeViewer;
import sun.tools.jconsole.inspector.XPlottingViewer;

public class XDataViewer {
    public static final int OPEN = 1;
    public static final int ARRAY = 2;
    public static final int NUMERIC = 3;
    public static final int NOT_SUPPORTED = 4;
    private MBeansTab tab;

    public XDataViewer(MBeansTab tab) {
        this.tab = tab;
    }

    public static void registerForMouseEvent(Component comp, MouseListener mouseListener) {
        if (comp instanceof JScrollPane) {
            JScrollPane pane = (JScrollPane)comp;
            comp = pane.getViewport().getView();
        }
        if (comp instanceof Container) {
            Container container = (Container)comp;
            Component[] components = container.getComponents();
            for (int i = 0; i < components.length; ++i) {
                XDataViewer.registerForMouseEvent(components[i], mouseListener);
            }
        }
        if (comp != null && !(comp instanceof XOpenTypeViewer.XOpenTypeData) && !(comp instanceof JButton)) {
            comp.addMouseListener(mouseListener);
        }
    }

    public static void dispose(MBeansTab tab) {
        XPlottingViewer.dispose(tab);
    }

    public static boolean isViewableValue(Object value) {
        boolean ret = false;
        ret = XArrayDataViewer.isViewableValue(value);
        if (ret) {
            return ret;
        }
        ret = XOpenTypeViewer.isViewableValue(value);
        if (ret) {
            return ret;
        }
        ret = XPlottingViewer.isViewableValue(value);
        if (ret) {
            return ret;
        }
        return ret;
    }

    public static int getViewerType(Object data) {
        if (XArrayDataViewer.isViewableValue(data)) {
            return 2;
        }
        if (XOpenTypeViewer.isViewableValue(data)) {
            return 1;
        }
        if (XPlottingViewer.isViewableValue(data)) {
            return 3;
        }
        return 4;
    }

    public static String getActionLabel(int type) {
        if (type == 2 || type == 1) {
            return Resources.getText("visualize", new Object[0]);
        }
        if (type == 3) {
            return Resources.getText("plot", new Object[0]);
        }
        return Resources.getText("expand", new Object[0]);
    }

    public Component createOperationViewer(Object value, XMBean mbean) {
        if (value instanceof Number) {
            return null;
        }
        return this.createAttributeViewer(value, mbean, null, null);
    }

    public static Component createNotificationViewer(Object value) {
        Component comp = null;
        if (value instanceof Number) {
            return null;
        }
        comp = XArrayDataViewer.loadArray(value);
        if (comp != null) {
            return comp;
        }
        comp = XOpenTypeViewer.loadOpenType(value);
        if (comp != null) {
            return comp;
        }
        return comp;
    }

    public Component createAttributeViewer(Object value, XMBean mbean, String attributeName, JTable table) {
        Component comp = null;
        comp = XArrayDataViewer.loadArray(value);
        if (comp != null) {
            return comp;
        }
        comp = XOpenTypeViewer.loadOpenType(value);
        if (comp != null) {
            return comp;
        }
        comp = XPlottingViewer.loadPlotting(mbean, attributeName, value, table, this.tab);
        if (comp != null) {
            return comp;
        }
        return comp;
    }
}

