/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.CipherCore;
import com.sun.crypto.provider.RC2Crypt;
import com.sun.crypto.provider.SunJCE;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2Cipher
extends CipherSpi {
    private final CipherCore core;
    private final RC2Crypt embeddedCipher;

    public RC2Cipher() {
        SunJCE.ensureIntegrity(this.getClass());
        this.embeddedCipher = new RC2Crypt();
        this.core = new CipherCore(this.embeddedCipher, 8);
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.core.setMode(mode);
    }

    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        this.core.setPadding(paddingScheme);
    }

    protected int engineGetBlockSize() {
        return 8;
    }

    protected int engineGetOutputSize(int inputLen) {
        return this.core.getOutputSize(inputLen);
    }

    protected byte[] engineGetIV() {
        return this.core.getIV();
    }

    protected AlgorithmParameters engineGetParameters() {
        return this.core.getParameters("RC2");
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.embeddedCipher.initEffectiveKeyBits(0);
        this.core.init(opmode, key, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null && params instanceof RC2ParameterSpec) {
            this.embeddedCipher.initEffectiveKeyBits(((RC2ParameterSpec)params).getEffectiveKeyBits());
        } else {
            this.embeddedCipher.initEffectiveKeyBits(0);
        }
        this.core.init(opmode, key, params, random);
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null && params.getAlgorithm().equals("RC2")) {
            try {
                RC2ParameterSpec rc2Params = params.getParameterSpec(RC2ParameterSpec.class);
                this.engineInit(opmode, key, rc2Params, random);
            }
            catch (InvalidParameterSpecException ipse) {
                throw new InvalidAlgorithmParameterException("Wrong parameter type: RC2 expected");
            }
        } else {
            this.embeddedCipher.initEffectiveKeyBits(0);
            this.core.init(opmode, key, params, random);
        }
    }

    protected byte[] engineUpdate(byte[] in, int inOfs, int inLen) {
        return this.core.update(in, inOfs, inLen);
    }

    protected int engineUpdate(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws ShortBufferException {
        return this.core.update(in, inOfs, inLen, out, outOfs);
    }

    protected byte[] engineDoFinal(byte[] in, int inOfs, int inLen) throws IllegalBlockSizeException, BadPaddingException {
        return this.core.doFinal(in, inOfs, inLen);
    }

    protected int engineDoFinal(byte[] in, int inOfs, int inLen, byte[] out, int outOfs) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        return this.core.doFinal(in, inOfs, inLen, out, outOfs);
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        byte[] keyBytes = CipherCore.getKeyBytes(key);
        RC2Crypt.checkKey(key.getAlgorithm(), keyBytes.length);
        return keyBytes.length << 3;
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.core.wrap(key);
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.core.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }
}

