/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLException;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.CipherBox;
import sun.security.ssl.Debug;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.InputRecord;
import sun.security.ssl.MAC;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;

class OutputRecord
extends ByteArrayOutputStream
implements Record {
    private HandshakeHash handshakeHash;
    private int lastHashed;
    private boolean firstMessage = true;
    private final byte contentType;
    ProtocolVersion protocolVersion = ProtocolVersion.DEFAULT;
    private ProtocolVersion helloVersion = ProtocolVersion.DEFAULT_HELLO;
    static final Debug debug = Debug.getInstance("ssl");
    private static int[] V3toV2CipherMap1 = new int[]{-1, -1, -1, 2, 1, -1, 4, 5, -1, 6, 7};
    private static int[] V3toV2CipherMap3 = new int[]{-1, -1, -1, 128, 128, -1, 128, 128, -1, 64, 192};

    OutputRecord(byte type, int size) {
        super(size);
        this.count = 5;
        this.contentType = type;
        this.lastHashed = this.count;
    }

    OutputRecord(byte type) {
        this(type, OutputRecord.recordSize(type));
    }

    private static int recordSize(byte type) {
        if (type == 20 || type == 21) {
            return 283;
        }
        return 16665;
    }

    synchronized void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    synchronized void setHelloVersion(ProtocolVersion helloVersion) {
        this.helloVersion = helloVersion;
    }

    public synchronized void reset() {
        super.reset();
        this.lastHashed = this.count = 5;
    }

    void setHandshakeHash(HandshakeHash handshakeHash) {
        assert (this.contentType == 22);
        this.handshakeHash = handshakeHash;
    }

    void doHashes() {
        int len = this.count - this.lastHashed;
        if (len > 0) {
            this.hashInternal(this.buf, this.lastHashed, len);
            this.lastHashed = this.count;
        }
    }

    private void hashInternal(byte[] buf, int offset, int len) {
        if (debug != null && Debug.isOn("data")) {
            try {
                HexDumpEncoder hd = new HexDumpEncoder();
                System.out.println("[write] MD5 and SHA1 hashes:  len = " + len);
                hd.encodeBuffer((InputStream)new ByteArrayInputStream(buf, this.lastHashed, len), (OutputStream)System.out);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.handshakeHash.update(buf, this.lastHashed, len);
        this.lastHashed = this.count;
    }

    boolean isEmpty() {
        return this.count == 5;
    }

    boolean isAlert(byte description) {
        if (this.count > 6 && this.contentType == 21) {
            return this.buf[6] == description;
        }
        return false;
    }

    void addMAC(MAC signer) throws IOException {
        if (this.contentType == 22) {
            this.doHashes();
        }
        if (signer.MAClen() != 0) {
            byte[] hash = signer.compute(this.contentType, this.buf, 5, this.count - 5);
            this.write(hash);
        }
    }

    void encrypt(CipherBox box) {
        int len = this.count - 5;
        this.count = 5 + box.encrypt(this.buf, 5, len);
    }

    final int availableDataBytes() {
        int dataSize = this.count - 5;
        return 16384 - dataSize;
    }

    final byte contentType() {
        return this.contentType;
    }

    void write(OutputStream s) throws IOException {
        if (this.count == 5) {
            return;
        }
        int length = this.count - 5;
        if (length < 0) {
            throw new SSLException("output record size too small: " + length);
        }
        if (debug != null && (Debug.isOn("record") || Debug.isOn("handshake")) && (debug != null && Debug.isOn("record") || this.contentType() == 20)) {
            System.out.println(Thread.currentThread().getName() + ", WRITE: " + this.protocolVersion + " " + InputRecord.contentName(this.contentType()) + ", length = " + length);
        }
        if (this.firstMessage && this.useV2Hello()) {
            byte[] v3Msg = new byte[length - 4];
            System.arraycopy(this.buf, 9, v3Msg, 0, v3Msg.length);
            this.V3toV2ClientHello(v3Msg);
            this.handshakeHash.reset();
            this.lastHashed = 2;
            this.doHashes();
            if (debug != null && Debug.isOn("record")) {
                System.out.println(Thread.currentThread().getName() + ", WRITE: SSLv2 client hello message" + ", length = " + (this.count - 2));
            }
        } else {
            this.buf[0] = this.contentType;
            this.buf[1] = this.protocolVersion.major;
            this.buf[2] = this.protocolVersion.minor;
            this.buf[3] = (byte)(length >> 8);
            this.buf[4] = (byte)length;
        }
        this.firstMessage = false;
        this.writeBuffer(s, this.buf, 0, this.count);
        this.reset();
    }

    void writeBuffer(OutputStream s, byte[] buf, int off, int len) throws IOException {
        s.write(buf, off, len);
        s.flush();
        if (debug != null && Debug.isOn("packet")) {
            try {
                HexDumpEncoder hd = new HexDumpEncoder();
                ByteBuffer bb = ByteBuffer.wrap(buf, off, len);
                System.out.println("[Raw write]: length = " + bb.remaining());
                hd.encodeBuffer(bb, (OutputStream)System.out);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    private boolean useV2Hello() {
        return this.firstMessage && this.helloVersion == ProtocolVersion.SSL20Hello && this.contentType == 22 && this.buf[5] == 1 && this.buf[43] == 0;
    }

    private void V3toV2ClientHello(byte[] v3Msg) throws SSLException {
        int v3SessionIdLenOffset = 34;
        byte v3SessionIdLen = v3Msg[v3SessionIdLenOffset];
        int v3CipherSpecLenOffset = v3SessionIdLenOffset + 1 + v3SessionIdLen;
        int v3CipherSpecLen = ((v3Msg[v3CipherSpecLenOffset] & 0xFF) << 8) + (v3Msg[v3CipherSpecLenOffset + 1] & 0xFF);
        int cipherSpecs = v3CipherSpecLen / 2;
        int v3CipherSpecOffset = v3CipherSpecLenOffset + 2;
        int v2CipherSpecLen = 0;
        this.count = 11;
        for (int i = 0; i < cipherSpecs; ++i) {
            byte byte1 = v3Msg[v3CipherSpecOffset++];
            byte byte2 = v3Msg[v3CipherSpecOffset++];
            v2CipherSpecLen += this.V3toV2CipherSuite(byte1, byte2);
        }
        this.buf[2] = 1;
        this.buf[3] = v3Msg[0];
        this.buf[4] = v3Msg[1];
        this.buf[5] = (byte)(v2CipherSpecLen >>> 8);
        this.buf[6] = (byte)v2CipherSpecLen;
        this.buf[7] = 0;
        this.buf[8] = 0;
        this.buf[9] = 0;
        this.buf[10] = 32;
        System.arraycopy(v3Msg, 2, this.buf, this.count, 32);
        this.count += 32;
        this.count -= 2;
        this.buf[0] = (byte)(this.count >>> 8);
        this.buf[0] = (byte)(this.buf[0] | 0x80);
        this.buf[1] = (byte)this.count;
        this.count += 2;
    }

    private int V3toV2CipherSuite(byte byte1, byte byte2) {
        this.buf[this.count++] = 0;
        this.buf[this.count++] = byte1;
        this.buf[this.count++] = byte2;
        if ((byte2 & 0xFF) > 10 || V3toV2CipherMap1[byte2] == -1) {
            return 3;
        }
        this.buf[this.count++] = (byte)V3toV2CipherMap1[byte2];
        this.buf[this.count++] = 0;
        this.buf[this.count++] = (byte)V3toV2CipherMap3[byte2];
        return 6;
    }
}

