/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.Padding;
import javax.crypto.ShortBufferException;

final class PKCS5Padding
implements Padding {
    private int blockSize;

    PKCS5Padding(int blockSize) {
        this.blockSize = blockSize;
    }

    public void padWithLen(byte[] in, int off, int len) throws ShortBufferException {
        if (in == null) {
            return;
        }
        if (off + len > in.length) {
            throw new ShortBufferException("Buffer too small to hold padding");
        }
        byte paddingOctet = (byte)(len & 0xFF);
        for (int i = 0; i < len; ++i) {
            in[i + off] = paddingOctet;
        }
    }

    public int unpad(byte[] in, int off, int len) {
        if (in == null || len == 0) {
            return 0;
        }
        byte lastByte = in[off + len - 1];
        int padValue = lastByte & 0xFF;
        if (padValue < 1 || padValue > this.blockSize) {
            return -1;
        }
        int start = off + len - (lastByte & 0xFF);
        if (start < off) {
            return -1;
        }
        for (int i = 0; i < (lastByte & 0xFF); ++i) {
            if (in[start + i] == lastByte) continue;
            return -1;
        }
        return start;
    }

    public int padLength(int len) {
        int paddingOctet = this.blockSize - len % this.blockSize;
        return paddingOctet;
    }
}

