/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public abstract class DBCS_ONLY_IBM_EBCDIC_Decoder
extends CharsetDecoder {
    protected static final char REPLACE_CHAR = '\ufffd';
    protected short[] index1;
    protected String index2;
    protected int mask1;
    protected int mask2;
    protected int shift;

    protected DBCS_ONLY_IBM_EBCDIC_Decoder(Charset cs) {
        super(cs, 0.5f, 1.0f);
    }

    private static boolean isValidDoubleByte(int b1, int b2) {
        return b1 == 64 && b2 == 64 || 65 <= b1 && b1 <= 254 && 65 <= b2 && b2 <= 254;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
        byte[] sa = src.array();
        int sp = src.arrayOffset() + src.position();
        int sl = src.arrayOffset() + src.limit();
        assert (sp <= sl);
        sp = sp <= sl ? sp : sl;
        char[] da = dst.array();
        int dp = dst.arrayOffset() + dst.position();
        int dl = dst.arrayOffset() + dst.limit();
        assert (dp <= dl);
        dp = dp <= dl ? dp : dl;
        try {
            while (sp + 1 < sl) {
                int b1 = sa[sp] & 0xFF;
                int b2 = sa[sp + 1] & 0xFF;
                if (!DBCS_ONLY_IBM_EBCDIC_Decoder.isValidDoubleByte(b1, b2)) {
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                int v = b1 * 256 + b2;
                char outputChar = this.index2.charAt(this.index1[(v & this.mask1) >> this.shift] + (v & this.mask2));
                if (outputChar == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                    return coderResult;
                }
                if (dl - dp < 1) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                da[dp++] = outputChar;
                sp += 2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(sp - src.arrayOffset());
            dst.position(dp - dst.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
        int mark = src.position();
        try {
            while (src.remaining() > 1) {
                int b2;
                int b1 = src.get() & 0xFF;
                if (!DBCS_ONLY_IBM_EBCDIC_Decoder.isValidDoubleByte(b1, b2 = src.get() & 0xFF)) {
                    CoderResult coderResult = CoderResult.malformedForLength(2);
                    return coderResult;
                }
                int v = b1 * 256 + b2;
                char outputChar = this.index2.charAt(this.index1[(v & this.mask1) >> this.shift] + (v & this.mask2));
                if (outputChar == '\ufffd') {
                    CoderResult coderResult = CoderResult.unmappableForLength(2);
                    return coderResult;
                }
                if (!dst.hasRemaining()) {
                    CoderResult coderResult = CoderResult.OVERFLOW;
                    return coderResult;
                }
                dst.put(outputChar);
                mark += 2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            src.position(mark);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
        if (src.hasArray() && dst.hasArray()) {
            return this.decodeArrayLoop(src, dst);
        }
        return this.decodeBufferLoop(src, dst);
    }
}

