/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sun.awt.image.ImageDecoder;
import sun.awt.image.URLImageSource;

public class JarImageSource
extends URLImageSource {
    String mimeType;
    String entryName = null;
    URL url;

    public JarImageSource(URL u, String type) {
        super(u);
        this.url = u;
        this.mimeType = type;
    }

    public JarImageSource(URL u, String name, String type) {
        this(u, type);
        this.entryName = name;
    }

    protected ImageDecoder getDecoder() {
        InputStream is = null;
        try {
            JarURLConnection c = (JarURLConnection)this.url.openConnection();
            JarFile f = c.getJarFile();
            JarEntry e = c.getJarEntry();
            if (this.entryName != null && e == null) {
                e = f.getJarEntry(this.entryName);
            }
            if (e == null || e != null && this.entryName != null && !this.entryName.equals(e.getName())) {
                return null;
            }
            is = f.getInputStream(e);
        }
        catch (IOException e) {
            return null;
        }
        ImageDecoder id = this.decoderForType(is, this.mimeType);
        if (id == null) {
            id = this.getDecoder(is);
        }
        return id;
    }
}

