/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.proxy;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.rmi.transport.proxy.CGIClientException;
import sun.rmi.transport.proxy.CGICommandHandler;
import sun.rmi.transport.proxy.CGIForwardCommand;
import sun.rmi.transport.proxy.CGIGethostnameCommand;
import sun.rmi.transport.proxy.CGIPingCommand;
import sun.rmi.transport.proxy.CGIServerException;
import sun.rmi.transport.proxy.CGITryHostnameCommand;

public final class CGIHandler {
    static int ContentLength;
    static String QueryString;
    static String RequestMethod;
    static String ServerName;
    static int ServerPort;
    private static CGICommandHandler[] commands;
    private static Hashtable commandLookup;

    private CGIHandler() {
    }

    public static void main(String[] args) {
        try {
            String param;
            String command;
            int delim = QueryString.indexOf("=");
            if (delim == -1) {
                command = QueryString;
                param = "";
            } else {
                command = QueryString.substring(0, delim);
                param = QueryString.substring(delim + 1);
            }
            CGICommandHandler handler = (CGICommandHandler)commandLookup.get(command);
            if (handler != null) {
                try {
                    handler.execute(param);
                }
                catch (CGIClientException e) {
                    CGIHandler.returnClientError(e.getMessage());
                }
                catch (CGIServerException e) {
                    CGIHandler.returnServerError(e.getMessage());
                }
            } else {
                CGIHandler.returnClientError("invalid command: " + command);
            }
        }
        catch (Exception e) {
            CGIHandler.returnServerError("internal error: " + e.getMessage());
        }
        System.exit(0);
    }

    private static void returnClientError(String message) {
        System.out.println("Status: 400 Bad Request: " + message);
        System.out.println("Content-type: text/html");
        System.out.println("");
        System.out.println("<HTML><HEAD><TITLE>Java RMI Client Error</TITLE></HEAD><BODY>");
        System.out.println("<H1>Java RMI Client Error</H1>");
        System.out.println("");
        System.out.println(message);
        System.out.println("</BODY></HTML>");
        System.exit(1);
    }

    private static void returnServerError(String message) {
        System.out.println("Status: 500 Server Error: " + message);
        System.out.println("Content-type: text/html");
        System.out.println("");
        System.out.println("<HTML><HEAD><TITLE>Java RMI Server Error</TITLE></HEAD><BODY>");
        System.out.println("<H1>Java RMI Server Error</H1>");
        System.out.println("");
        System.out.println(message);
        System.out.println("</BODY></HTML>");
        System.exit(1);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ContentLength = Integer.getInteger("CONTENT_LENGTH", 0);
                QueryString = System.getProperty("QUERY_STRING", "");
                RequestMethod = System.getProperty("REQUEST_METHOD", "");
                ServerName = System.getProperty("SERVER_NAME", "");
                ServerPort = Integer.getInteger("SERVER_PORT", 0);
                return null;
            }
        });
        commands = new CGICommandHandler[]{new CGIForwardCommand(), new CGIGethostnameCommand(), new CGIPingCommand(), new CGITryHostnameCommand()};
        commandLookup = new Hashtable();
        for (int i = 0; i < commands.length; ++i) {
            commandLookup.put(commands[i].getName(), commands[i]);
        }
    }
}

