/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import sun.awt.SunToolkit;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.SurfaceType;
import sun.java2d.loops.TransformBlit;
import sun.java2d.pipe.Region;
import sun.java2d.xr.XRPMBlitLoops;
import sun.java2d.xr.XRSurfaceData;
import sun.java2d.xr.XRUtils;

class X11PMTransformedBlit
extends TransformBlit {
    static int lastMaskWidth = 0;
    static int lastMaskHeight = 0;

    public X11PMTransformedBlit(SurfaceType srcType, SurfaceType dstType) {
        super(srcType, CompositeType.AnyAlpha, dstType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Transform(SurfaceData src, SurfaceData dst, Composite comp, Region clip, AffineTransform xform, int hint, int srcx, int srcy, int dstx, int dsty, int width, int height) {
        block8: {
            try {
                SunToolkit.awtLock();
                int xrInterpolationType = XRUtils.ATransOpToXRQuality(hint);
                XRSurfaceData x11sdDst = (XRSurfaceData)dst;
                x11sdDst.validate(clip, comp, null, null, null, 0);
                XRSurfaceData x11sdSrc = (XRSurfaceData)src;
                Rectangle2D.Float rect = new Rectangle2D.Float(dstx, dsty, width, height);
                Shape shp = xform.createTransformedShape(rect);
                Rectangle bounds = shp.getBounds();
                AffineTransform trx = AffineTransform.getTranslateInstance(-bounds.x, -bounds.y);
                trx.concatenate(xform);
                AffineTransform maskTX = (AffineTransform)trx.clone();
                trx.translate(-srcx, -srcy);
                try {
                    trx.invert();
                }
                catch (NoninvertibleTransformException ex) {
                    trx.setToIdentity();
                    System.err.println("Reseted to identity!");
                }
                boolean omitMask = X11PMTransformedBlit.isMaskOmittable(trx, comp, xrInterpolationType);
                if (!omitMask) {
                    int maskWidth = Math.max(width / 8, 1);
                    int maskHeight = Math.max(height / 8, 1);
                    maskTX.scale((double)width / (double)maskWidth, (double)height / (double)maskHeight);
                    try {
                        maskTX.invert();
                    }
                    catch (NoninvertibleTransformException ex) {
                        maskTX.setToIdentity();
                        System.err.println("Reseted to identity!");
                    }
                    x11sdSrc.validateAsSource(trx, 2, xrInterpolationType);
                    XRPMBlitLoops.nativeTransformedRenderBlit(src.getNativeOps(), dst.getNativeOps(), 0, 0, bounds.x, bounds.y, bounds.width, bounds.height, XRUtils.XDoubleToFixed(maskTX.getScaleX()), XRUtils.XDoubleToFixed(maskTX.getShearX()), XRUtils.XDoubleToFixed(maskTX.getTranslateX()), XRUtils.XDoubleToFixed(maskTX.getShearY()), XRUtils.XDoubleToFixed(maskTX.getScaleY()), XRUtils.XDoubleToFixed(maskTX.getTranslateY()), maskWidth, maskHeight, lastMaskWidth, lastMaskHeight);
                    lastMaskWidth = maskWidth;
                    lastMaskHeight = maskHeight;
                    break block8;
                }
                int repeat = xrInterpolationType <= 0 ? 0 : 2;
                x11sdSrc.validateAsSource(trx, repeat, xrInterpolationType);
                XRPMBlitLoops.nativeTransformedRenderBlit(src.getNativeOps(), dst.getNativeOps(), 0, 0, bounds.x, bounds.y, bounds.width, bounds.height, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0);
            }
            finally {
                SunToolkit.awtUnlock();
            }
        }
    }

    protected static boolean isMaskOmittable(AffineTransform trx, Composite comp, int interpolation) {
        return (interpolation <= 0 || trx.getTranslateX() == (double)((int)trx.getTranslateX()) && trx.getTranslateY() == (double)((int)trx.getTranslateY()) && (trx.getShearX() == 0.0 && trx.getShearY() == 0.0 || trx.getShearX() == -trx.getShearY())) && ((AlphaComposite)comp).getAlpha() == 1.0f;
    }
}

