/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.cmm.lcms;

import java.awt.image.BufferedImage;
import sun.awt.image.ByteComponentRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.image.ShortComponentRaster;

class LCMSImageLayout {
    public static final int SWAPFIRST = 16384;
    public static final int DOSWAP = 1024;
    public static final int PT_RGB_8 = LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_8 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_GRAY_16 = LCMSImageLayout.CHANNELS_SH(1) | LCMSImageLayout.BYTES_SH(2);
    public static final int PT_RGBA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ARGB_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x4000;
    public static final int PT_BGR_8 = 0x400 | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_ABGR_8 = 0x400 | LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1);
    public static final int PT_BGRA_8 = LCMSImageLayout.EXTRA_SH(1) | LCMSImageLayout.CHANNELS_SH(3) | LCMSImageLayout.BYTES_SH(1) | 0x400 | 0x4000;
    public static final int DT_BYTE = 0;
    public static final int DT_SHORT = 1;
    public static final int DT_INT = 2;
    public static final int DT_DOUBLE = 3;
    boolean isIntPacked = false;
    int pixelType;
    int dataType;
    int width;
    int height;
    int nextRowOffset;
    int offset;
    Object dataArray;

    public static int BYTES_SH(int x) {
        return x;
    }

    public static int EXTRA_SH(int x) {
        return x << 7;
    }

    public static int CHANNELS_SH(int x) {
        return x << 3;
    }

    private LCMSImageLayout(int np, int pixelType, int pixelSize) {
        this.pixelType = pixelType;
        this.width = np;
        this.height = 1;
        this.nextRowOffset = np * pixelSize;
        this.offset = 0;
    }

    private LCMSImageLayout(int width, int height, int pixelType, int pixelSize) {
        this.pixelType = pixelType;
        this.width = width;
        this.height = height;
        this.nextRowOffset = width * pixelSize;
        this.offset = 0;
    }

    public LCMSImageLayout(byte[] data, int np, int pixelType, int pixelSize) {
        this(np, pixelType, pixelSize);
        this.dataType = 0;
        this.dataArray = data;
    }

    public LCMSImageLayout(short[] data, int np, int pixelType, int pixelSize) {
        this(np, pixelType, pixelSize);
        this.dataType = 1;
        this.dataArray = data;
    }

    public LCMSImageLayout(int[] data, int np, int pixelType, int pixelSize) {
        this(np, pixelType, pixelSize);
        this.dataType = 2;
        this.dataArray = data;
    }

    public LCMSImageLayout(double[] data, int np, int pixelType, int pixelSize) {
        this(np, pixelType, pixelSize);
        this.dataType = 3;
        this.dataArray = data;
    }

    public LCMSImageLayout(BufferedImage image) {
        switch (image.getType()) {
            case 1: {
                this.pixelType = PT_ARGB_8;
                this.isIntPacked = true;
                break;
            }
            case 2: {
                this.pixelType = PT_ARGB_8;
                this.isIntPacked = true;
                break;
            }
            case 4: {
                this.pixelType = PT_ABGR_8;
                this.isIntPacked = true;
                break;
            }
            case 5: {
                this.pixelType = PT_BGR_8;
                break;
            }
            case 6: {
                this.pixelType = PT_ABGR_8;
                break;
            }
            case 10: {
                this.pixelType = PT_GRAY_8;
                break;
            }
            case 11: {
                this.pixelType = PT_GRAY_16;
                break;
            }
            default: {
                throw new IllegalArgumentException("CMMImageLayout - bad image type passed to constructor");
            }
        }
        this.width = image.getWidth();
        this.height = image.getHeight();
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 4: {
                IntegerComponentRaster intRaster = (IntegerComponentRaster)image.getRaster();
                this.nextRowOffset = intRaster.getScanlineStride() * 4;
                this.offset = intRaster.getDataOffset(0) * 4;
                this.dataArray = intRaster.getDataStorage();
                this.dataType = 2;
                break;
            }
            case 5: 
            case 6: {
                ByteComponentRaster byteRaster = (ByteComponentRaster)image.getRaster();
                this.nextRowOffset = byteRaster.getScanlineStride();
                this.offset = byteRaster.getDataOffset(0);
                this.dataArray = byteRaster.getDataStorage();
                this.dataType = 0;
                break;
            }
            case 10: {
                ByteComponentRaster byteRaster = (ByteComponentRaster)image.getRaster();
                this.nextRowOffset = byteRaster.getScanlineStride();
                this.offset = byteRaster.getDataOffset(0);
                this.dataArray = byteRaster.getDataStorage();
                this.dataType = 0;
                break;
            }
            case 11: {
                ShortComponentRaster shortRaster = (ShortComponentRaster)image.getRaster();
                this.nextRowOffset = shortRaster.getScanlineStride() * 2;
                this.offset = shortRaster.getDataOffset(0) * 2;
                this.dataArray = shortRaster.getDataStorage();
                this.dataType = 1;
            }
        }
    }

    public static boolean isSupported(BufferedImage image) {
        switch (image.getType()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                return true;
            }
        }
        return false;
    }
}

