/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.ext.EUC_TW;

public abstract class X11CNS11643
extends Charset {
    private final int plane;

    public X11CNS11643(int plane, String name) {
        super(name, null);
        switch (plane) {
            case 1: {
                this.plane = 0;
                break;
            }
            case 2: 
            case 3: {
                this.plane = plane;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
            }
        }
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this, this.plane);
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this, this.plane);
    }

    public boolean contains(Charset cs) {
        return cs instanceof X11CNS11643;
    }

    private class Decoder
    extends EUC_TW.Decoder {
        private String table;

        protected Decoder(Charset cs, int plane) {
            super(cs);
            switch (plane) {
                case 0: {
                    this.table = unicodeCNS1;
                    break;
                }
                case 2: {
                    this.table = unicodeCNS2;
                    break;
                }
                case 3: {
                    this.table = unicodeCNS3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Only planes 1, 2, and 3 supported");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; sp += 2) {
                    if (sl - sp < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    byte b1 = sa[sp];
                    byte b2 = sa[sp + 1];
                    char c = this.convToUnicode((byte)(b1 | 0x80), (byte)(b2 | 0x80), this.table);
                    if (c == this.replacement().charAt(0)) {
                        CoderResult coderResult = CoderResult.unmappableForLength(2);
                        return coderResult;
                    }
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = c;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }
    }

    private class Encoder
    extends EUC_TW.Encoder {
        private int plane;

        public Encoder(Charset cs, int plane) {
            super(cs);
            this.plane = plane;
        }

        public boolean canEncode(char c) {
            if (c <= '\u007f') {
                return false;
            }
            int p = this.getNative(c) >> 16;
            return p == 1 && this.plane == 0 || p == 2 && this.plane == 2 || p == 3 && this.plane == 3;
        }

        public boolean isLegalReplacement(byte[] repl) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            int sp;
            char[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                for (sp = src.arrayOffset() + src.position(); sp < sl; ++sp) {
                    char c = sa[sp];
                    if (c >= '\ufffe' || c <= '\u007f') {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    int cns = this.getNative(c);
                    int p = cns >> 16;
                    if (p == 1 && this.plane == 0 || p == 2 && this.plane == 2 || p == 3 && this.plane == 3) {
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(cns >> 8 & 0x7F);
                        da[dp++] = (byte)(cns & 0x7F);
                        continue;
                    }
                    CoderResult coderResult = CoderResult.unmappableForLength(1);
                    return coderResult;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }
    }
}

