/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import sun.awt.X11.XEvent;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XWindow;

class XWarningWindow
extends XWindow {
    static final int defaultHeight = 27;
    Window ownerWindow;

    XWarningWindow(Window ownerWindow, long parentWindow) {
        super(ownerWindow, parentWindow);
        this.ownerWindow = ownerWindow;
        this.xSetVisible(true);
        this.toFront();
    }

    protected String getWMName() {
        return "Warning window";
    }

    public Graphics getGraphics() {
        if (this.surfaceData == null || this.ownerWindow == null) {
            return null;
        }
        return this.getGraphics(this.surfaceData, this.getColor(), this.getBackground(), this.getFont());
    }

    void paint(Graphics g, int x, int y, int width, int height) {
        String warningString = this.getWarningString();
        Rectangle bounds = this.getBounds();
        bounds.x = 0;
        bounds.y = 0;
        Rectangle updateRect = new Rectangle(x, y, width, height);
        if (updateRect.intersects(bounds)) {
            Rectangle updateArea = updateRect.intersection(bounds);
            g.setClip(updateArea);
            g.setColor(this.getBackground());
            g.fillRect(updateArea.x, updateArea.y, updateArea.width, updateArea.height);
            g.setColor(this.getColor());
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            int warningWidth = fm.stringWidth(warningString);
            int w_x = (bounds.width - warningWidth) / 2;
            int w_y = (bounds.height + fm.getMaxAscent() - fm.getMaxDescent()) / 2;
            g.drawString(warningString, w_x, w_y);
            g.drawLine(bounds.x, bounds.y + bounds.height - 1, bounds.x + bounds.width - 1, bounds.y + bounds.height - 1);
        }
    }

    String getWarningString() {
        return this.ownerWindow.getWarningString();
    }

    int getHeight() {
        return 27;
    }

    Color getBackground() {
        return SystemColor.window;
    }

    Color getColor() {
        return Color.black;
    }

    Font getFont() {
        return this.ownerWindow.getFont();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        Rectangle bounds = this.getBounds();
        Graphics g = this.getGraphics();
        try {
            this.paint(g, 0, 0, bounds.width, bounds.height);
            Object var4_3 = null;
            g.dispose();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            g.dispose();
            throw throwable;
        }
    }

    public void handleExposeEvent(XEvent xev) {
        super.handleExposeEvent(xev);
        XExposeEvent xe = xev.get_xexpose();
        final int x = xe.get_x();
        final int y = xe.get_y();
        final int width = xe.get_width();
        final int height = xe.get_height();
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Graphics g = XWarningWindow.this.getGraphics();
                try {
                    XWarningWindow.this.paint(g, x, y, width, height);
                    Object var3_2 = null;
                    g.dispose();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    g.dispose();
                    throw throwable;
                }
            }
        });
    }

    protected boolean isEventDisabled(XEvent e) {
        return true;
    }
}

