/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuBarPeer;
import java.lang.reflect.Field;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.SunToolkit;
import sun.awt.X11.XBaseMenuWindow;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMenuItemPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XToolkit;

public class XMenuBarPeer
extends XBaseMenuWindow
implements MenuBarPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XMenuBarPeer");
    private XFramePeer framePeer;
    private MenuBar menuBarTarget;
    private XMenuPeer helpMenu = null;
    private static final int BAR_SPACING_TOP = 3;
    private static final int BAR_SPACING_BOTTOM = 3;
    private static final int BAR_SPACING_LEFT = 3;
    private static final int BAR_SPACING_RIGHT = 3;
    private static final int BAR_ITEM_SPACING = 2;
    private static final int BAR_ITEM_MARGIN_LEFT = 10;
    private static final int BAR_ITEM_MARGIN_RIGHT = 10;
    private static final int BAR_ITEM_MARGIN_TOP = 2;
    private static final int BAR_ITEM_MARGIN_BOTTOM = 2;
    private static Field f_helpMenu = SunToolkit.getField(MenuBar.class, "helpMenu");
    private static Field f_menus = SunToolkit.getField(MenuBar.class, "menus");
    static final int W_DIFF = 12;
    static final int H_DIFF = 23;

    XMenuBarPeer(MenuBar menuBarTarget) {
        this.menuBarTarget = menuBarTarget;
    }

    public void setFont(Font f) {
        this.resetMapping();
        this.setItemsFont(f);
        this.postPaintEvent();
    }

    public void addMenu(Menu m) {
        this.addItem(m);
        this.postPaintEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delMenu(int index) {
        Object object = XMenuBarPeer.getMenuTreeLock();
        synchronized (object) {
            XMenuItemPeer item = this.getItem(index);
            if (item != null && item == this.helpMenu) {
                this.helpMenu = null;
            }
            this.delItem(index);
        }
        this.postPaintEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHelpMenu(Menu m) {
        XMenuPeer mp = (XMenuPeer)m.getPeer();
        Object object = XMenuBarPeer.getMenuTreeLock();
        synchronized (object) {
            this.helpMenu = mp;
        }
        this.postPaintEvent();
    }

    public void init(Frame frame) {
        this.target = frame;
        this.framePeer = (XFramePeer)frame.getPeer();
        XCreateWindowParams params = this.getDelayedParams();
        params.remove("delayed");
        params.add((Object)"parent window", this.framePeer.getShell());
        params.add((Object)"target", frame);
        this.init(params);
    }

    void postInit(XCreateWindowParams params) {
        super.postInit(params);
        Vector targetMenuVector = null;
        Menu targetHelpMenu = null;
        try {
            targetMenuVector = (Vector)f_menus.get(this.menuBarTarget);
            targetHelpMenu = (Menu)f_helpMenu.get(this.menuBarTarget);
            this.reloadItems(targetMenuVector);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        if (targetHelpMenu != null) {
            this.addHelpMenu(targetHelpMenu);
        }
        this.xSetVisible(true);
        this.toFront();
    }

    protected XBaseMenuWindow getParentMenuWindow() {
        return null;
    }

    protected MappingData map() {
        XMenuItemPeer[] itemVector = this.copyItems();
        int itemCnt = itemVector.length;
        XMenuPeer helpMenu = this.helpMenu;
        int helpMenuPos = -1;
        if (helpMenu != null) {
            for (int i = 0; i < itemCnt; ++i) {
                if (itemVector[i] != helpMenu) continue;
                helpMenuPos = i;
                break;
            }
            if (helpMenuPos != -1 && helpMenuPos != itemCnt - 1) {
                System.arraycopy(itemVector, helpMenuPos + 1, itemVector, helpMenuPos, itemCnt - 1 - helpMenuPos);
                itemVector[itemCnt - 1] = helpMenu;
            }
        }
        int maxHeight = 0;
        XMenuItemPeer.TextMetrics[] itemMetrics = new XMenuItemPeer.TextMetrics[itemCnt];
        for (int i = 0; i < itemCnt; ++i) {
            itemMetrics[i] = itemVector[i].getTextMetrics();
            Dimension dim = itemMetrics[i].getTextDimension();
            if (dim == null) continue;
            maxHeight = Math.max(maxHeight, dim.height);
        }
        int nextOffset = 0;
        int itemHeight = 2 + maxHeight + 2;
        int mappedCnt = itemCnt;
        for (int i = 0; i < itemCnt; ++i) {
            XMenuItemPeer item = itemVector[i];
            XMenuItemPeer.TextMetrics metrics = itemMetrics[i];
            Dimension dim = metrics.getTextDimension();
            if (dim != null) {
                int itemWidth = 10 + dim.width + 10;
                if (nextOffset + itemWidth > this.width && i > 0) {
                    mappedCnt = i;
                    break;
                }
                if (i == itemCnt - 1 && helpMenuPos != -1) {
                    nextOffset = Math.max(nextOffset, this.width - itemWidth - 3);
                }
                Rectangle bounds = new Rectangle(nextOffset, 3, itemWidth, itemHeight);
                int y = (maxHeight + dim.height) / 2 - metrics.getTextBaseline();
                Point textOrigin = new Point(nextOffset + 10, 5 + y);
                nextOffset += itemWidth + 2;
                item.map(bounds, textOrigin);
                continue;
            }
            Rectangle bounds = new Rectangle(nextOffset, 3, 0, 0);
            Point textOrigin = new Point(nextOffset + 10, 5);
        }
        XMenuItemPeer[] mappedVector = new XMenuItemPeer[mappedCnt];
        System.arraycopy(itemVector, 0, mappedVector, 0, mappedCnt);
        MappingData mappingData = new MappingData(mappedVector, 3 + itemHeight + 3);
        return mappingData;
    }

    protected Rectangle getSubmenuBounds(Rectangle itemBounds, Dimension windowSize) {
        Dimension screenSize;
        Rectangle globalBounds = this.toGlobal(itemBounds);
        Rectangle res = this.fitWindowBelow(globalBounds, windowSize, screenSize = Toolkit.getDefaultToolkit().getScreenSize());
        if (res != null) {
            return res;
        }
        res = this.fitWindowAbove(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowRight(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        res = this.fitWindowLeft(globalBounds, windowSize, screenSize);
        if (res != null) {
            return res;
        }
        return this.fitWindowToScreen(windowSize, screenSize);
    }

    protected void updateSize() {
        this.resetMapping();
        if (this.framePeer != null) {
            this.framePeer.reshapeMenubarPeer();
        }
    }

    int getDesiredHeight() {
        MappingData mappingData = (MappingData)this.getMappingData();
        return mappingData.getDesiredHeight();
    }

    boolean isFramePeerEnabled() {
        if (this.framePeer != null) {
            return this.framePeer.isEnabled();
        }
        return false;
    }

    protected void doDispose() {
        super.doDispose();
        XToolkit.targetDisposedPeer(this.menuBarTarget, this);
    }

    public void reshape(int x, int y, int width, int height) {
        if (width != this.width || height != this.height) {
            this.resetMapping();
        }
        super.reshape(x, y, width, height);
    }

    void ungrabInputImpl() {
        this.selectItem(null, false);
        super.ungrabInputImpl();
        this.postPaintEvent();
    }

    public void paint(Graphics g) {
        this.resetColors();
        int width = this.getWidth();
        int height = this.getHeight();
        this.flush();
        g.setColor(this.getBackgroundColor());
        g.fillRect(1, 1, width - 2, height - 2);
        this.draw3DRect(g, 0, 0, width, height, true);
        MappingData mappingData = (MappingData)this.getMappingData();
        XMenuItemPeer[] itemVector = mappingData.getItems();
        XMenuItemPeer selectedItem = this.getSelectedItem();
        for (int i = 0; i < itemVector.length; ++i) {
            XMenuItemPeer item = itemVector[i];
            g.setFont(item.getTargetFont());
            Rectangle bounds = item.getBounds();
            Point textOrigin = item.getTextOrigin();
            if (item == selectedItem) {
                g.setColor(this.getSelectedColor());
                g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
                this.draw3DRect(g, bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
            if (this.isFramePeerEnabled() && item.isTargetItemEnabled()) {
                g.setColor(this.getForegroundColor());
            } else {
                g.setColor(this.getDisabledColor());
            }
            g.drawString(item.getTargetLabel(), textOrigin.x, textOrigin.y);
        }
        this.flush();
    }

    void print(Graphics g) {
    }

    protected void handleEvent(AWTEvent event) {
        if (this.framePeer != null && event.getID() != 800 && this.framePeer.isModalBlocked()) {
            return;
        }
        switch (event.getID()) {
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: {
                if (!this.isFramePeerEnabled()) break;
                this.doHandleJavaMouseEvent((MouseEvent)event);
                break;
            }
            case 401: 
            case 402: {
                if (!this.isFramePeerEnabled()) break;
                this.doHandleJavaKeyEvent((KeyEvent)event);
                break;
            }
            default: {
                super.handleEvent(event);
            }
        }
    }

    void handleF10KeyPress(KeyEvent event) {
        int keyState = event.getModifiers();
        if ((keyState & 8) != 0 || (keyState & 1) != 0 || (keyState & 2) != 0) {
            return;
        }
        this.grabInput();
        this.selectItem(this.getFirstSelectableItem(), true);
    }

    public void handleKeyPress(XEvent xev) {
        XKeyEvent xkey = xev.get_xkey();
        if (log.isLoggable(Level.FINE)) {
            log.fine(xkey.toString());
        }
        if (this.isEventDisabled(xev)) {
            return;
        }
        Component currentSource = this.getEventSource();
        this.handleKeyPress(xkey);
    }

    static class MappingData
    extends XBaseMenuWindow.MappingData {
        int desiredHeight;

        MappingData(XMenuItemPeer[] items, int desiredHeight) {
            super(items);
            this.desiredHeight = desiredHeight;
        }

        MappingData() {
            this.desiredHeight = 0;
        }

        public int getDesiredHeight() {
            return this.desiredHeight;
        }
    }
}

