/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import net.sourceforge.jnlp.security.HttpsCertVerifier;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.security.SecurityWarningDialog;
import sun.security.validator.ValidatorException;

public class VariableX509TrustManager
implements X509TrustManager {
    KeyStore userKeyStore = null;
    KeyStore caKeyStore = null;
    X509TrustManager userTrustManager = null;
    X509TrustManager caTrustManager = null;
    ArrayList<Certificate> temporarilyTrusted = new ArrayList();
    static VariableX509TrustManager instance = null;

    public VariableX509TrustManager() {
        int i;
        TrustManager[] trustManagers;
        TrustManagerFactory tmFactory;
        try {
            this.userKeyStore = SecurityUtil.getUserKeyStore();
            tmFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmFactory.init(this.userKeyStore);
            trustManagers = tmFactory.getTrustManagers();
            for (i = 0; i < trustManagers.length; ++i) {
                if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                this.userTrustManager = (X509TrustManager)trustManagers[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.caKeyStore = SecurityUtil.getCacertsKeyStore();
            tmFactory = TrustManagerFactory.getInstance("SunX509", "SunJSSE");
            tmFactory.init(this.caKeyStore);
            trustManagers = tmFactory.getTrustManagers();
            for (i = 0; i < trustManagers.length; ++i) {
                if (!(trustManagers[i] instanceof X509TrustManager)) continue;
                this.caTrustManager = (X509TrustManager)trustManagers[i];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.caTrustManager.checkClientTrusted(chain, authType);
        }
        catch (Exception caex) {
            try {
                this.userTrustManager.checkClientTrusted(chain, authType);
            }
            catch (Exception userex) {
                // empty catch block
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.checkServerTrusted(chain, authType, false);
    }

    public void checkServerTrusted(X509Certificate[] chain, String authType, boolean checkOnly) throws CertificateException {
        try {
            this.checkAllManagers(chain, authType);
        }
        catch (CertificateException ce) {
            if (checkOnly) {
                throw ce;
            }
            boolean b = this.askUser(chain, authType);
            if (b) {
                this.temporarilyTrust(chain[0]);
            }
            this.checkAllManagers(chain, authType);
        }
    }

    private void checkAllManagers(X509Certificate[] chain, String authType) throws CertificateException {
        block4: {
            try {
                this.caTrustManager.checkServerTrusted(chain, authType);
            }
            catch (ValidatorException caex) {
                try {
                    this.userTrustManager.checkServerTrusted(chain, authType);
                }
                catch (ValidatorException uex) {
                    if (this.temporarilyTrusted.contains(chain[0])) break block4;
                    throw uex;
                }
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.caTrustManager.getAcceptedIssuers();
    }

    private void temporarilyTrust(Certificate c) {
        this.temporarilyTrusted.add(c);
    }

    private boolean askUser(X509Certificate[] chain, String authType) {
        return SecurityWarningDialog.showCertWarningDialog(SecurityWarningDialog.AccessType.UNVERIFIED, null, new HttpsCertVerifier(this, chain, authType));
    }

    public static VariableX509TrustManager getInstance() {
        if (instance == null) {
            instance = new VariableX509TrustManager();
        }
        return instance;
    }
}

