/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import net.sourceforge.jnlp.security.CertVerifier;
import net.sourceforge.jnlp.security.CertsInfoPane;
import net.sourceforge.jnlp.security.SecurityWarningDialog;

public class SingleCertInfoPane
extends CertsInfoPane {
    public SingleCertInfoPane(JComponent x, CertVerifier certVerifier) {
        super(x, certVerifier);
    }

    @Override
    protected void buildTree() {
        X509Certificate cert = ((SecurityWarningDialog)this.optionPane).getCert();
        String subjectString = this.getCN(cert.getSubjectX500Principal().getName());
        String issuerString = this.getCN(cert.getIssuerX500Principal().getName());
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(subjectString + " (" + issuerString + ")");
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new CertsInfoPane.TreeSelectionHandler());
    }

    @Override
    protected void populateTable() {
        X509Certificate c = ((SecurityWarningDialog)this.optionPane).getCert();
        this.certNames = new String[1];
        this.certsData = new ArrayList();
        this.certsData.add(this.parseCert(c));
        this.certNames[0] = this.getCN(c.getSubjectX500Principal().getName()) + " (" + this.getCN(c.getIssuerX500Principal().getName()) + ")";
    }
}

