/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalBorders;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxIcon;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalComboBoxUI
extends BasicComboBoxUI {
    public static ComponentUI createUI(JComponent c) {
        return new MetalComboBoxUI();
    }

    public void paint(Graphics g, JComponent c) {
        if (MetalLookAndFeel.usingOcean()) {
            super.paint(g, c);
        }
    }

    public void paintCurrentValue(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (MetalLookAndFeel.usingOcean()) {
            bounds.x += 2;
            bounds.width -= 3;
            if (this.arrowButton != null) {
                Insets buttonInsets = this.arrowButton.getInsets();
                bounds.y += buttonInsets.top;
                bounds.height -= buttonInsets.top + buttonInsets.bottom;
            } else {
                bounds.y += 2;
                bounds.height -= 4;
            }
            super.paintCurrentValue(g, bounds, hasFocus);
        } else if (g == null || bounds == null) {
            throw new NullPointerException("Must supply a non-null Graphics and Rectangle");
        }
    }

    public void paintCurrentValueBackground(Graphics g, Rectangle bounds, boolean hasFocus) {
        if (MetalLookAndFeel.usingOcean()) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height - 1);
            g.setColor(MetalLookAndFeel.getControlShadow());
            g.drawRect(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 3);
            if (hasFocus && !this.isPopupVisible(this.comboBox) && this.arrowButton != null) {
                g.setColor(this.listBox.getSelectionBackground());
                Insets buttonInsets = this.arrowButton.getInsets();
                if (buttonInsets.top > 2) {
                    g.fillRect(bounds.x + 2, bounds.y + 2, bounds.width - 3, buttonInsets.top - 2);
                }
                if (buttonInsets.bottom > 2) {
                    g.fillRect(bounds.x + 2, bounds.y + bounds.height - buttonInsets.bottom, bounds.width - 3, buttonInsets.bottom - 2);
                }
            }
        } else if (g == null || bounds == null) {
            throw new NullPointerException("Must supply a non-null Graphics and Rectangle");
        }
    }

    public int getBaseline(JComponent c, int width, int height) {
        int baseline;
        if (MetalLookAndFeel.usingOcean()) {
            baseline = super.getBaseline(c, width, height -= 4);
            if (baseline >= 0) {
                baseline += 2;
            }
        } else {
            baseline = super.getBaseline(c, width, height);
        }
        return baseline;
    }

    protected ComboBoxEditor createEditor() {
        return new MetalComboBoxEditor.UIResource();
    }

    protected ComboPopup createPopup() {
        return super.createPopup();
    }

    protected JButton createArrowButton() {
        boolean iconOnly = this.comboBox.isEditable() || MetalLookAndFeel.usingOcean();
        MetalComboBoxButton button = new MetalComboBoxButton(this.comboBox, new MetalComboBoxIcon(), iconOnly, this.currentValuePane, this.listBox);
        button.setMargin(new Insets(0, 1, 1, 3));
        if (MetalLookAndFeel.usingOcean()) {
            button.putClientProperty(MetalBorders.NO_BUTTON_ROLLOVER, Boolean.TRUE);
        }
        this.updateButtonForOcean(button);
        return button;
    }

    private void updateButtonForOcean(JButton button) {
        if (MetalLookAndFeel.usingOcean()) {
            button.setFocusPainted(this.comboBox.isEditable());
        }
    }

    public PropertyChangeListener createPropertyChangeListener() {
        return new MetalPropertyChangeListener();
    }

    @Deprecated
    protected void editablePropertyChanged(PropertyChangeEvent e) {
    }

    protected LayoutManager createLayoutManager() {
        return new MetalComboBoxLayoutManager();
    }

    public void layoutComboBox(Container parent, MetalComboBoxLayoutManager manager) {
        if (this.comboBox.isEditable() && !MetalLookAndFeel.usingOcean()) {
            manager.superLayout(parent);
            return;
        }
        if (this.arrowButton != null) {
            Insets insets;
            if (MetalLookAndFeel.usingOcean()) {
                insets = this.comboBox.getInsets();
                int buttonWidth = this.arrowButton.getMinimumSize().width;
                this.arrowButton.setBounds(MetalUtils.isLeftToRight(this.comboBox) ? this.comboBox.getWidth() - insets.right - buttonWidth : insets.left, insets.top, buttonWidth, this.comboBox.getHeight() - insets.top - insets.bottom);
            } else {
                insets = this.comboBox.getInsets();
                int width = this.comboBox.getWidth();
                int height = this.comboBox.getHeight();
                this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
            }
        }
        if (this.editor != null && MetalLookAndFeel.usingOcean()) {
            Rectangle cvb = this.rectangleForCurrentValue();
            this.editor.setBounds(cvb);
        }
    }

    @Deprecated
    protected void removeListeners() {
        if (this.propertyChangeListener != null) {
            this.comboBox.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void configureEditor() {
        super.configureEditor();
    }

    public void unconfigureEditor() {
        super.unconfigureEditor();
    }

    public Dimension getMinimumSize(JComponent c) {
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension size = null;
        if (!this.comboBox.isEditable() && this.arrowButton != null) {
            Insets buttonInsets = this.arrowButton.getInsets();
            Insets insets = this.comboBox.getInsets();
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.right;
            size.width += this.arrowButton.getMinimumSize().width;
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
        } else if (this.comboBox.isEditable() && this.arrowButton != null && this.editor != null) {
            size = super.getMinimumSize(c);
            Insets margin = this.arrowButton.getMargin();
            size.height += margin.top + margin.bottom;
            size.width += margin.left + margin.right;
        } else {
            size = super.getMinimumSize(c);
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    @Deprecated
    public class MetalComboPopup
    extends BasicComboPopup {
        public MetalComboPopup(JComboBox cBox) {
            super(cBox);
        }

        public void delegateFocus(MouseEvent e) {
            super.delegateFocus(e);
        }
    }

    public class MetalComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        public void layoutContainer(Container parent) {
            MetalComboBoxUI.this.layoutComboBox(parent, this);
        }

        public void superLayout(Container parent) {
            super.layoutContainer(parent);
        }
    }

    public class MetalPropertyChangeListener
    extends BasicComboBoxUI.PropertyChangeHandler {
        public void propertyChange(PropertyChangeEvent e) {
            super.propertyChange(e);
            String propertyName = e.getPropertyName();
            if (propertyName == "editable") {
                if (MetalComboBoxUI.this.arrowButton instanceof MetalComboBoxButton) {
                    MetalComboBoxButton button = (MetalComboBoxButton)MetalComboBoxUI.this.arrowButton;
                    button.setIconOnly(MetalComboBoxUI.this.comboBox.isEditable() || MetalLookAndFeel.usingOcean());
                }
                MetalComboBoxUI.this.comboBox.repaint();
                MetalComboBoxUI.this.updateButtonForOcean(MetalComboBoxUI.this.arrowButton);
            } else if (propertyName == "background") {
                Color color = (Color)e.getNewValue();
                MetalComboBoxUI.this.arrowButton.setBackground(color);
                MetalComboBoxUI.this.listBox.setBackground(color);
            } else if (propertyName == "foreground") {
                Color color = (Color)e.getNewValue();
                MetalComboBoxUI.this.arrowButton.setForeground(color);
                MetalComboBoxUI.this.listBox.setForeground(color);
            }
        }
    }
}

