/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class BasicRadioButtonUI
extends BasicToggleButtonUI {
    private static final BasicRadioButtonUI radioButtonUI = new BasicRadioButtonUI();
    protected Icon icon;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "RadioButton.";
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle prefViewRect = new Rectangle();
    private static Rectangle prefIconRect = new Rectangle();
    private static Rectangle prefTextRect = new Rectangle();
    private static Insets prefInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent b) {
        return radioButtonUI;
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.defaults_initialized = true;
        }
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    public Icon getDefaultIcon() {
        return this.icon;
    }

    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        Insets i = c.getInsets();
        size = b.getSize(size);
        BasicRadioButtonUI.viewRect.x = i.left;
        BasicRadioButtonUI.viewRect.y = i.top;
        BasicRadioButtonUI.viewRect.width = BasicRadioButtonUI.size.width - (i.right + BasicRadioButtonUI.viewRect.x);
        BasicRadioButtonUI.viewRect.height = BasicRadioButtonUI.size.height - (i.bottom + BasicRadioButtonUI.viewRect.y);
        BasicRadioButtonUI.iconRect.height = 0;
        BasicRadioButtonUI.iconRect.width = 0;
        BasicRadioButtonUI.iconRect.y = 0;
        BasicRadioButtonUI.iconRect.x = 0;
        BasicRadioButtonUI.textRect.height = 0;
        BasicRadioButtonUI.textRect.width = 0;
        BasicRadioButtonUI.textRect.y = 0;
        BasicRadioButtonUI.textRect.x = 0;
        Icon altIcon = b.getIcon();
        Object selectedIcon = null;
        Object disabledIcon = null;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, BasicRadioButtonUI.size.width, BasicRadioButtonUI.size.height);
        }
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, BasicRadioButtonUI.iconRect.x, BasicRadioButtonUI.iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(c, g, BasicRadioButtonUI.iconRect.x, BasicRadioButtonUI.iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
            if (b.hasFocus() && b.isFocusPainted() && BasicRadioButtonUI.textRect.width > 0 && BasicRadioButtonUI.textRect.height > 0) {
                this.paintFocus(g, textRect, size);
            }
        }
    }

    protected void paintFocus(Graphics g, Rectangle textRect, Dimension size) {
    }

    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = this.getDefaultIcon();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        BasicRadioButtonUI.prefViewRect.y = 0;
        BasicRadioButtonUI.prefViewRect.x = 0;
        BasicRadioButtonUI.prefViewRect.width = Short.MAX_VALUE;
        BasicRadioButtonUI.prefViewRect.height = Short.MAX_VALUE;
        BasicRadioButtonUI.prefIconRect.height = 0;
        BasicRadioButtonUI.prefIconRect.width = 0;
        BasicRadioButtonUI.prefIconRect.y = 0;
        BasicRadioButtonUI.prefIconRect.x = 0;
        BasicRadioButtonUI.prefTextRect.height = 0;
        BasicRadioButtonUI.prefTextRect.width = 0;
        BasicRadioButtonUI.prefTextRect.y = 0;
        BasicRadioButtonUI.prefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(c, fm, text, buttonIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, text == null ? 0 : b.getIconTextGap());
        int x1 = Math.min(BasicRadioButtonUI.prefIconRect.x, BasicRadioButtonUI.prefTextRect.x);
        int x2 = Math.max(BasicRadioButtonUI.prefIconRect.x + BasicRadioButtonUI.prefIconRect.width, BasicRadioButtonUI.prefTextRect.x + BasicRadioButtonUI.prefTextRect.width);
        int y1 = Math.min(BasicRadioButtonUI.prefIconRect.y, BasicRadioButtonUI.prefTextRect.y);
        int y2 = Math.max(BasicRadioButtonUI.prefIconRect.y + BasicRadioButtonUI.prefIconRect.height, BasicRadioButtonUI.prefTextRect.y + BasicRadioButtonUI.prefTextRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        prefInsets = b.getInsets(prefInsets);
        return new Dimension(width += BasicRadioButtonUI.prefInsets.left + BasicRadioButtonUI.prefInsets.right, height += BasicRadioButtonUI.prefInsets.top + BasicRadioButtonUI.prefInsets.bottom);
    }
}

