/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import sun.awt.AppContext;

class TimerQueue
implements Runnable {
    private static final Object sharedInstanceKey = new StringBuffer("TimerQueue.sharedInstanceKey");
    private static final Object expiredTimersKey = new StringBuffer("TimerQueue.expiredTimersKey");
    private final DelayQueue<DelayedTimer> queue = new DelayQueue();
    volatile boolean running;
    private static final Object classLock = new Object();
    private static final long NANO_ORIGIN = System.nanoTime();

    public TimerQueue() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerQueue sharedInstance() {
        Object object = classLock;
        synchronized (object) {
            TimerQueue sharedInst = (TimerQueue)SwingUtilities.appContextGet(sharedInstanceKey);
            if (sharedInst == null) {
                sharedInst = new TimerQueue();
                SwingUtilities.appContextPut(sharedInstanceKey, sharedInst);
            }
            return sharedInst;
        }
    }

    synchronized void start() {
        if (this.running) {
            throw new RuntimeException("Can't start a TimerQueue that is already running");
        }
        final ThreadGroup threadGroup = AppContext.getAppContext().getThreadGroup();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread timerThread = new Thread(threadGroup, TimerQueue.this, "TimerQueue");
                timerThread.setDaemon(true);
                timerThread.setPriority(5);
                timerThread.start();
                return null;
            }
        });
    }

    synchronized void stop() {
        this.running = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTimer(Timer timer, long delayMillis) {
        timer.getLock().lock();
        try {
            if (!this.containsTimer(timer)) {
                this.addTimer(new DelayedTimer(timer, TimeUnit.MILLISECONDS.toNanos(delayMillis) + TimerQueue.now()));
            }
        }
        finally {
            timer.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimer(DelayedTimer delayedTimer) {
        assert (delayedTimer != null && !this.containsTimer(delayedTimer.getTimer()));
        Timer timer = delayedTimer.getTimer();
        timer.getLock().lock();
        try {
            timer.delayedTimer = delayedTimer;
            this.queue.add(delayedTimer);
        }
        finally {
            timer.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTimer(Timer timer) {
        timer.getLock().lock();
        try {
            if (timer.delayedTimer != null) {
                this.queue.remove(timer.delayedTimer);
                timer.delayedTimer = null;
            }
        }
        finally {
            timer.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsTimer(Timer timer) {
        timer.getLock().lock();
        try {
            boolean bl = timer.delayedTimer != null;
            return bl;
        }
        finally {
            timer.getLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.running = true;
        block12: while (true) {
            try {
                while (this.running) {
                    try {
                        Timer timer = ((DelayedTimer)this.queue.take()).getTimer();
                        timer.getLock().lock();
                        try {
                            DelayedTimer delayedTimer = timer.delayedTimer;
                            if (delayedTimer == null) continue block12;
                            timer.post();
                            timer.delayedTimer = null;
                            if (!timer.isRepeats()) continue block12;
                            delayedTimer.setTime(TimerQueue.now() + TimeUnit.MILLISECONDS.toNanos(timer.getDelay()));
                            this.addTimer(delayedTimer);
                        }
                        catch (SecurityException securityException) {}
                        continue block12;
                        finally {
                            timer.getLock().unlock();
                            continue block12;
                        }
                    }
                    catch (InterruptedException ignore) {
                    }
                }
                break;
            }
            catch (ThreadDeath td) {
                TimerQueue timerQueue = this;
                synchronized (timerQueue) {
                    this.running = false;
                    for (DelayedTimer delayedTimer : this.queue) {
                        delayedTimer.getTimer().cancelEvent();
                    }
                    throw td;
                }
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("TimerQueue (");
        boolean isFirst = true;
        for (DelayedTimer delayedTimer : this.queue) {
            if (!isFirst) {
                buf.append(", ");
            }
            buf.append(delayedTimer.getTimer().toString());
            isFirst = false;
        }
        buf.append(")");
        return buf.toString();
    }

    private static final long now() {
        return System.nanoTime() - NANO_ORIGIN;
    }

    static class DelayedTimer
    implements Delayed {
        private static final AtomicLong sequencer = new AtomicLong(0L);
        private final long sequenceNumber;
        private volatile long time;
        private final Timer timer;

        DelayedTimer(Timer timer, long nanos) {
            this.timer = timer;
            this.time = nanos;
            this.sequenceNumber = sequencer.getAndIncrement();
        }

        public final long getDelay(TimeUnit unit) {
            return unit.convert(this.time - TimerQueue.now(), TimeUnit.NANOSECONDS);
        }

        final void setTime(long nanos) {
            this.time = nanos;
        }

        final Timer getTimer() {
            return this.timer;
        }

        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            if (other instanceof DelayedTimer) {
                DelayedTimer x = (DelayedTimer)other;
                long diff = this.time - x.time;
                if (diff < 0L) {
                    return -1;
                }
                if (diff > 0L) {
                    return 1;
                }
                if (this.sequenceNumber < x.sequenceNumber) {
                    return -1;
                }
                return 1;
            }
            long d = this.getDelay(TimeUnit.NANOSECONDS) - other.getDelay(TimeUnit.NANOSECONDS);
            return d == 0L ? 0 : (d < 0L ? -1 : 1);
        }
    }
}

