/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.spi.LocaleNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.LocaleServiceProviderPool;
import sun.util.resources.LocaleData;
import sun.util.resources.OpenListResourceBundle;

public final class Locale
implements Cloneable,
Serializable {
    private static final ConcurrentHashMap<String, Locale> cache = new ConcurrentHashMap(32);
    public static final Locale ENGLISH = Locale.createSingleton("en__", "en", "");
    public static final Locale FRENCH = Locale.createSingleton("fr__", "fr", "");
    public static final Locale GERMAN = Locale.createSingleton("de__", "de", "");
    public static final Locale ITALIAN = Locale.createSingleton("it__", "it", "");
    public static final Locale JAPANESE = Locale.createSingleton("ja__", "ja", "");
    public static final Locale KOREAN = Locale.createSingleton("ko__", "ko", "");
    public static final Locale CHINESE = Locale.createSingleton("zh__", "zh", "");
    public static final Locale SIMPLIFIED_CHINESE = Locale.createSingleton("zh_CN_", "zh", "CN");
    public static final Locale TRADITIONAL_CHINESE = Locale.createSingleton("zh_TW_", "zh", "TW");
    public static final Locale FRANCE = Locale.createSingleton("fr_FR_", "fr", "FR");
    public static final Locale GERMANY = Locale.createSingleton("de_DE_", "de", "DE");
    public static final Locale ITALY = Locale.createSingleton("it_IT_", "it", "IT");
    public static final Locale JAPAN = Locale.createSingleton("ja_JP_", "ja", "JP");
    public static final Locale KOREA = Locale.createSingleton("ko_KR_", "ko", "KR");
    public static final Locale CHINA = SIMPLIFIED_CHINESE;
    public static final Locale PRC = SIMPLIFIED_CHINESE;
    public static final Locale TAIWAN = TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.createSingleton("en_GB_", "en", "GB");
    public static final Locale US = Locale.createSingleton("en_US_", "en", "US");
    public static final Locale CANADA = Locale.createSingleton("en_CA_", "en", "CA");
    public static final Locale CANADA_FRENCH = Locale.createSingleton("fr_CA_", "fr", "CA");
    public static final Locale ROOT = Locale.createSingleton("__", "", "");
    static final long serialVersionUID = 9149081749638150636L;
    private static final int DISPLAY_LANGUAGE = 0;
    private static final int DISPLAY_COUNTRY = 1;
    private static final int DISPLAY_VARIANT = 2;
    private final String language;
    private final String country;
    private final String variant;
    private volatile int hashcode = -1;
    private volatile transient int hashCodeValue = 0;
    private static Locale defaultLocale = null;
    private static volatile String[] isoLanguages = null;
    private static volatile String[] isoCountries = null;

    public Locale(String language, String country, String variant) {
        this.language = this.convertOldISOCodes(language);
        this.country = this.toUpperCase(country).intern();
        this.variant = variant.intern();
    }

    public Locale(String language, String country) {
        this(language, country, "");
    }

    public Locale(String language) {
        this(language, "", "");
    }

    private Locale(String language, String country, boolean flag) {
        this.language = language;
        this.country = country;
        this.variant = "";
    }

    private static Locale createSingleton(String key, String language, String country) {
        Locale locale = new Locale(language, country, false);
        cache.put(key, locale);
        return locale;
    }

    static Locale getInstance(String language, String country, String variant) {
        Locale l;
        if (language == null || country == null || variant == null) {
            throw new NullPointerException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(language).append('_').append(country).append('_').append(variant);
        String key = sb.toString();
        Locale locale = cache.get(key);
        if (locale == null && (l = cache.putIfAbsent(key, locale = new Locale(language, country, variant))) != null) {
            locale = l;
        }
        return locale;
    }

    public static Locale getDefault() {
        if (defaultLocale == null) {
            String variant;
            String country;
            String language = AccessController.doPrivileged(new GetPropertyAction("user.language", "en"));
            String region = AccessController.doPrivileged(new GetPropertyAction("user.region"));
            if (region != null) {
                int i = region.indexOf(95);
                if (i >= 0) {
                    country = region.substring(0, i);
                    variant = region.substring(i + 1);
                } else {
                    country = region;
                    variant = "";
                }
            } else {
                country = AccessController.doPrivileged(new GetPropertyAction("user.country", ""));
                variant = AccessController.doPrivileged(new GetPropertyAction("user.variant", ""));
            }
            defaultLocale = Locale.getInstance(language, country, variant);
        }
        return defaultLocale;
    }

    public static synchronized void setDefault(Locale newLocale) {
        if (newLocale == null) {
            throw new NullPointerException("Can't set default locale to NULL");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new PropertyPermission("user.language", "write"));
        }
        defaultLocale = newLocale;
    }

    public static Locale[] getAvailableLocales() {
        return LocaleServiceProviderPool.getAllAvailableLocales();
    }

    public static String[] getISOCountries() {
        if (isoCountries == null) {
            isoCountries = Locale.getISO2Table("ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBMBMUBNBRNBOBOLBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICSSCGCUCUBCVCPVCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        }
        String[] result = new String[isoCountries.length];
        System.arraycopy(isoCountries, 0, result, 0, isoCountries.length);
        return result;
    }

    public static String[] getISOLanguages() {
        if (isoLanguages == null) {
            isoLanguages = Locale.getISO2Table("aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        }
        String[] result = new String[isoLanguages.length];
        System.arraycopy(isoLanguages, 0, result, 0, isoLanguages.length);
        return result;
    }

    private static final String[] getISO2Table(String table) {
        int len = table.length() / 5;
        String[] isoTable = new String[len];
        int i = 0;
        int j = 0;
        while (i < len) {
            isoTable[i] = table.substring(j, j + 2);
            ++i;
            j += 5;
        }
        return isoTable;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCountry() {
        return this.country;
    }

    public String getVariant() {
        return this.variant;
    }

    public final String toString() {
        boolean l = this.language.length() != 0;
        boolean c = this.country.length() != 0;
        boolean v = this.variant.length() != 0;
        StringBuilder result = new StringBuilder(this.language);
        if (c || l && v) {
            result.append('_').append(this.country);
        }
        if (v && (l || c)) {
            result.append('_').append(this.variant);
        }
        return result.toString();
    }

    public String getISO3Language() throws MissingResourceException {
        String language3 = Locale.getISO3Code(this.language, "aaaarababkaeaveafafrakakaamamhanargararaasasmavavaayaymazazebabakbebelbgbulbhbihbibisbmbambnbenbobodbrbrebsboscacatcechechchacocoscrcrecscescuchucvchvcycymdadandedeudvdivdzdzoeeeweelellenengeoepoesspaetesteueusfafasfffulfifinfjfijfofaofrfrafyfrygaglegdglaglglggngrngugujgvglvhahauhehebhihinhohmohrhrvhthathuhunhyhyehzheriainaidindieileigiboiiiiiikipkinindioidoisislititaiuikuiwhebjajpnjiyidjvjavkakatkgkonkikikkjkuakkkazklkalkmkhmknkankokorkrkaukskaskukurkvkomkwcorkykirlalatlbltzlgluglilimlnlinlolaoltlitlulublvlavmgmlgmhmahmimrimkmkdmlmalmnmonmomolmrmarmsmsamtmltmymyananaunbnobndndenenepngndonlnldnnnnononornrnblnvnavnynyaocociojojiomormororiososspapanpipliplpolpspusptporququermrohrnrunroronrurusrwkinsasanscsrdsdsndsesmesgsagsisinskslkslslvsmsmosnsnasosomsqsqisrsrpsssswstsotsusunsvsweswswatatamteteltgtgkththatitirtktuktltgltntsntotontrturtstsotttattwtwitytahuguigukukrururduzuzbvevenvivievovolwawlnwowolxhxhoyiyidyoyorzazhazhzhozuzul");
        if (language3 == null) {
            throw new MissingResourceException("Couldn't find 3-letter language code for " + this.language, "FormatData_" + this.toString(), "ShortLanguage");
        }
        return language3;
    }

    public String getISO3Country() throws MissingResourceException {
        String country3 = Locale.getISO3Code(this.country, "ADANDAEAREAFAFGAGATGAIAIAALALBAMARMANANTAOAGOAQATAARARGASASMATAUTAUAUSAWABWAXALAAZAZEBABIHBBBRBBDBGDBEBELBFBFABGBGRBHBHRBIBDIBJBENBMBMUBNBRNBOBOLBRBRABSBHSBTBTNBVBVTBWBWABYBLRBZBLZCACANCCCCKCDCODCFCAFCGCOGCHCHECICIVCKCOKCLCHLCMCMRCNCHNCOCOLCRCRICSSCGCUCUBCVCPVCXCXRCYCYPCZCZEDEDEUDJDJIDKDNKDMDMADODOMDZDZAECECUEEESTEGEGYEHESHERERIESESPETETHFIFINFJFJIFKFLKFMFSMFOFROFRFRAGAGABGBGBRGDGRDGEGEOGFGUFGGGGYGHGHAGIGIBGLGRLGMGMBGNGINGPGLPGQGNQGRGRCGSSGSGTGTMGUGUMGWGNBGYGUYHKHKGHMHMDHNHNDHRHRVHTHTIHUHUNIDIDNIEIRLILISRIMIMNININDIOIOTIQIRQIRIRNISISLITITAJEJEYJMJAMJOJORJPJPNKEKENKGKGZKHKHMKIKIRKMCOMKNKNAKPPRKKRKORKWKWTKYCYMKZKAZLALAOLBLBNLCLCALILIELKLKALRLBRLSLSOLTLTULULUXLVLVALYLBYMAMARMCMCOMDMDAMEMNEMGMDGMHMHLMKMKDMLMLIMMMMRMNMNGMOMACMPMNPMQMTQMRMRTMSMSRMTMLTMUMUSMVMDVMWMWIMXMEXMYMYSMZMOZNANAMNCNCLNENERNFNFKNGNGANINICNLNLDNONORNPNPLNRNRUNUNIUNZNZLOMOMNPAPANPEPERPFPYFPGPNGPHPHLPKPAKPLPOLPMSPMPNPCNPRPRIPSPSEPTPRTPWPLWPYPRYQAQATREREUROROURSSRBRURUSRWRWASASAUSBSLBSCSYCSDSDNSESWESGSGPSHSHNSISVNSJSJMSKSVKSLSLESMSMRSNSENSOSOMSRSURSTSTPSVSLVSYSYRSZSWZTCTCATDTCDTFATFTGTGOTHTHATJTJKTKTKLTLTLSTMTKMTNTUNTOTONTRTURTTTTOTVTUVTWTWNTZTZAUAUKRUGUGAUMUMIUSUSAUYURYUZUZBVAVATVCVCTVEVENVGVGBVIVIRVNVNMVUVUTWFWLFWSWSMYEYEMYTMYTZAZAFZMZMBZWZWE");
        if (country3 == null) {
            throw new MissingResourceException("Couldn't find 3-letter country code for " + this.country, "FormatData_" + this.toString(), "ShortCountry");
        }
        return country3;
    }

    private static final String getISO3Code(String iso2Code, String table) {
        int tableLength;
        int codeLength = iso2Code.length();
        if (codeLength == 0) {
            return "";
        }
        int index = tableLength = table.length();
        if (codeLength == 2) {
            char c1 = iso2Code.charAt(0);
            char c2 = iso2Code.charAt(1);
            for (index = 0; index < tableLength && (table.charAt(index) != c1 || table.charAt(index + 1) != c2); index += 5) {
            }
        }
        return index < tableLength ? table.substring(index + 2, index + 5) : null;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale inLocale) {
        return this.getDisplayString(this.language, inLocale, 0);
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale inLocale) {
        return this.getDisplayString(this.country, inLocale, 1);
    }

    private String getDisplayString(String code, Locale inLocale, int type) {
        if (code.length() == 0) {
            return "";
        }
        if (inLocale == null) {
            throw new NullPointerException();
        }
        try {
            OpenListResourceBundle bundle = LocaleData.getLocaleNames(inLocale);
            String key = type == 2 ? "%%" + code : code;
            String result = null;
            LocaleServiceProviderPool pool = LocaleServiceProviderPool.getPool(LocaleNameProvider.class);
            if (pool.hasProviders()) {
                result = pool.getLocalizedObject(LocaleNameGetter.INSTANCE, inLocale, bundle, key, type, code);
            }
            if (result == null) {
                result = bundle.getString(key);
            }
            if (result != null) {
                return result;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return code;
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale inLocale) {
        if (this.variant.length() == 0) {
            return "";
        }
        OpenListResourceBundle bundle = LocaleData.getLocaleNames(inLocale);
        String[] names = this.getDisplayVariantArray(bundle, inLocale);
        String listPattern = null;
        String listCompositionPattern = null;
        try {
            listPattern = bundle.getString("ListPattern");
            listCompositionPattern = bundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        return Locale.formatList(names, listPattern, listCompositionPattern);
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale inLocale) {
        OpenListResourceBundle bundle = LocaleData.getLocaleNames(inLocale);
        String languageName = this.getDisplayLanguage(inLocale);
        String countryName = this.getDisplayCountry(inLocale);
        String[] variantNames = this.getDisplayVariantArray(bundle, inLocale);
        String displayNamePattern = null;
        String listPattern = null;
        String listCompositionPattern = null;
        try {
            displayNamePattern = bundle.getString("DisplayNamePattern");
            listPattern = bundle.getString("ListPattern");
            listCompositionPattern = bundle.getString("ListCompositionPattern");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        String mainName = null;
        String[] qualifierNames = null;
        if (languageName.length() != 0) {
            mainName = languageName;
            if (countryName.length() != 0) {
                qualifierNames = new String[variantNames.length + 1];
                System.arraycopy(variantNames, 0, qualifierNames, 1, variantNames.length);
                qualifierNames[0] = countryName;
            } else {
                qualifierNames = variantNames;
            }
        } else if (countryName.length() != 0) {
            mainName = countryName;
            qualifierNames = variantNames;
        } else {
            return Locale.formatList(variantNames, listPattern, listCompositionPattern);
        }
        Object[] displayNames = new Object[]{new Integer(qualifierNames.length != 0 ? 2 : 1), mainName, qualifierNames.length != 0 ? Locale.formatList(qualifierNames, listPattern, listCompositionPattern) : null};
        if (displayNamePattern != null) {
            return new MessageFormat(displayNamePattern).format(displayNames);
        }
        StringBuilder result = new StringBuilder();
        result.append((String)displayNames[1]);
        if (displayNames.length > 2) {
            result.append(" (");
            result.append((String)displayNames[2]);
            result.append(')');
        }
        return result.toString();
    }

    public Object clone() {
        try {
            Locale that = (Locale)super.clone();
            return that;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int hashCode() {
        int hc = this.hashCodeValue;
        if (hc == 0) {
            this.hashCodeValue = hc = this.language.hashCode() << 8 ^ this.country.hashCode() ^ this.variant.hashCode() << 4;
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Locale)) {
            return false;
        }
        Locale other = (Locale)obj;
        return this.language == other.language && this.country == other.country && this.variant == other.variant;
    }

    private String[] getDisplayVariantArray(OpenListResourceBundle bundle, Locale inLocale) {
        StringTokenizer tokenizer = new StringTokenizer(this.variant, "_");
        String[] names = new String[tokenizer.countTokens()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.getDisplayString(tokenizer.nextToken(), inLocale, 2);
        }
        return names;
    }

    private static String formatList(String[] stringList, String listPattern, String listCompositionPattern) {
        if (listPattern == null || listCompositionPattern == null) {
            StringBuffer result = new StringBuffer();
            for (int i = 0; i < stringList.length; ++i) {
                if (i > 0) {
                    result.append(',');
                }
                result.append(stringList[i]);
            }
            return result.toString();
        }
        if (stringList.length > 3) {
            MessageFormat format = new MessageFormat(listCompositionPattern);
            stringList = Locale.composeList(format, stringList);
        }
        Object[] args = new Object[stringList.length + 1];
        System.arraycopy(stringList, 0, args, 1, stringList.length);
        args[0] = new Integer(stringList.length);
        MessageFormat format = new MessageFormat(listPattern);
        return format.format(args);
    }

    private static String[] composeList(MessageFormat format, String[] list) {
        if (list.length <= 3) {
            return list;
        }
        String[] listItems = new String[]{list[0], list[1]};
        String newItem = format.format(listItems);
        String[] newList = new String[list.length - 1];
        System.arraycopy(list, 2, newList, 1, newList.length - 1);
        newList[0] = newItem;
        return Locale.composeList(format, newList);
    }

    private Object readResolve() throws ObjectStreamException {
        return Locale.getInstance(this.language, this.country, this.variant);
    }

    private String toLowerCase(String str) {
        char[] buf = new char[str.length()];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = Character.toLowerCase(str.charAt(i));
        }
        return new String(buf);
    }

    private String toUpperCase(String str) {
        char[] buf = new char[str.length()];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = Character.toUpperCase(str.charAt(i));
        }
        return new String(buf);
    }

    private String convertOldISOCodes(String language) {
        if ((language = this.toLowerCase(language).intern()) == "he") {
            return "iw";
        }
        if (language == "yi") {
            return "ji";
        }
        if (language == "id") {
            return "in";
        }
        return language;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocaleNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<LocaleNameProvider, String> {
        private static final LocaleNameGetter INSTANCE = new LocaleNameGetter();

        private LocaleNameGetter() {
        }

        @Override
        public String getObject(LocaleNameProvider localeNameProvider, Locale locale, String key, Object ... params) {
            assert (params.length == 2);
            int type = (Integer)params[0];
            String code = (String)params[1];
            switch (type) {
                case 0: {
                    return localeNameProvider.getDisplayLanguage(code, locale);
                }
                case 1: {
                    return localeNameProvider.getDisplayCountry(code, locale);
                }
                case 2: {
                    return localeNameProvider.getDisplayVariant(code, locale);
                }
            }
            assert (false);
            return null;
        }
    }
}

