/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteBufferAsShortBufferB;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;

class ByteBufferAsShortBufferRB
extends ByteBufferAsShortBufferB {
    ByteBufferAsShortBufferRB(ByteBuffer bb) {
        super(bb);
    }

    ByteBufferAsShortBufferRB(ByteBuffer bb, int mark, int pos, int lim, int cap, int off) {
        super(bb, mark, pos, lim, cap, off);
    }

    public ShortBuffer slice() {
        int pos = this.position();
        int lim = this.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int off = (pos << 1) + this.offset;
        assert (off >= 0);
        return new ByteBufferAsShortBufferRB(this.bb, -1, 0, rem, rem, off);
    }

    public ShortBuffer duplicate() {
        return new ByteBufferAsShortBufferRB(this.bb, this.markValue(), this.position(), this.limit(), this.capacity(), this.offset);
    }

    public ShortBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public ShortBuffer put(short x) {
        throw new ReadOnlyBufferException();
    }

    public ShortBuffer put(int i, short x) {
        throw new ReadOnlyBufferException();
    }

    public ShortBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public boolean isDirect() {
        return this.bb.isDirect();
    }

    public boolean isReadOnly() {
        return true;
    }

    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }
}

