/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.MultipleGradientPaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

final class LinearGradientPaintContext
extends MultipleGradientPaintContext {
    private float dgdX;
    private float dgdY;
    private float gc;

    LinearGradientPaintContext(LinearGradientPaint paint, ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform t, RenderingHints hints, Point2D start, Point2D end, float[] fractions, Color[] colors, MultipleGradientPaint.CycleMethod cycleMethod, MultipleGradientPaint.ColorSpaceType colorSpace) {
        super(paint, cm, deviceBounds, userBounds, t, hints, fractions, colors, cycleMethod, colorSpace);
        float startx = (float)start.getX();
        float starty = (float)start.getY();
        float endx = (float)end.getX();
        float endy = (float)end.getY();
        float dx = endx - startx;
        float dy = endy - starty;
        float dSq = dx * dx + dy * dy;
        float constX = dx / dSq;
        float constY = dy / dSq;
        this.dgdX = this.a00 * constX + this.a10 * constY;
        this.dgdY = this.a01 * constX + this.a11 * constY;
        this.gc = (this.a02 - startx) * constX + (this.a12 - starty) * constY;
    }

    protected void fillRaster(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        float g = 0.0f;
        int rowLimit = off + w;
        float initConst = this.dgdX * (float)x + this.gc;
        for (int i = 0; i < h; ++i) {
            g = initConst + this.dgdY * (float)(y + i);
            while (off < rowLimit) {
                pixels[off++] = this.indexIntoGradientsArrays(g);
                g += this.dgdX;
            }
            rowLimit = (off += adjust) + w;
        }
    }
}

